/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.cluster;

import com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.alibaba.rocketmq.common.protocol.body.ClusterInfo;
import com.alibaba.rocketmq.common.protocol.body.KVTable;
import com.alibaba.rocketmq.common.protocol.route.BrokerData;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.SubCommand;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ClusterListSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "clusterList";
    }

    @Override
    public String commandDesc() {
        return "List all of clusters";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("m", "moreStats", false, "Print more stats");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    private void printClusterBaseInfo(DefaultMQAdminExt defaultMQAdminExt) throws RemotingConnectException, RemotingTimeoutException, RemotingSendRequestException, InterruptedException, MQBrokerException {
        ClusterInfo clusterInfoSerializeWrapper = defaultMQAdminExt.examineBrokerClusterInfo();
        System.out.printf("%-16s  %-32s  %-4s  %-22s %-22s %11s %11s\n", "#Cluster Name", "#Broker Name", "#BID", "#Addr", "#Version", "#InTPS", "#OutTPS");
        Iterator itCluster = clusterInfoSerializeWrapper.getClusterAddrTable().entrySet().iterator();
        while (itCluster.hasNext()) {
            Map.Entry next = itCluster.next();
            String clusterName = (String)next.getKey();
            TreeSet brokerNameSet = new TreeSet();
            brokerNameSet.addAll((Collection)next.getValue());
            for (String brokerName : brokerNameSet) {
                BrokerData brokerData = (BrokerData)clusterInfoSerializeWrapper.getBrokerAddrTable().get(brokerName);
                if (brokerData == null) continue;
                for (Map.Entry next1 : brokerData.getBrokerAddrs().entrySet()) {
                    double in = 0.0;
                    double out = 0.0;
                    String version = "";
                    try {
                        KVTable kvTable = defaultMQAdminExt.fetchBrokerRuntimeStats((String)next1.getValue());
                        String putTps = (String)kvTable.getTable().get("putTps");
                        String getTransferedTps = (String)kvTable.getTable().get("getTransferedTps");
                        version = (String)kvTable.getTable().get("brokerVersionDesc");
                        String[] tpss = putTps.split(" ");
                        if (tpss != null && tpss.length > 0) {
                            in = Double.parseDouble(tpss[0]);
                        }
                        if ((tpss = getTransferedTps.split(" ")) != null && tpss.length > 0) {
                            out = Double.parseDouble(tpss[0]);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    System.out.printf("%-16s  %-32s  %-4s  %-22s %-22s %11.2f %11.2f\n", clusterName, brokerName, (long)((Long)next1.getKey()), next1.getValue(), version, in, out);
                }
            }
            if (!itCluster.hasNext()) continue;
            System.out.println("");
        }
    }

    private void printClusterMoreStats(DefaultMQAdminExt defaultMQAdminExt) throws RemotingConnectException, RemotingTimeoutException, RemotingSendRequestException, InterruptedException, MQBrokerException {
        ClusterInfo clusterInfoSerializeWrapper = defaultMQAdminExt.examineBrokerClusterInfo();
        System.out.printf("%-16s  %-32s %14s %14s %14s %14s\n", "#Cluster Name", "#Broker Name", "#InTotalYest", "#OutTotalYest", "#InTotalToday", "#OutTotalToday");
        Iterator itCluster = clusterInfoSerializeWrapper.getClusterAddrTable().entrySet().iterator();
        while (itCluster.hasNext()) {
            Map.Entry next = itCluster.next();
            String clusterName = (String)next.getKey();
            TreeSet brokerNameSet = new TreeSet();
            brokerNameSet.addAll((Collection)next.getValue());
            for (String brokerName : brokerNameSet) {
                BrokerData brokerData = (BrokerData)clusterInfoSerializeWrapper.getBrokerAddrTable().get(brokerName);
                if (brokerData == null) continue;
                for (Map.Entry next1 : brokerData.getBrokerAddrs().entrySet()) {
                    long InTotalYest = 0L;
                    long OutTotalYest = 0L;
                    long InTotalToday = 0L;
                    long OutTotalToday = 0L;
                    try {
                        KVTable kvTable = defaultMQAdminExt.fetchBrokerRuntimeStats((String)next1.getValue());
                        String msgPutTotalYesterdayMorning = (String)kvTable.getTable().get("msgPutTotalYesterdayMorning");
                        String msgPutTotalTodayMorning = (String)kvTable.getTable().get("msgPutTotalTodayMorning");
                        String msgPutTotalTodayNow = (String)kvTable.getTable().get("msgPutTotalTodayNow");
                        String msgGetTotalYesterdayMorning = (String)kvTable.getTable().get("msgGetTotalYesterdayMorning");
                        String msgGetTotalTodayMorning = (String)kvTable.getTable().get("msgGetTotalTodayMorning");
                        String msgGetTotalTodayNow = (String)kvTable.getTable().get("msgGetTotalTodayNow");
                        InTotalYest = Long.parseLong(msgPutTotalTodayMorning) - Long.parseLong(msgPutTotalYesterdayMorning);
                        OutTotalYest = Long.parseLong(msgGetTotalTodayMorning) - Long.parseLong(msgGetTotalYesterdayMorning);
                        InTotalToday = Long.parseLong(msgPutTotalTodayNow) - Long.parseLong(msgPutTotalTodayMorning);
                        OutTotalToday = Long.parseLong(msgGetTotalTodayNow) - Long.parseLong(msgGetTotalTodayMorning);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    System.out.printf("%-16s  %-32s %14d %14d %14d %14d\n", clusterName, brokerName, InTotalYest, OutTotalYest, InTotalToday, OutTotalToday);
                }
            }
            if (!itCluster.hasNext()) continue;
            System.out.println("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            if (commandLine.hasOption('m')) {
                this.printClusterMoreStats(defaultMQAdminExt);
            } else {
                this.printClusterBaseInfo(defaultMQAdminExt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

