/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.admin;

import com.alibaba.rocketmq.client.ClientConfig;
import com.alibaba.rocketmq.client.QueryResult;
import com.alibaba.rocketmq.client.admin.MQAdminExtInner;
import com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.impl.MQClientManager;
import com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.common.MixAll;
import com.alibaba.rocketmq.common.ServiceState;
import com.alibaba.rocketmq.common.TopicConfig;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.admin.ConsumeStats;
import com.alibaba.rocketmq.common.admin.OffsetWrapper;
import com.alibaba.rocketmq.common.admin.RollbackStats;
import com.alibaba.rocketmq.common.admin.TopicOffset;
import com.alibaba.rocketmq.common.admin.TopicStatsTable;
import com.alibaba.rocketmq.common.help.FAQUrl;
import com.alibaba.rocketmq.common.message.MessageExt;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.common.protocol.body.BrokerStatsData;
import com.alibaba.rocketmq.common.protocol.body.ClusterInfo;
import com.alibaba.rocketmq.common.protocol.body.ConsumeMessageDirectlyResult;
import com.alibaba.rocketmq.common.protocol.body.ConsumerConnection;
import com.alibaba.rocketmq.common.protocol.body.ConsumerRunningInfo;
import com.alibaba.rocketmq.common.protocol.body.GroupList;
import com.alibaba.rocketmq.common.protocol.body.KVTable;
import com.alibaba.rocketmq.common.protocol.body.ProducerConnection;
import com.alibaba.rocketmq.common.protocol.body.QueueTimeSpan;
import com.alibaba.rocketmq.common.protocol.body.TopicList;
import com.alibaba.rocketmq.common.protocol.header.UpdateConsumerOffsetRequestHeader;
import com.alibaba.rocketmq.common.protocol.heartbeat.SubscriptionData;
import com.alibaba.rocketmq.common.protocol.route.BrokerData;
import com.alibaba.rocketmq.common.protocol.route.QueueData;
import com.alibaba.rocketmq.common.protocol.route.TopicRouteData;
import com.alibaba.rocketmq.common.subscription.SubscriptionGroupConfig;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.alibaba.rocketmq.remoting.exception.RemotingException;
import com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.admin.MQAdminExt;
import com.alibaba.rocketmq.tools.admin.api.MessageTrack;
import com.alibaba.rocketmq.tools.admin.api.TrackType;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;

public class DefaultMQAdminExtImpl
implements MQAdminExt,
MQAdminExtInner {
    private final Logger log = ClientLogger.getLog();
    private final DefaultMQAdminExt defaultMQAdminExt;
    private ServiceState serviceState = ServiceState.CREATE_JUST;
    private MQClientInstance mqClientInstance;
    private RPCHook rpcHook;

    public DefaultMQAdminExtImpl(DefaultMQAdminExt defaultMQAdminExt) {
        this(defaultMQAdminExt, null);
    }

    public DefaultMQAdminExtImpl(DefaultMQAdminExt defaultMQAdminExt, RPCHook rpcHook) {
        this.defaultMQAdminExt = defaultMQAdminExt;
        this.rpcHook = rpcHook;
    }

    @Override
    public void start() throws MQClientException {
        switch (this.serviceState) {
            case CREATE_JUST: {
                this.serviceState = ServiceState.START_FAILED;
                this.defaultMQAdminExt.changeInstanceNameToPID();
                this.mqClientInstance = MQClientManager.getInstance().getAndCreateMQClientInstance((ClientConfig)this.defaultMQAdminExt, this.rpcHook);
                boolean registerOK = this.mqClientInstance.registerAdminExt(this.defaultMQAdminExt.getAdminExtGroup(), (MQAdminExtInner)this);
                if (!registerOK) {
                    this.serviceState = ServiceState.CREATE_JUST;
                    throw new MQClientException("The adminExt group[" + this.defaultMQAdminExt.getAdminExtGroup() + "] has created already, specifed another name please." + FAQUrl.suggestTodo((String)"https://github.com/alibaba/RocketMQ/issues/40"), null);
                }
                this.mqClientInstance.start();
                this.log.info("the adminExt [{}] start OK", (Object)this.defaultMQAdminExt.getAdminExtGroup());
                this.serviceState = ServiceState.RUNNING;
                break;
            }
            case RUNNING: 
            case START_FAILED: 
            case SHUTDOWN_ALREADY: {
                throw new MQClientException("The AdminExt service state not OK, maybe started once, " + this.serviceState + FAQUrl.suggestTodo((String)"https://github.com/alibaba/RocketMQ/issues/43"), null);
            }
        }
    }

    @Override
    public void shutdown() {
        switch (this.serviceState) {
            case CREATE_JUST: {
                break;
            }
            case RUNNING: {
                this.mqClientInstance.unregisterAdminExt(this.defaultMQAdminExt.getAdminExtGroup());
                this.mqClientInstance.shutdown();
                this.log.info("the adminExt [{}] shutdown OK", (Object)this.defaultMQAdminExt.getAdminExtGroup());
                this.serviceState = ServiceState.SHUTDOWN_ALREADY;
                break;
            }
            case SHUTDOWN_ALREADY: {
                break;
            }
        }
    }

    @Override
    public void createAndUpdateTopicConfig(String addr, TopicConfig config) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().createTopic(addr, this.defaultMQAdminExt.getCreateTopicKey(), config, 3000L);
    }

    @Override
    public void createAndUpdateSubscriptionGroupConfig(String addr, SubscriptionGroupConfig config) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().createSubscriptionGroup(addr, config, 3000L);
    }

    @Override
    public SubscriptionGroupConfig examineSubscriptionGroupConfig(String addr, String group) {
        return null;
    }

    @Override
    public TopicConfig examineTopicConfig(String addr, String topic) {
        return null;
    }

    @Override
    public TopicStatsTable examineTopicStats(String topic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        TopicStatsTable topicStatsTable = new TopicStatsTable();
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            TopicStatsTable tst = this.mqClientInstance.getMQClientAPIImpl().getTopicStatsInfo(addr, topic, 3000L);
            topicStatsTable.getOffsetTable().putAll(tst.getOffsetTable());
        }
        if (topicStatsTable.getOffsetTable().isEmpty()) {
            throw new MQClientException("Not found the topic stats info", null);
        }
        return topicStatsTable;
    }

    @Override
    public ConsumeStats examineConsumeStats(String consumerGroup, String topic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        String retryTopic = MixAll.getRetryTopic((String)consumerGroup);
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(retryTopic);
        ConsumeStats result = new ConsumeStats();
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            ConsumeStats consumeStats = this.mqClientInstance.getMQClientAPIImpl().getConsumeStats(addr, consumerGroup, topic, 15000L);
            result.getOffsetTable().putAll(consumeStats.getOffsetTable());
            long value = result.getConsumeTps() + consumeStats.getConsumeTps();
            result.setConsumeTps(value);
        }
        if (result.getOffsetTable().isEmpty()) {
            throw new MQClientException("Not found the consumer group consume stats, because return offset table is empty, maybe the consumer not consume any message", null);
        }
        return result;
    }

    @Override
    public ConsumeStats examineConsumeStats(String consumerGroup) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        return this.examineConsumeStats(consumerGroup, null);
    }

    @Override
    public ClusterInfo examineBrokerClusterInfo() throws InterruptedException, MQBrokerException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerClusterInfo(3000L);
    }

    @Override
    public TopicRouteData examineTopicRouteInfo(String topic) throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(topic, 3000L);
    }

    @Override
    public void putKVConfig(String namespace, String key, String value) {
    }

    @Override
    public String getKVConfig(String namespace, String key) throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getKVConfigValue(namespace, key, 3000L);
    }

    public void createTopic(String key, String newTopic, int queueNum) throws MQClientException {
        this.createTopic(key, newTopic, queueNum, 0);
    }

    public void createTopic(String key, String newTopic, int queueNum, int topicSysFlag) throws MQClientException {
        this.mqClientInstance.getMQAdminImpl().createTopic(key, newTopic, queueNum, topicSysFlag);
    }

    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().searchOffset(mq, timestamp);
    }

    public long maxOffset(MessageQueue mq) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().maxOffset(mq);
    }

    public long minOffset(MessageQueue mq) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().minOffset(mq);
    }

    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().earliestMsgStoreTime(mq);
    }

    public MessageExt viewMessage(String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQAdminImpl().viewMessage(msgId);
    }

    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        return this.mqClientInstance.getMQAdminImpl().queryMessage(topic, key, maxNum, begin, end);
    }

    @Override
    public ConsumerConnection examineConsumerConnectionInfo(String consumerGroup) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        String topic = MixAll.getRetryTopic((String)consumerGroup);
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        ConsumerConnection result = new ConsumerConnection();
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            return this.mqClientInstance.getMQClientAPIImpl().getConsumerConnectionList(addr, consumerGroup, 3000L);
        }
        if (result.getConnectionSet().isEmpty()) {
            throw new MQClientException(206, "Not found the consumer group connection");
        }
        return result;
    }

    @Override
    public ProducerConnection examineProducerConnectionInfo(String producerGroup, String topic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        ProducerConnection result = new ProducerConnection();
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            return this.mqClientInstance.getMQClientAPIImpl().getProducerConnectionList(addr, producerGroup, 3000L);
        }
        if (result.getConnectionSet().isEmpty()) {
            throw new MQClientException("Not found the consumer group connection", null);
        }
        return result;
    }

    @Override
    public int wipeWritePermOfBroker(String namesrvAddr, String brokerName) throws RemotingCommandException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().wipeWritePermOfBroker(namesrvAddr, brokerName, 3000L);
    }

    @Override
    public List<String> getNameServerAddressList() {
        return this.mqClientInstance.getMQClientAPIImpl().getNameServerAddressList();
    }

    @Override
    public TopicList fetchAllTopicList() throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getTopicListFromNameServer(3000L);
    }

    @Override
    public KVTable fetchBrokerRuntimeStats(String brokerAddr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerRuntimeInfo(brokerAddr, 3000L);
    }

    @Override
    public void deleteTopicInBroker(Set<String> addrs, String topic) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        for (String addr : addrs) {
            this.mqClientInstance.getMQClientAPIImpl().deleteTopicInBroker(addr, topic, 3000L);
        }
    }

    @Override
    public void deleteTopicInNameServer(Set<String> addrs, String topic) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        if (addrs == null) {
            String ns = this.mqClientInstance.getMQClientAPIImpl().fetchNameServerAddr();
            addrs = new HashSet<String>(Arrays.asList(ns.split(";")));
        }
        for (String addr : addrs) {
            this.mqClientInstance.getMQClientAPIImpl().deleteTopicInNameServer(addr, topic, 3000L);
        }
    }

    @Override
    public void deleteSubscriptionGroup(String addr, String groupName) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().deleteSubscriptionGroup(addr, groupName, 3000L);
    }

    @Override
    public void createAndUpdateKvConfig(String namespace, String key, String value) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().putKVConfigValue(namespace, key, value, 3000L);
    }

    @Override
    public void deleteKvConfig(String namespace, String key) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().deleteKVConfigValue(namespace, key, 3000L);
    }

    @Override
    public String getProjectGroupByIp(String ip) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().getProjectGroupByIp(ip, 3000L);
    }

    @Override
    public String getIpsByProjectGroup(String projectGroup) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        String namespace = "PROJECT_CONFIG";
        return this.mqClientInstance.getMQClientAPIImpl().getKVConfigByValue(namespace, projectGroup, 3000L);
    }

    @Override
    public void deleteIpsByProjectGroup(String projectGroup) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        String namespace = "PROJECT_CONFIG";
        this.mqClientInstance.getMQClientAPIImpl().deleteKVConfigByValue(namespace, projectGroup, 3000L);
    }

    @Override
    public List<RollbackStats> resetOffsetByTimestampOld(String consumerGroup, String topic, long timestamp, boolean force) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        ArrayList<RollbackStats> rollbackStatsList = new ArrayList<RollbackStats>();
        HashMap<String, Integer> topicRouteMap = new HashMap<String, Integer>();
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            for (QueueData queueData : topicRouteData.getQueueDatas()) {
                topicRouteMap.put(bd.selectBrokerAddr(), queueData.getReadQueueNums());
            }
        }
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            RollbackStats rollbackStats;
            OffsetWrapper offsetWrapper;
            MessageQueue queue;
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            ConsumeStats consumeStats = this.mqClientInstance.getMQClientAPIImpl().getConsumeStats(addr, consumerGroup, 3000L);
            boolean hasConsumed = false;
            for (Map.Entry entry : consumeStats.getOffsetTable().entrySet()) {
                queue = (MessageQueue)entry.getKey();
                offsetWrapper = (OffsetWrapper)entry.getValue();
                if (!topic.equals(queue.getTopic())) continue;
                hasConsumed = true;
                rollbackStats = this.resetOffsetConsumeOffset(addr, consumerGroup, queue, offsetWrapper, timestamp, force);
                rollbackStatsList.add(rollbackStats);
            }
            if (hasConsumed) continue;
            HashMap topicStatus = this.mqClientInstance.getMQClientAPIImpl().getTopicStatsInfo(addr, topic, 3000L).getOffsetTable();
            for (int i = 0; i < (Integer)topicRouteMap.get(addr); ++i) {
                queue = new MessageQueue(topic, bd.getBrokerName(), i);
                offsetWrapper = new OffsetWrapper();
                offsetWrapper.setBrokerOffset(((TopicOffset)topicStatus.get(queue)).getMaxOffset());
                offsetWrapper.setConsumerOffset(((TopicOffset)topicStatus.get(queue)).getMinOffset());
                rollbackStats = this.resetOffsetConsumeOffset(addr, consumerGroup, queue, offsetWrapper, timestamp, force);
                rollbackStatsList.add(rollbackStats);
            }
        }
        return rollbackStatsList;
    }

    private RollbackStats resetOffsetConsumeOffset(String brokerAddr, String consumeGroup, MessageQueue queue, OffsetWrapper offsetWrapper, long timestamp, boolean force) throws RemotingException, InterruptedException, MQBrokerException {
        long resetOffset = this.mqClientInstance.getMQClientAPIImpl().searchOffset(brokerAddr, queue.getTopic(), queue.getQueueId(), timestamp, 3000L);
        RollbackStats rollbackStats = new RollbackStats();
        rollbackStats.setBrokerName(queue.getBrokerName());
        rollbackStats.setQueueId((long)queue.getQueueId());
        rollbackStats.setBrokerOffset(offsetWrapper.getBrokerOffset());
        rollbackStats.setConsumerOffset(offsetWrapper.getConsumerOffset());
        rollbackStats.setTimestampOffset(resetOffset);
        rollbackStats.setRollbackOffset(offsetWrapper.getConsumerOffset());
        if (force || resetOffset <= offsetWrapper.getConsumerOffset()) {
            rollbackStats.setRollbackOffset(resetOffset);
            UpdateConsumerOffsetRequestHeader requestHeader = new UpdateConsumerOffsetRequestHeader();
            requestHeader.setConsumerGroup(consumeGroup);
            requestHeader.setTopic(queue.getTopic());
            requestHeader.setQueueId(Integer.valueOf(queue.getQueueId()));
            requestHeader.setCommitOffset(Long.valueOf(resetOffset));
            this.mqClientInstance.getMQClientAPIImpl().updateConsumerOffset(brokerAddr, requestHeader, 3000L);
        }
        return rollbackStats;
    }

    @Override
    public KVTable getKVListByNamespace(String namespace) throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getKVListByNamespace(namespace, 5000L);
    }

    @Override
    public void updateBrokerConfig(String brokerAddr, Properties properties) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, UnsupportedEncodingException, InterruptedException, MQBrokerException {
        this.mqClientInstance.getMQClientAPIImpl().updateBrokerConfig(brokerAddr, properties, 5000L);
    }

    @Override
    public Map<MessageQueue, Long> resetOffsetByTimestamp(String topic, String group, long timestamp, boolean isForce) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        List brokerDatas = topicRouteData.getBrokerDatas();
        HashMap<MessageQueue, Long> allOffsetTable = new HashMap<MessageQueue, Long>();
        if (brokerDatas != null) {
            for (BrokerData brokerData : brokerDatas) {
                Map offsetTable;
                String addr = brokerData.selectBrokerAddr();
                if (addr == null || (offsetTable = this.mqClientInstance.getMQClientAPIImpl().invokeBrokerToResetOffset(addr, topic, group, timestamp, isForce, 5000L)) == null) continue;
                allOffsetTable.putAll(offsetTable);
            }
        }
        return allOffsetTable;
    }

    @Override
    public Map<String, Map<MessageQueue, Long>> getConsumeStatus(String topic, String group, String clientAddr) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        String addr;
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        List brokerDatas = topicRouteData.getBrokerDatas();
        if (brokerDatas != null && brokerDatas.size() > 0 && (addr = ((BrokerData)brokerDatas.get(0)).selectBrokerAddr()) != null) {
            return this.mqClientInstance.getMQClientAPIImpl().invokeBrokerToGetConsumerStatus(addr, topic, group, clientAddr, 5000L);
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public void createOrUpdateOrderConf(String key, String value, boolean isCluster) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        if (isCluster) {
            this.mqClientInstance.getMQClientAPIImpl().putKVConfigValue("ORDER_TOPIC_CONFIG", key, value, 3000L);
        } else {
            String oldOrderConfs = null;
            try {
                oldOrderConfs = this.mqClientInstance.getMQClientAPIImpl().getKVConfigValue("ORDER_TOPIC_CONFIG", key, 3000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, String> orderConfMap = new HashMap<String, String>();
            if (!UtilAll.isBlank((String)oldOrderConfs)) {
                String[] oldOrderConfArr;
                for (String oldOrderConf : oldOrderConfArr = oldOrderConfs.split(";")) {
                    String[] items = oldOrderConf.split(":");
                    orderConfMap.put(items[0], oldOrderConf);
                }
            }
            String[] items = value.split(":");
            orderConfMap.put(items[0], value);
            StringBuilder newOrderConf = new StringBuilder();
            String splitor = "";
            for (String tmp : orderConfMap.keySet()) {
                newOrderConf.append(splitor).append((String)orderConfMap.get(tmp));
                splitor = ";";
            }
            this.mqClientInstance.getMQClientAPIImpl().putKVConfigValue("ORDER_TOPIC_CONFIG", key, newOrderConf.toString(), 3000L);
        }
    }

    @Override
    public GroupList queryTopicConsumeByWho(String topic) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        BrokerData bd;
        String addr;
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        Iterator i$ = topicRouteData.getBrokerDatas().iterator();
        if (i$.hasNext() && (addr = (bd = (BrokerData)i$.next()).selectBrokerAddr()) != null) {
            return this.mqClientInstance.getMQClientAPIImpl().queryTopicConsumeByWho(addr, topic, 3000L);
        }
        return null;
    }

    @Override
    public Set<QueueTimeSpan> queryConsumeTimeSpan(String topic, String group) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        HashSet spanSet = new HashSet();
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            spanSet.addAll(this.mqClientInstance.getMQClientAPIImpl().queryConsumeTimeSpan(addr, topic, group, 3000L));
        }
        return null;
    }

    @Override
    public void resetOffsetNew(String consumerGroup, String topic, long timestamp) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        try {
            this.resetOffsetByTimestamp(topic, consumerGroup, timestamp, true);
        }
        catch (MQClientException e) {
            if (206 == e.getResponseCode()) {
                this.resetOffsetByTimestampOld(consumerGroup, topic, timestamp, true);
                return;
            }
            throw e;
        }
    }

    public boolean cleanExpiredConsumerQueueByCluster(ClusterInfo clusterInfo, String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        String[] addrs;
        boolean result = false;
        for (String addr : addrs = clusterInfo.retrieveAllAddrByCluster(cluster)) {
            result = this.cleanExpiredConsumerQueueByAddr(addr);
        }
        return result;
    }

    @Override
    public boolean cleanExpiredConsumerQueue(String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = false;
        try {
            ClusterInfo clusterInfo = this.examineBrokerClusterInfo();
            if (null == cluster || "".equals(cluster)) {
                for (String targetCluster : clusterInfo.retrieveAllClusterNames()) {
                    result = this.cleanExpiredConsumerQueueByCluster(clusterInfo, targetCluster);
                }
            } else {
                result = this.cleanExpiredConsumerQueueByCluster(clusterInfo, cluster);
            }
        }
        catch (MQBrokerException e) {
            this.log.error("cleanExpiredConsumerQueue error.", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean cleanExpiredConsumerQueueByAddr(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = this.mqClientInstance.getMQClientAPIImpl().cleanExpiredConsumeQueue(addr, 3000L);
        this.log.warn("clean expired ConsumeQueue on target " + addr + " broker " + result);
        return result;
    }

    @Override
    public ConsumerRunningInfo getConsumerRunningInfo(String consumerGroup, String clientId, boolean jstack) throws RemotingException, MQClientException, InterruptedException {
        String topic = "%RETRY%" + consumerGroup;
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        List brokerDatas = topicRouteData.getBrokerDatas();
        if (brokerDatas != null) {
            for (BrokerData brokerData : brokerDatas) {
                String addr = brokerData.selectBrokerAddr();
                if (addr == null) continue;
                return this.mqClientInstance.getMQClientAPIImpl().getConsumerRunningInfo(addr, consumerGroup, clientId, jstack, 12000L);
            }
        }
        return null;
    }

    @Override
    public ConsumeMessageDirectlyResult consumeMessageDirectly(String consumerGroup, String clientId, String msgId) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        MessageExt msg = this.viewMessage(msgId);
        return this.mqClientInstance.getMQClientAPIImpl().consumeMessageDirectly(RemotingUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), consumerGroup, clientId, msgId, 10000L);
    }

    public boolean consumed(MessageExt msg, String group) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        ConsumeStats cstats = this.examineConsumeStats(group);
        ClusterInfo ci = this.examineBrokerClusterInfo();
        for (Map.Entry next : cstats.getOffsetTable().entrySet()) {
            String addr;
            BrokerData brokerData;
            MessageQueue mq = (MessageQueue)next.getKey();
            if (!mq.getTopic().equals(msg.getTopic()) || mq.getQueueId() != msg.getQueueId() || (brokerData = (BrokerData)ci.getBrokerAddrTable().get(mq.getBrokerName())) == null || !(addr = (String)brokerData.getBrokerAddrs().get(0L)).equals(RemotingUtil.socketAddress2String((SocketAddress)msg.getStoreHost())) || ((OffsetWrapper)next.getValue()).getConsumerOffset() <= msg.getQueueOffset()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<MessageTrack> messageTrackDetail(MessageExt msg) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        ArrayList<MessageTrack> result = new ArrayList<MessageTrack>();
        GroupList groupList = this.queryTopicConsumeByWho(msg.getTopic());
        for (String group : groupList.getGroupList()) {
            MessageTrack mt = new MessageTrack();
            mt.setConsumerGroup(group);
            mt.setTrackType(TrackType.UNKNOW_EXCEPTION);
            try {
                ConsumerConnection cc = this.examineConsumerConnectionInfo(group);
                switch (cc.getConsumeType()) {
                    case CONSUME_ACTIVELY: {
                        mt.setTrackType(TrackType.SUBSCRIBED_BUT_PULL);
                        break;
                    }
                    case CONSUME_PASSIVELY: {
                        boolean ifConsumed = this.consumed(msg, group);
                        if (ifConsumed) {
                            mt.setTrackType(TrackType.SUBSCRIBED_AND_CONSUMED);
                            for (Map.Entry next : cc.getSubscriptionTable().entrySet()) {
                                if (!((String)next.getKey()).equals(msg.getTopic()) || ((SubscriptionData)next.getValue()).getTagsSet().contains(msg.getTags()) || ((SubscriptionData)next.getValue()).getTagsSet().contains("*") || ((SubscriptionData)next.getValue()).getTagsSet().isEmpty()) continue;
                                mt.setTrackType(TrackType.SUBSCRIBED_BUT_FILTERD);
                            }
                            break;
                        }
                        mt.setTrackType(TrackType.SUBSCRIBED_AND_NOT_CONSUME_YET);
                        break;
                    }
                }
            }
            catch (Exception e) {
                mt.setExceptionDesc(RemotingHelper.exceptionSimpleDesc((Throwable)e));
            }
            result.add(mt);
        }
        return result;
    }

    @Override
    public void cloneGroupOffset(String srcGroup, String destGroup, String topic, boolean isOffline) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        String retryTopic = MixAll.getRetryTopic((String)srcGroup);
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(retryTopic);
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            this.mqClientInstance.getMQClientAPIImpl().cloneGroupOffset(addr, srcGroup, destGroup, topic, isOffline, 15000L);
        }
    }

    @Override
    public BrokerStatsData ViewBrokerStatsData(String brokerAddr, String statsName, String statsKey) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().ViewBrokerStatsData(brokerAddr, statsName, statsKey, 3000L);
    }
}

