/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class IoUtils {
    public static byte[] tryDecompress(InputStream raw) throws Exception {
        try {
            GZIPInputStream gis = new GZIPInputStream(raw);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)gis, (OutputStream)out);
            return out.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(data.getBytes(encoding));
            os.flush();
        }
        finally {
            if (null != os) {
                ((OutputStream)os).close();
            }
        }
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = IoUtils.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = null;
        while (null != (line = reader.readLine())) {
            if (!StringUtils.isNotEmpty((CharSequence)line)) continue;
            list.add(line.trim());
        }
        return list;
    }
}

