/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.client.config.utils.LogUtils;
import com.alibaba.nacos.client.logger.Logger;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class Limiter {
    public static final Logger log = LogUtils.logger(Limiter.class);
    private static int CAPACITY_SIZE = 1000;
    private static int LIMIT_TIME = 1000;
    private static Cache<String, RateLimiter> cache = CacheBuilder.newBuilder().initialCapacity(CAPACITY_SIZE).expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private static double limit = 5.0;

    public static boolean isLimit(String accessKeyID) {
        RateLimiter rateLimiter = null;
        try {
            rateLimiter = (RateLimiter)cache.get((Object)accessKeyID, (Callable)new Callable<RateLimiter>(){

                @Override
                public RateLimiter call() throws Exception {
                    return RateLimiter.create((double)limit);
                }
            });
        }
        catch (ExecutionException e) {
            log.error("Nacos-XXX", "create limit fail", e);
        }
        if (rateLimiter != null && !rateLimiter.tryAcquire((long)LIMIT_TIME, TimeUnit.MILLISECONDS)) {
            log.error("Nacos-XXX", "access_key_id:{} limited", accessKeyID);
            return true;
        }
        return false;
    }

    static {
        try {
            String limitTimeStr = System.getProperty("limitTime", String.valueOf(limit));
            limit = Double.parseDouble(limitTimeStr);
            log.info("limitTime:{}", limit);
        }
        catch (Exception e) {
            log.error("Nacos-xxx", "init limitTime fail", e);
        }
    }
}

