/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.context.scx;

import com.alibaba.cloud.context.AliCloudConfiguration;
import com.alibaba.cloud.context.edas.AliCloudEdasSdk;
import com.alibaba.cloud.context.edas.AliCloudEdasSdkFactory;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfiguration;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfigurationFactory;
import com.alibaba.cloud.context.edas.EdasConfiguration;
import com.alibaba.cloud.context.scx.ScxConfiguration;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.edas.schedulerx.SchedulerXClient;
import com.aliyuncs.edas.model.v20170801.GetSecureTokenResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AliCloudScxInitializer {
    private static final String TEST_REGION = "cn-test";
    private static final String DEFAULT_KEY = "123456";

    private AliCloudScxInitializer() {
    }

    public static void initialize(AliCloudConfiguration aliCloudConfiguration, EdasConfiguration edasConfiguration, ScxConfiguration scxConfiguration) throws InitException {
        AliCloudScxInitializer.initialize(aliCloudConfiguration, edasConfiguration, scxConfiguration, AliCloudEdasSdkFactory.getDefaultAliCloudEdasSdk(aliCloudConfiguration, edasConfiguration.getRegionId()));
    }

    public static void initialize(AliCloudConfiguration aliCloudConfiguration, EdasConfiguration edasConfiguration, ScxConfiguration scxConfiguration, AliCloudEdasSdk aliCloudEdasSdk) throws InitException {
        Assert.isTrue((!StringUtils.isEmpty((Object)scxConfiguration.getGroupId()) ? 1 : 0) != 0, (String)"${spring.cloud.alicloud.scx.group-id} can't be null.");
        SchedulerXClient schedulerXClient = new SchedulerXClient();
        schedulerXClient.setGroupId(scxConfiguration.getGroupId());
        EdasChangeOrderConfiguration edasChangeOrderConfiguration = EdasChangeOrderConfigurationFactory.getEdasChangeOrderConfiguration();
        if (edasChangeOrderConfiguration.isEdasManaged()) {
            if (edasChangeOrderConfiguration.getRegionId() != null) {
                schedulerXClient.setRegionName(edasChangeOrderConfiguration.getRegionId());
            } else {
                Assert.isTrue((!StringUtils.isEmpty((Object)edasConfiguration.getNamespace()) ? 1 : 0) != 0, (String)"${spring.cloud.alicloud.edas.namespace} can't be null.");
                schedulerXClient.setRegionName(edasConfiguration.getRegionId());
            }
            schedulerXClient.setDomainName(scxConfiguration.getDomainName());
            schedulerXClient.setAccessKey(edasChangeOrderConfiguration.getDauthAccessKey());
            schedulerXClient.setSecretKey(edasChangeOrderConfiguration.getDauthSecretKey());
        } else if (TEST_REGION.equals(edasConfiguration.getNamespace())) {
            Assert.isTrue((!StringUtils.isEmpty((Object)edasConfiguration.getNamespace()) ? 1 : 0) != 0, (String)"${spring.cloud.alicloud.edas.namespace} can't be null.");
            schedulerXClient.setRegionName(edasConfiguration.getNamespace());
            schedulerXClient.setAccessKey(DEFAULT_KEY);
            schedulerXClient.setSecretKey(DEFAULT_KEY);
        } else {
            Assert.isTrue((!StringUtils.isEmpty((Object)edasConfiguration.getNamespace()) ? 1 : 0) != 0, (String)"${spring.cloud.alicloud.edas.namespace} can't be null.");
            Assert.isTrue((!StringUtils.isEmpty((Object)aliCloudConfiguration.getAccessKey()) ? 1 : 0) != 0, (String)"${spring.cloud.alicloud.access-key} can't be empty.");
            Assert.isTrue((!StringUtils.isEmpty((Object)aliCloudConfiguration.getSecretKey()) ? 1 : 0) != 0, (String)"${spring.cloud.alicloud.secret-key} can't be empty.");
            GetSecureTokenResponse.SecureToken secureToken = aliCloudEdasSdk.getSecureToken(edasConfiguration.getNamespace());
            schedulerXClient.setRegionName(edasConfiguration.getRegionId());
            schedulerXClient.setDomainName(scxConfiguration.getDomainName());
            schedulerXClient.setAccessKey(secureToken.getAccessKey());
            schedulerXClient.setSecretKey(secureToken.getSecretKey());
        }
        schedulerXClient.init();
    }
}

