/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.file;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jpush.api.file.model.FileModel;
import cn.jpush.api.file.model.FileModelPage;
import cn.jpush.api.file.model.FileType;
import cn.jpush.api.file.model.FileUploadResult;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileClient {
    protected static final Logger LOG = LoggerFactory.getLogger(FileClient.class);
    private IHttpClient _httpClient;
    private String _baseUrl;
    private String _filesPath;
    private Gson _gson = new Gson();

    public FileClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, null, ClientConfig.getInstance());
    }

    public FileClient(String masterSecret, String appKey, HttpProxy proxy, ClientConfig conf) {
        this._baseUrl = (String)conf.get((Object)"push.host.name");
        this._filesPath = (String)conf.get((Object)"jpush.v3.files.path");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public FileUploadResult uploadFile(FileType type, String filename) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type should not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)filename), (Object)"filename should not be null");
        NativeHttpClient client = (NativeHttpClient)this._httpClient;
        String typeStr = type.value();
        String url = this._baseUrl + this._filesPath + "/" + typeStr;
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put("filename", filename);
        String response = client.formUploadByPost(url, null, fileMap, null);
        LOG.info("uploadFile:{}", (Object)response);
        return (FileUploadResult)this._gson.fromJson(response, new TypeToken<FileUploadResult>(){}.getType());
    }

    public FileModelPage queryEffectFiles() throws APIConnectionException, APIRequestException {
        String url = this._baseUrl + this._filesPath + "/";
        ResponseWrapper response = this._httpClient.sendGet(url);
        LOG.info("queryEffFiles:{}", (Object)response);
        return (FileModelPage)this._gson.fromJson(response.responseContent, new TypeToken<FileModelPage>(){}.getType());
    }

    public FileModel queryFile(String fileId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)fileId), (Object)"fileId should not be null");
        String url = this._baseUrl + this._filesPath + "/" + fileId;
        ResponseWrapper response = this._httpClient.sendGet(url);
        LOG.info("queryFile:{}", (Object)response);
        return (FileModel)this._gson.fromJson(response.responseContent, new TypeToken<FileModel>(){}.getType());
    }

    public ResponseWrapper deleteFile(String fileId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)fileId), (Object)"fileId should not be null");
        String url = this._baseUrl + this._filesPath + "/" + fileId;
        ResponseWrapper response = this._httpClient.sendDelete(url);
        LOG.info("deleteFile:{}", (Object)response);
        return response;
    }
}

