/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushModel;
import cn.jpush.api.push.model.SMS;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.Notification;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class PushPayload
implements PushModel {
    private static final String PLATFORM = "platform";
    private static final String AUDIENCE = "audience";
    private static final String NOTIFICATION = "notification";
    private static final String MESSAGE = "message";
    private static final String OPTIONS = "options";
    private static final String SMS = "sms_message";
    private static final String CID = "cid";
    private static final String TARGET = "target";
    private static final int MAX_GLOBAL_ENTITY_LENGTH = 4000;
    private static final int MAX_IOS_PAYLOAD_LENGTH = 2000;
    private static Gson _gson = new GsonBuilder().disableHtmlEscaping().create();
    private final Platform platform;
    private final Audience audience;
    private final Notification notification;
    private final Message message;
    private Options options;
    private SMS sms;
    private String cid;
    private String target;

    private PushPayload(Platform platform, Audience audience, Notification notification, Message message, Options options, SMS sms, String cid, String target) {
        this.platform = platform;
        this.audience = audience;
        this.notification = notification;
        this.message = message;
        this.options = options;
        this.sms = sms;
        this.cid = cid;
        this.target = target;
    }

    public PushPayload setCid(String cid) {
        this.cid = cid;
        return this;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getTarget() {
        return this.target;
    }

    public String getCid() {
        return this.cid;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static PushPayload alertAll(String alert) {
        return new Builder().setPlatform(Platform.all()).setAudience(Audience.all()).setNotification(Notification.alert(alert)).build();
    }

    public static PushPayload alertAll(String alert, SMS sms) {
        return new Builder().setPlatform(Platform.all()).setAudience(Audience.all()).setNotification(Notification.alert(alert)).setSMS(sms).build();
    }

    public static PushPayload messageAll(String msgContent) {
        return new Builder().setPlatform(Platform.all()).setAudience(Audience.all()).setMessage(Message.content(msgContent)).build();
    }

    public static PushPayload messageAll(String msgContent, SMS sms) {
        return new Builder().setPlatform(Platform.all()).setAudience(Audience.all()).setMessage(Message.content(msgContent)).setSMS(sms).build();
    }

    public static PushPayload fromJSON(String payloadString) {
        return (PushPayload)_gson.fromJson(payloadString, PushPayload.class);
    }

    public void resetOptionsApnsProduction(boolean apnsProduction) {
        if (null == this.options) {
            this.options = Options.newBuilder().setApnsProduction(apnsProduction).build();
        } else {
            this.options.setApnsProduction(apnsProduction);
        }
    }

    public void resetOptionsTimeToLive(long timeToLive) {
        if (null == this.options) {
            this.options = Options.newBuilder().setTimeToLive(timeToLive).build();
        } else {
            this.options.setTimeToLive(timeToLive);
        }
    }

    public int getSendno() {
        if (null != this.options) {
            return this.options.getSendno();
        }
        return 0;
    }

    public Audience getAudience() {
        return this.audience;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.platform) {
            json.add(PLATFORM, this.platform.toJSON());
        }
        if (null != this.audience) {
            json.add(AUDIENCE, this.audience.toJSON());
        }
        if (null != this.notification) {
            json.add(NOTIFICATION, this.notification.toJSON());
        }
        if (null != this.message) {
            json.add(MESSAGE, this.message.toJSON());
        }
        if (null != this.options) {
            json.add(OPTIONS, this.options.toJSON());
        }
        if (null != this.sms) {
            json.add(SMS, this.sms.toJSON());
        }
        if (null != this.cid) {
            json.addProperty(CID, this.cid);
        }
        if (null != this.target) {
            json.addProperty(TARGET, this.target);
        }
        return json;
    }

    public boolean isGlobalExceedLength() {
        int messageLength = 0;
        JsonObject payload = (JsonObject)this.toJSON();
        if (payload.has(MESSAGE)) {
            JsonObject message = payload.getAsJsonObject(MESSAGE);
            messageLength = message.toString().getBytes().length;
        }
        if (!payload.has(NOTIFICATION)) {
            return messageLength > 4000;
        }
        JsonObject notification = payload.getAsJsonObject(NOTIFICATION);
        if (notification.has("android")) {
            JsonObject android = notification.getAsJsonObject("android");
            int androidLength = android.toString().getBytes().length;
            return androidLength + messageLength > 4000;
        }
        return false;
    }

    public boolean isIosExceedLength() {
        JsonObject payload = (JsonObject)this.toJSON();
        if (payload.has(NOTIFICATION)) {
            JsonObject notification = payload.getAsJsonObject(NOTIFICATION);
            if (notification.has("ios")) {
                JsonObject ios = notification.getAsJsonObject("ios");
                return ios.toString().getBytes().length > 2000;
            }
            if (notification.has("alert")) {
                String alert = notification.get("alert").getAsString();
                JsonObject ios = new JsonObject();
                ios.add("alert", (JsonElement)new JsonPrimitive(alert));
                return ios.toString().getBytes().length > 2000;
            }
        }
        return false;
    }

    public String toString() {
        return _gson.toJson(this.toJSON());
    }

    public static class Builder {
        private Platform platform = null;
        private Audience audience = null;
        private Notification notification = null;
        private Message message = null;
        private Options options = null;
        private SMS sms = null;
        private String cid;
        private String target;

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder setPlatform(Platform platform) {
            this.platform = platform;
            return this;
        }

        public Builder setAudience(Audience audience) {
            this.audience = audience;
            return this;
        }

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder setMessage(Message message) {
            this.message = message;
            return this;
        }

        public Builder setOptions(Options options) {
            this.options = options;
            return this;
        }

        public Builder setSMS(SMS sms) {
            this.sms = sms;
            return this;
        }

        public Builder setCid(String cid) {
            this.cid = cid;
            return this;
        }

        public PushPayload build() {
            if (StringUtils.isTrimedEmpty((String)this.target)) {
                Preconditions.checkArgument((null != this.audience && null != this.platform ? 1 : 0) != 0, (Object)"audience and platform both should be set.");
            }
            if (!StringUtils.isTrimedEmpty((String)this.target)) {
                Preconditions.checkArgument((!StringUtils.isTrimedEmpty((String)this.target) && null != this.platform ? 1 : 0) != 0, (Object)"target and platform should be set.");
            }
            Preconditions.checkArgument((null != this.notification || null != this.message ? 1 : 0) != 0, (Object)"notification or message should be set at least one.");
            if (null == this.options) {
                this.options = Options.sendno();
            }
            return new PushPayload(this.platform, this.audience, this.notification, this.message, this.options, this.sms, this.cid, this.target);
        }
    }
}

