/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import javax.ws.rs.Path;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.hateoas.core.ControllerEntityLinksFactoryBean;
import org.springframework.hateoas.jaxrs.JaxRsLinkBuilderFactory;
import org.springframework.util.ClassUtils;

class JaxRsConfigurationImportSelector
implements ImportSelector {
    private static final boolean IS_JAX_RS_PRESENT = ClassUtils.isPresent((String)"javax.ws.rs.Path", (ClassLoader)ClassUtils.getDefaultClassLoader());

    JaxRsConfigurationImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        String[] stringArray;
        if (IS_JAX_RS_PRESENT) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = JaxRsEntityLinksConfiguration.class.getName();
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Configuration
    static class JaxRsEntityLinksConfiguration {
        JaxRsEntityLinksConfiguration() {
        }

        @Bean
        ControllerEntityLinksFactoryBean jaxRsEntityLinks() {
            ControllerEntityLinksFactoryBean factory = new ControllerEntityLinksFactoryBean();
            factory.setAnnotation(Path.class);
            factory.setLinkBuilderFactory(new JaxRsLinkBuilderFactory());
            return factory;
        }
    }
}

