/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.hateoas.config.ConverterRegisteringWebMvcConfigurer;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.hal.HalLinkDiscoverer;
import org.springframework.util.ClassUtils;

class HypermediaSupportBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final boolean JSONPATH_PRESENT = ClassUtils.isPresent((String)"com.jayway.jsonpath.JsonPath", null);

    HypermediaSupportBeanDefinitionRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map attributes = metadata.getAnnotationAttributes(EnableHypermediaSupport.class.getName());
        List<EnableHypermediaSupport.HypermediaType> types = Arrays.asList((EnableHypermediaSupport.HypermediaType[])attributes.get("type"));
        if (JSONPATH_PRESENT) {
            for (EnableHypermediaSupport.HypermediaType type : types) {
                AbstractBeanDefinition linkDiscovererBeanDefinition = this.getLinkDiscovererBeanDefinition(type);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)linkDiscovererBeanDefinition, BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)linkDiscovererBeanDefinition, (BeanDefinitionRegistry)registry)), (BeanDefinitionRegistry)registry);
            }
        }
        BeanDefinitionBuilder configurerBeanDefinition = BeanDefinitionBuilder.rootBeanDefinition(ConverterRegisteringWebMvcConfigurer.class);
        configurerBeanDefinition.addPropertyValue("hypermediaTypes", types);
        HypermediaSupportBeanDefinitionRegistrar.registerSourcedBeanDefinition(configurerBeanDefinition, metadata, registry);
    }

    private AbstractBeanDefinition getLinkDiscovererBeanDefinition(EnableHypermediaSupport.HypermediaType type) {
        RootBeanDefinition definition;
        switch (type) {
            case HAL: {
                definition = new RootBeanDefinition(HalLinkDiscoverer.class);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unsupported hypermedia type %s!", new Object[]{type}));
            }
        }
        definition.setSource((Object)this);
        return definition;
    }

    private static String registerSourcedBeanDefinition(BeanDefinitionBuilder builder, AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        String generateBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
        return HypermediaSupportBeanDefinitionRegistrar.registerSourcedBeanDefinition(builder, metadata, registry, generateBeanName);
    }

    private static String registerSourcedBeanDefinition(BeanDefinitionBuilder builder, AnnotationMetadata metadata, BeanDefinitionRegistry registry, String name) {
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        beanDefinition.setSource((Object)metadata);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, name);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        return name;
    }
}

