/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.ans.ribbon;

import com.alibaba.ans.core.NamingService;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Host;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.alicloud.ans.ribbon.AnsServer;

public class AnsServerList
extends AbstractServerList<AnsServer> {
    private String dom;

    public AnsServerList(String dom) {
        this.dom = dom;
    }

    public List<AnsServer> getInitialListOfServers() {
        try {
            List hosts = NamingService.getHosts((String)this.getDom());
            return this.hostsToServerList(hosts);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not get ans hosts, dom=" + this.getDom(), e);
        }
    }

    public List<AnsServer> getUpdatedListOfServers() {
        return this.getInitialListOfServers();
    }

    private AnsServer hostToServer(Host host) {
        AnsServer server = new AnsServer(host, this.getDom());
        return server;
    }

    private List<AnsServer> hostsToServerList(List<Host> hosts) {
        ArrayList<AnsServer> result = new ArrayList<AnsServer>(hosts.size());
        for (Host host : hosts) {
            if (!host.isValid()) continue;
            result.add(this.hostToServer(host));
        }
        return result;
    }

    public String getDom() {
        return this.dom;
    }

    public void initWithNiwsConfig(IClientConfig iClientConfig) {
        this.dom = iClientConfig.getClientName();
    }
}

