/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.ans.registry;

import com.alibaba.ans.core.NamingService;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.ipms.NodeReactor;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.alicloud.ans.registry.AnsRegistration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;

public class AnsServiceRegistry
implements ServiceRegistry<AnsRegistration> {
    private static Logger logger = LoggerFactory.getLogger(AnsServiceRegistry.class);
    private static final String SEPARATOR = ",";

    public void register(AnsRegistration registration) {
        if (!registration.isRegisterEnabled()) {
            logger.info("Registration is disabled...");
            return;
        }
        if (StringUtils.isEmpty((String)registration.getServiceId())) {
            logger.info("No service to register for client...");
            return;
        }
        ArrayList<NodeReactor.Tag> tags = new ArrayList<NodeReactor.Tag>();
        for (Map.Entry entry : registration.getAnsProperties().getTags().entrySet()) {
            NodeReactor.Tag tag = new NodeReactor.Tag();
            tag.setName((String)entry.getKey());
            tag.setValue((String)entry.getValue());
            tags.add(tag);
        }
        for (String dom : registration.getServiceId().split(SEPARATOR)) {
            try {
                NamingService.regDom((String)dom, (String)registration.getHost(), (int)registration.getPort(), (float)registration.getRegisterWeight(dom), (String)registration.getCluster(), tags);
                logger.info("INFO_ANS_REGISTER, {} {}:{} register finished", new Object[]{dom, registration.getAnsProperties().getClientIp(), registration.getAnsProperties().getClientPort()});
            }
            catch (Exception e) {
                logger.error("ERR_ANS_REGISTER, {} register failed...{},", new Object[]{dom, registration.toString(), e});
            }
        }
    }

    public void deregister(AnsRegistration registration) {
        logger.info("De-registering from ANSServer now...");
        if (StringUtils.isEmpty((String)registration.getServiceId())) {
            logger.info("No dom to de-register for client...");
            return;
        }
        try {
            NamingService.deRegDom((String)registration.getServiceId(), (String)registration.getHost(), (int)registration.getPort(), (String)registration.getCluster());
        }
        catch (Exception e) {
            logger.error("ERR_ANS_DEREGISTER, de-register failed...{},", (Object)registration.toString(), (Object)e);
        }
        logger.info("De-registration finished.");
    }

    public void close() {
    }

    public void setStatus(AnsRegistration registration, String status) {
    }

    public <T> T getStatus(AnsRegistration registration) {
        return null;
    }
}

