/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.ans.registry;

import java.net.URI;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.alicloud.context.ans.AnsProperties;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class AnsRegistration
implements Registration,
ServiceInstance {
    private static final String MANAGEMENT_PORT = "management.port";
    private static final String MANAGEMENT_CONTEXT_PATH = "management.context-path";
    private static final String MANAGEMENT_ADDRESS = "management.address";
    @Autowired
    private AnsProperties ansProperties;
    @Autowired
    private ApplicationContext context;

    @PostConstruct
    public void init() {
        Environment env = this.context.getEnvironment();
        Integer managementPort = ManagementServerPortUtils.getPort((BeanFactory)this.context);
        if (null != managementPort) {
            Map metadata = this.ansProperties.getClientMetadata();
            metadata.put(MANAGEMENT_PORT, managementPort.toString());
            String contextPath = env.getProperty("management.server.servlet.context-path");
            String address = env.getProperty("management.server.address");
            if (!StringUtils.isEmpty((Object)contextPath)) {
                metadata.put(MANAGEMENT_CONTEXT_PATH, contextPath);
            }
            if (!StringUtils.isEmpty((Object)address)) {
                metadata.put(MANAGEMENT_ADDRESS, address);
            }
        }
    }

    public String getServiceId() {
        return this.ansProperties.getClientDomains();
    }

    public String getHost() {
        return this.ansProperties.getClientIp();
    }

    public int getPort() {
        return this.ansProperties.getClientPort();
    }

    public void setPort(int port) {
        if (this.ansProperties.getClientPort() < 0) {
            this.ansProperties.setClientPort(port);
        }
    }

    public boolean isSecure() {
        return this.ansProperties.isSecure();
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        return this.ansProperties.getClientMetadata();
    }

    public boolean isRegisterEnabled() {
        return this.ansProperties.isRegisterEnabled();
    }

    public String getCluster() {
        return this.ansProperties.getClientCluster();
    }

    public float getRegisterWeight(String dom) {
        if (null != this.ansProperties.getClientWeights().get(dom) && ((Float)this.ansProperties.getClientWeights().get(dom)).floatValue() > 0.0f) {
            return ((Float)this.ansProperties.getClientWeights().get(dom)).floatValue();
        }
        return this.ansProperties.getClientWeight();
    }

    public AnsProperties getAnsProperties() {
        return this.ansProperties;
    }

    public String toString() {
        return "AnsRegistration{ansProperties=" + this.ansProperties + '}';
    }
}

