/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.ans.registry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.alicloud.ans.registry.AnsRegistration;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AnsAutoServiceRegistration
extends AbstractAutoServiceRegistration<AnsRegistration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnsAutoServiceRegistration.class);
    @Autowired
    private AnsRegistration registration;

    public AnsAutoServiceRegistration(ServiceRegistry<AnsRegistration> serviceRegistry, AutoServiceRegistrationProperties autoServiceRegistrationProperties, AnsRegistration registration) {
        super(serviceRegistry, autoServiceRegistrationProperties);
        this.registration = registration;
    }

    @Deprecated
    public void setPort(int port) {
        this.getPort().set(port);
    }

    protected AnsRegistration getRegistration() {
        if (this.registration.getPort() < 0 && this.getPort().get() > 0) {
            this.registration.setPort(this.getPort().get());
        }
        Assert.isTrue((this.registration.getPort() > 0 ? 1 : 0) != 0, (String)"service.port has not been set");
        return this.registration;
    }

    protected AnsRegistration getManagementRegistration() {
        return null;
    }

    protected void register() {
        if (!this.registration.getAnsProperties().isRegisterEnabled()) {
            LOGGER.debug("Registration disabled.");
            return;
        }
        if (this.registration.getPort() < 0) {
            this.registration.setPort(this.getPort().get());
        }
        super.register();
    }

    protected void registerManagement() {
        if (!this.registration.getAnsProperties().isRegisterEnabled()) {
            return;
        }
        super.registerManagement();
    }

    protected Object getConfiguration() {
        return this.registration.getAnsProperties();
    }

    protected boolean isEnabled() {
        return this.registration.getAnsProperties().isRegisterEnabled();
    }

    protected String getAppName() {
        String appName = this.registration.getServiceId();
        return StringUtils.isEmpty((Object)appName) ? super.getAppName() : appName;
    }
}

