/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.ans.endpoint;

import com.alibaba.ans.core.NamingService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.alicloud.context.ans.AnsProperties;

@Endpoint(id="ans")
public class AnsEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnsEndpoint.class);
    private AnsProperties ansProperties;

    public AnsEndpoint(AnsProperties ansProperties) {
        this.ansProperties = ansProperties;
    }

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> ansEndpoint = new HashMap<String, Object>();
        LOGGER.info("ANS endpoint invoke, ansProperties is {}", (Object)this.ansProperties);
        ansEndpoint.put("ansProperties", this.ansProperties);
        HashMap<String, List> subscribes = new HashMap<String, List>();
        Set subscribeServices = NamingService.getDomsSubscribed();
        for (String service : subscribeServices) {
            try {
                List hosts = NamingService.getHosts((String)service);
                subscribes.put(service, hosts);
            }
            catch (Exception exception) {}
        }
        ansEndpoint.put("subscribes", subscribes);
        LOGGER.info("ANS endpoint invoke, subscribes is {}", subscribes);
        return ansEndpoint;
    }
}

