/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.ans;

import com.alibaba.ans.core.NamingService;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Host;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.alicloud.ans.AnsServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class AnsDiscoveryClient
implements DiscoveryClient {
    public static final String DESCRIPTION = "Spring Cloud ANS Discovery Client";

    public String description() {
        return DESCRIPTION;
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        try {
            List hosts = NamingService.getHosts((String)serviceId);
            return AnsDiscoveryClient.hostToServiceInstanceList(hosts, serviceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get hosts from ans server. serviceId: " + serviceId, e);
        }
    }

    private static ServiceInstance hostToServiceInstance(Host host, String serviceId) {
        AnsServiceInstance ansServiceInstance = new AnsServiceInstance();
        ansServiceInstance.setHost(host.getIp());
        ansServiceInstance.setPort(host.getPort());
        ansServiceInstance.setServiceId(serviceId);
        HashMap<String, String> metadata = new HashMap<String, String>(5);
        metadata.put("appUseType", host.getAppUseType());
        metadata.put("site", host.getSite());
        metadata.put("unit", host.getUnit());
        metadata.put("doubleWeight", "" + host.getDoubleWeight());
        metadata.put("weight", "" + host.getWeight());
        ansServiceInstance.setMetadata(metadata);
        return ansServiceInstance;
    }

    private static List<ServiceInstance> hostToServiceInstanceList(List<Host> hosts, String serviceId) {
        ArrayList<ServiceInstance> result = new ArrayList<ServiceInstance>(hosts.size());
        for (Host host : hosts) {
            result.add(AnsDiscoveryClient.hostToServiceInstance(host, serviceId));
        }
        return result;
    }

    public List<String> getServices() {
        Set doms = NamingService.getDomsSubscribed();
        LinkedList<String> result = new LinkedList<String>();
        for (String service : doms) {
            result.add(service);
        }
        return result;
    }
}

