/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.ans;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.alicloud.ans.AnsDiscoveryClientAutoConfiguration;
import org.springframework.cloud.alicloud.ans.ConditionalOnAnsEnabled;
import org.springframework.cloud.alicloud.ans.registry.AnsAutoServiceRegistration;
import org.springframework.cloud.alicloud.ans.registry.AnsRegistration;
import org.springframework.cloud.alicloud.ans.registry.AnsServiceRegistry;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationAutoConfiguration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(name={"org.springframework.boot.web.context.WebServerInitializedEvent"})
@ConditionalOnProperty(value={"spring.cloud.service-registry.auto-registration.enabled"}, matchIfMissing=true)
@ConditionalOnAnsEnabled
@AutoConfigureBefore(value={AutoServiceRegistrationAutoConfiguration.class, AnsDiscoveryClientAutoConfiguration.class})
public class AnsAutoConfiguration {
    @Bean
    public AnsServiceRegistry ansServiceRegistry() {
        return new AnsServiceRegistry();
    }

    @Bean
    @ConditionalOnBean(value={AutoServiceRegistrationProperties.class})
    @ConditionalOnProperty(value={"spring.cloud.service-registry.auto-registration.enabled"}, matchIfMissing=true)
    public AnsRegistration ansRegistration() {
        return new AnsRegistration();
    }

    @Bean
    @ConditionalOnBean(value={AutoServiceRegistrationProperties.class})
    @ConditionalOnProperty(value={"spring.cloud.service-registry.auto-registration.enabled"}, matchIfMissing=true)
    public AnsAutoServiceRegistration ansAutoServiceRegistration(AnsServiceRegistry registry, AutoServiceRegistrationProperties autoServiceRegistrationProperties, AnsRegistration registration) {
        return new AnsAutoServiceRegistration(registry, autoServiceRegistrationProperties, registration);
    }
}

