/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.custom;

import com.alibaba.csp.sentinel.adapter.servlet.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.servlet.callback.UrlBlockHandler;
import com.alibaba.csp.sentinel.adapter.servlet.callback.UrlCleaner;
import com.alibaba.csp.sentinel.adapter.servlet.callback.WebCallbackManager;
import com.alibaba.csp.sentinel.adapter.servlet.config.WebServletConfig;
import com.alibaba.csp.sentinel.annotation.aspectj.SentinelResourceAspect;
import com.alibaba.csp.sentinel.init.InitExecutor;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.alibaba.sentinel.SentinelProperties;
import org.springframework.cloud.alibaba.sentinel.custom.SentinelBeanPostProcessor;
import org.springframework.cloud.alibaba.sentinel.custom.SentinelDataSourceHandler;
import org.springframework.cloud.alibaba.sentinel.datasource.converter.JsonConverter;
import org.springframework.cloud.alibaba.sentinel.datasource.converter.XmlConverter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"spring.cloud.sentinel.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SentinelProperties.class})
public class SentinelAutoConfiguration {
    @Value(value="${project.name:${spring.application.name:}}")
    private String projectName;
    @Autowired
    private SentinelProperties properties;
    @Autowired
    private Optional<UrlCleaner> urlCleanerOptional;
    @Autowired
    private Optional<UrlBlockHandler> urlBlockHandlerOptional;
    @Autowired
    private Optional<RequestOriginParser> requestOriginParserOptional;

    @PostConstruct
    private void init() {
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.log.dir")) && StringUtils.hasText((String)this.properties.getLog().getDir())) {
            System.setProperty("csp.sentinel.log.dir", this.properties.getLog().getDir());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.log.use.pid")) && this.properties.getLog().isSwitchPid()) {
            System.setProperty("csp.sentinel.log.use.pid", String.valueOf(this.properties.getLog().isSwitchPid()));
        }
        if (StringUtils.isEmpty((Object)System.getProperty("project.name")) && StringUtils.hasText((String)this.projectName)) {
            System.setProperty("project.name", this.projectName);
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.api.port")) && StringUtils.hasText((String)this.properties.getTransport().getPort())) {
            System.setProperty("csp.sentinel.api.port", this.properties.getTransport().getPort());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.dashboard.server")) && StringUtils.hasText((String)this.properties.getTransport().getDashboard())) {
            System.setProperty("csp.sentinel.dashboard.server", this.properties.getTransport().getDashboard());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.heartbeat.interval.ms")) && StringUtils.hasText((String)this.properties.getTransport().getHeartbeatIntervalMs())) {
            System.setProperty("csp.sentinel.heartbeat.interval.ms", this.properties.getTransport().getHeartbeatIntervalMs());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.heartbeat.client.ip")) && StringUtils.hasText((String)this.properties.getTransport().getClientIp())) {
            System.setProperty("csp.sentinel.heartbeat.client.ip", this.properties.getTransport().getClientIp());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.charset")) && StringUtils.hasText((String)this.properties.getMetric().getCharset())) {
            System.setProperty("csp.sentinel.charset", this.properties.getMetric().getCharset());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.metric.file.single.size")) && StringUtils.hasText((String)this.properties.getMetric().getFileSingleSize())) {
            System.setProperty("csp.sentinel.metric.file.single.size", this.properties.getMetric().getFileSingleSize());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.metric.file.total.count")) && StringUtils.hasText((String)this.properties.getMetric().getFileTotalCount())) {
            System.setProperty("csp.sentinel.metric.file.total.count", this.properties.getMetric().getFileTotalCount());
        }
        if (StringUtils.isEmpty((Object)System.getProperty("csp.sentinel.flow.cold.factor")) && StringUtils.hasText((String)this.properties.getFlow().getColdFactor())) {
            System.setProperty("csp.sentinel.flow.cold.factor", this.properties.getFlow().getColdFactor());
        }
        if (StringUtils.hasText((String)this.properties.getServlet().getBlockPage())) {
            WebServletConfig.setBlockPage((String)this.properties.getServlet().getBlockPage());
        }
        this.urlBlockHandlerOptional.ifPresent(WebCallbackManager::setUrlBlockHandler);
        this.urlCleanerOptional.ifPresent(WebCallbackManager::setUrlCleaner);
        this.requestOriginParserOptional.ifPresent(WebCallbackManager::setRequestOriginParser);
        if (this.properties.isEager()) {
            InitExecutor.doInit();
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SentinelResourceAspect sentinelResourceAspect() {
        return new SentinelResourceAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    @ConditionalOnProperty(name={"resttemplate.sentinel.enabled"}, havingValue="true", matchIfMissing=true)
    public SentinelBeanPostProcessor sentinelBeanPostProcessor(ApplicationContext applicationContext) {
        return new SentinelBeanPostProcessor(applicationContext);
    }

    @Bean
    public SentinelDataSourceHandler sentinelDataSourceHandler(DefaultListableBeanFactory beanFactory) {
        return new SentinelDataSourceHandler(beanFactory);
    }

    @ConditionalOnClass(value={XmlMapper.class})
    protected static class SentinelXmlConfiguration {
        private XmlMapper xmlMapper = new XmlMapper();

        protected SentinelXmlConfiguration() {
        }

        @Bean(value={"sentinel-xml-flow-converter"})
        public XmlConverter xmlFlowConverter() {
            return new XmlConverter(this.xmlMapper, FlowRule.class);
        }

        @Bean(value={"sentinel-xml-degrade-converter"})
        public XmlConverter xmlDegradeConverter() {
            return new XmlConverter(this.xmlMapper, DegradeRule.class);
        }

        @Bean(value={"sentinel-xml-system-converter"})
        public XmlConverter xmlSystemConverter() {
            return new XmlConverter(this.xmlMapper, SystemRule.class);
        }

        @Bean(value={"sentinel-xml-authority-converter"})
        public XmlConverter xmlAuthorityConverter() {
            return new XmlConverter(this.xmlMapper, AuthorityRule.class);
        }

        @Bean(value={"sentinel-xml-param-flow-converter"})
        public XmlConverter xmlParamFlowConverter() {
            return new XmlConverter(this.xmlMapper, ParamFlowRule.class);
        }
    }

    @ConditionalOnClass(value={ObjectMapper.class})
    protected static class SentinelConverterConfiguration {
        private ObjectMapper objectMapper = new ObjectMapper();

        protected SentinelConverterConfiguration() {
        }

        @Bean(value={"sentinel-json-flow-converter"})
        public JsonConverter jsonFlowConverter() {
            return new JsonConverter(this.objectMapper, FlowRule.class);
        }

        @Bean(value={"sentinel-json-degrade-converter"})
        public JsonConverter jsonDegradeConverter() {
            return new JsonConverter(this.objectMapper, DegradeRule.class);
        }

        @Bean(value={"sentinel-json-system-converter"})
        public JsonConverter jsonSystemConverter() {
            return new JsonConverter(this.objectMapper, SystemRule.class);
        }

        @Bean(value={"sentinel-json-authority-converter"})
        public JsonConverter jsonAuthorityConverter() {
            return new JsonConverter(this.objectMapper, AuthorityRule.class);
        }

        @Bean(value={"sentinel-json-param-flow-converter"})
        public JsonConverter jsonParamFlowConverter() {
            return new JsonConverter(this.objectMapper, ParamFlowRule.class);
        }
    }
}

