package com.bizvane.cdp.idmapping.facade.vo.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 客户表
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2025-07-15
 */
@Getter
@Setter
public class CdpCustomerInfoUpdateReqVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("PK")
    private Long cdpMemberId;

    @ApiModelProperty("全局唯一ID")
    private String bizOneId;

    private Long sysCompanyId;

    private Long sysBrandId;

    @ApiModelProperty("	{企业简称} 企业微信外部联系人 ID	")
    private String bizWecomCorpidExternalUserId;

    @ApiModelProperty("	{企业简称} 企业微信临时外部联系人 ID	")
    private String bizWecomCorpidPendingId;

    @ApiModelProperty("微信unionID")
    private String bizWechatUnionId;

    @ApiModelProperty("	最近服务员工企业成员userid	")
    private String lastOrderServiceGuideUserid;

    @ApiModelProperty("	最近服务员工编号	")
    private String lastOrderServiceGuideCode;

    @ApiModelProperty("	最近服务员工名称	")
    private String lastOrderServiceGuideName;

    @ApiModelProperty("	最近服务门店编号	")
    private String lastOrderServiceStoreCode;

    @ApiModelProperty("	最近服务门店名称	")
    private String lastOrderServiceStoreName;

    @ApiModelProperty("	注册员工企业成员userid	")
    private String openCardGuideUserid;

    @ApiModelProperty("	服务员工企业成员userid	")
    private String serviceGuideUserid;

    @ApiModelProperty("	注册员工名称	")
    private String openCardGuideName;

    @ApiModelProperty("	注册员工编号	")
    private String openCardGuideCode;

    @ApiModelProperty("	注册门店名称	")
    private String openCardStoreName;

    @ApiModelProperty("	注册门店编号	")
    private String openCardStoreCode;

    @ApiModelProperty("	trace_id	")
    private String channelTrace;

    @ApiModelProperty("	服务门店名称	")
    private String serviceStoreName;

    @ApiModelProperty("	服务门店编号	")
    private String serviceStoreCode;

    @ApiModelProperty("	服务员工名称	")
    private String serviceGuideName;

    @ApiModelProperty("	服务员工编号	")
    private String serviceGuideCode;

    @ApiModelProperty("	首次下单时间	")
    private LocalDateTime firstOrderTime;

    @ApiModelProperty("	最近下单时间	")
    private LocalDateTime lastOrderTime;

    @ApiModelProperty("	可用积分余额	")
    private BigDecimal availablePoints;

    @ApiModelProperty("	即将过期积分	")
    private BigDecimal invalidPointsThisYear;

    @ApiModelProperty("即将过期积分时间")
    private String pointsExpireTime;

    @ApiModelProperty("	可用储值余额	")
    private BigDecimal availableAmount;

    @ApiModelProperty("	累计消费金额	")
    private BigDecimal cumulativePayAmount;

    @ApiModelProperty("	会员卡号	")
    private String bizMemberCardNo;

    @ApiModelProperty("	客户手机号	")
    private String bizMobilePhone;

    @ApiModelProperty("客户姓名")
    private String name;

    @ApiModelProperty("	更新时间	")
    private LocalDateTime updateTime;

    @ApiModelProperty("	更新类型	")
    private String updateType;

    @ApiModelProperty("	会员卡号	")
    private String memberCardNo;

    @ApiModelProperty("	会员等级名称	")
    private String levelName;

    @ApiModelProperty("	会员等级Code	")
    private String levelCode;

    @ApiModelProperty("	客户手机号	")
    private String userPhone;

    @ApiModelProperty("	客户邮箱	")
    private String userEmail;

    @ApiModelProperty("	出生年份	")
    private BigDecimal userYearOfBirth;

    @ApiModelProperty("	生日	")
    private LocalDateTime userBirthday;

    @ApiModelProperty("	当年生日	")
    private LocalDateTime monthDayBirthday;

    @ApiModelProperty("	年龄	")
    private BigDecimal userAge;

    @ApiModelProperty("	性别	")
    private String userGender;

    @ApiModelProperty("	国家	")
    private String userCountry;

    @ApiModelProperty("	省份	")
    private String userProvince;

    @ApiModelProperty("	城市	")
    private String userCity;

    @ApiModelProperty("	注册时间	")
    private LocalDateTime signupTime;

    @ApiModelProperty("	首次广告系列来源	")
    private String firstUtmSource;

    @ApiModelProperty("	首次广告系列媒介	")
    private String firstUtmMedium;

    @ApiModelProperty("	首次广告系列名称	")
    private String firstUtmCampaign;

    @ApiModelProperty("	首次广告系列字词	")
    private String firstUtmTerm;

    @ApiModelProperty("	首次广告系列内容	")
    private String firstUtmContent;

    @ApiModelProperty("	首次渠道内容类型	")
    private String firstChannelCampaign;

    @ApiModelProperty("	首次渠道内容名称	")
    private String firstChannelContent;

    @ApiModelProperty("	首次投放渠道名称	")
    private String firstChannelMedium;

    @ApiModelProperty("	首次渠道来源类型	")
    private String firstChannelSource;

    @ApiModelProperty("	首次渠道来源明细	")
    private String firstChannelTerm;

    @ApiModelProperty("	CRM会员编号	")
    private String sfCrmMemberCode;

    @ApiModelProperty("美团ID")
    private String meiTuanId;

    @ApiModelProperty("饿了么ID")
    private String elemeId;

    @ApiModelProperty("淘宝ID")
    private String taoBaoId;

    @ApiModelProperty("是否被合并 1 未合并  2 被合并 3 被覆盖")
    private Integer mergeStatus;

    @ApiModelProperty("创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty("mapping字段")
    private String userLinkColumn;

    @ApiModelProperty("数据写入时间")
    private LocalDateTime cDate;

    @ApiModelProperty("测试身份")
    private String testId01;

    @ApiModelProperty("待删除")
    private Integer age;

    @ApiModelProperty("商帆UAT品牌A1公众号OpenID")
    private String bizWechatWx522b2ca5873f6b03OpenId;
}
