/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.ImmutableArray$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.PartialOrdering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public final class ArrayOps$ {
    public static ArrayOps$ MODULE$;

    static {
        new ArrayOps$();
    }

    public <A> Object copyOf(Object original, int newLength) {
        Object[] objectArray;
        if (original instanceof Object[]) {
            objectArray = Arrays.copyOf((Object[])original, newLength);
        } else if (original instanceof int[]) {
            objectArray = Arrays.copyOf((int[])original, newLength);
        } else if (original instanceof double[]) {
            objectArray = Arrays.copyOf((double[])original, newLength);
        } else if (original instanceof long[]) {
            objectArray = Arrays.copyOf((long[])original, newLength);
        } else if (original instanceof float[]) {
            objectArray = Arrays.copyOf((float[])original, newLength);
        } else if (original instanceof char[]) {
            objectArray = Arrays.copyOf((char[])original, newLength);
        } else if (original instanceof byte[]) {
            objectArray = Arrays.copyOf((byte[])original, newLength);
        } else if (original instanceof short[]) {
            objectArray = Arrays.copyOf((short[])original, newLength);
        } else if (original instanceof boolean[]) {
            objectArray = Arrays.copyOf((boolean[])original, newLength);
        } else if (original instanceof BoxedUnit[]) {
            BoxedUnit[] dest = new BoxedUnit[newLength];
            Array$.MODULE$.copy(original, 0, dest, 0, ScalaRunTime$.MODULE$.array_length(original));
            objectArray = dest;
        } else {
            throw new MatchError(original);
        }
        return objectArray;
    }

    public <A> Object copyAs(Object original, int newLength, ClassTag<A> ct) {
        Class<?> destClass = ct.runtimeClass();
        if (destClass.isAssignableFrom(original.getClass())) {
            if (destClass.getComponentType().isPrimitive()) {
                return this.copyOf(original, newLength);
            }
            return Arrays.copyOf((Object[])original, newLength, destClass);
        }
        Object dest = ct.newArray(newLength);
        Array$.MODULE$.copy(original, 0, dest, 0, ScalaRunTime$.MODULE$.array_length(original));
        return dest;
    }

    public final <A> ClassTag<A> elemTag$extension(Object $this) {
        return ClassTag$.MODULE$.apply($this.getClass().getComponentType());
    }

    public final <A> int size$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this);
    }

    public final <A> boolean isEmpty$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) == 0;
    }

    public final <A> boolean nonEmpty$extension(Object $this) {
        return ScalaRunTime$.MODULE$.array_length($this) != 0;
    }

    public final <A> A head$extension(Object $this) {
        return (A)ScalaRunTime$.MODULE$.array_apply($this, 0);
    }

    public final <A> A last$extension(Object $this) {
        return (A)ScalaRunTime$.MODULE$.array_apply($this, ScalaRunTime$.MODULE$.array_length($this) - 1);
    }

    public final <A> Option<A> headOption$extension(Object $this) {
        if (this.isEmpty$extension($this)) {
            return None$.MODULE$;
        }
        return new Some<A>(this.head$extension($this));
    }

    public final <A> Option<A> lastOption$extension(Object $this) {
        if (this.isEmpty$extension($this)) {
            return None$.MODULE$;
        }
        return new Some<A>(this.last$extension($this));
    }

    public final <A> Object slice$extension(Object $this, int from, int until) {
        int lo = package$.MODULE$.max(from, 0);
        int hi = package$.MODULE$.min(until, ScalaRunTime$.MODULE$.array_length($this));
        int len = hi - lo;
        if (len > 0) {
            Object[] objectArray;
            if ($this instanceof Object[]) {
                objectArray = Arrays.copyOfRange((Object[])$this, lo, hi);
            } else if ($this instanceof int[]) {
                objectArray = Arrays.copyOfRange((int[])$this, lo, hi);
            } else if ($this instanceof double[]) {
                objectArray = Arrays.copyOfRange((double[])$this, lo, hi);
            } else if ($this instanceof long[]) {
                objectArray = Arrays.copyOfRange((long[])$this, lo, hi);
            } else if ($this instanceof float[]) {
                objectArray = Arrays.copyOfRange((float[])$this, lo, hi);
            } else if ($this instanceof char[]) {
                objectArray = Arrays.copyOfRange((char[])$this, lo, hi);
            } else if ($this instanceof byte[]) {
                objectArray = Arrays.copyOfRange((byte[])$this, lo, hi);
            } else if ($this instanceof short[]) {
                objectArray = Arrays.copyOfRange((short[])$this, lo, hi);
            } else if ($this instanceof boolean[]) {
                objectArray = Arrays.copyOfRange((boolean[])$this, lo, hi);
            } else if ($this instanceof BoxedUnit[]) {
                BoxedUnit[] res = new BoxedUnit[len];
                Array$.MODULE$.copy($this, lo, res, 0, len);
                objectArray = res;
            } else {
                throw new MatchError($this);
            }
            return objectArray;
        }
        return this.elemTag$extension($this).newArray(0);
    }

    public final <A> Object tail$extension(Object $this) {
        return this.slice$extension($this, 1, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object init$extension(Object $this) {
        return this.slice$extension($this, 0, ScalaRunTime$.MODULE$.array_length($this) - 1);
    }

    public final <A> Object take$extension(Object $this, int n) {
        return this.slice$extension($this, 0, package$.MODULE$.min(n, ScalaRunTime$.MODULE$.array_length($this)));
    }

    public final <A> Object drop$extension(Object $this, int n) {
        return this.slice$extension($this, package$.MODULE$.min(n, ScalaRunTime$.MODULE$.array_length($this)), ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object takeRight$extension(Object $this, int n) {
        return this.drop$extension($this, ScalaRunTime$.MODULE$.array_length($this) - package$.MODULE$.max(n, 0));
    }

    public final <A> Object dropRight$extension(Object $this, int n) {
        return this.take$extension($this, ScalaRunTime$.MODULE$.array_length($this) - package$.MODULE$.max(n, 0));
    }

    public final <A> Object takeWhile$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$takeWhile$1(p, x)), this.indexWhere$default$2$extension($this));
        int hi = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return this.slice$extension($this, 0, hi);
    }

    public final <A> Object dropWhile$extension(Object $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$dropWhile$1(p, x)), this.indexWhere$default$2$extension($this));
        int lo = i < 0 ? ScalaRunTime$.MODULE$.array_length($this) : i;
        return this.slice$extension($this, lo, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Iterator<A> iterator$extension(Object $this) {
        return new ArrayOps.ArrayIterator($this);
    }

    public final <A> Iterator<Object> grouped$extension(Object $this, int size) {
        return new ArrayOps.GroupedIterator($this, size);
    }

    public final <A> Tuple2<Object, Object> splitAt$extension(Object $this, int n) {
        return new Tuple2<Object, Object>(this.take$extension($this, n), this.drop$extension($this, n));
    }

    public final <A> Tuple2<Object, Object> partition$extension(Object $this, Function1<A, Object> p) {
        ArrayBuilder<Object> res1 = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        ArrayBuilder<A> res2 = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object x = ScalaRunTime$.MODULE$.array_apply($this, i);
            ArrayBuilder<Object> arrayBuilder = BoxesRunTime.unboxToBoolean(p.apply(x)) ? res1 : res2;
            if (arrayBuilder == null) {
                throw null;
            }
            arrayBuilder.addOne(x);
        }
        return new Tuple2<Object, Object>(res1.result(), res2.result());
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Object reverse$extension(Object $this) {
        void var3_3;
        int len = ScalaRunTime$.MODULE$.array_length($this);
        Object res = this.elemTag$extension($this).newArray(len);
        for (int i = 0; i < len; ++i) {
            ScalaRunTime$.MODULE$.array_update(res, len - i - 1, ScalaRunTime$.MODULE$.array_apply($this, i));
        }
        return var3_3;
    }

    public final <A> Iterator<A> reverseIterator$extension(Object $this) {
        return new ArrayOps.ReverseIterator($this);
    }

    public final <A> Object filter$extension(Object $this, Function1<A, Object> p) {
        ArrayBuilder<Object> res = ArrayBuilder$.MODULE$.make(this.elemTag$extension($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Object x = ScalaRunTime$.MODULE$.array_apply($this, i);
            if (!BoxesRunTime.unboxToBoolean(p.apply(x))) continue;
            if (res == null) {
                throw null;
            }
            res.addOne(x);
        }
        return res.result();
    }

    public final <A> Object filterNot$extension(Object $this, Function1<A, Object> p) {
        return this.filter$extension($this, (Function1<Object, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$filterNot$1(p, x)));
    }

    public final <B, A> Object sorted$extension(Object $this, Ordering<B> ord) {
        int len = ScalaRunTime$.MODULE$.array_length($this);
        if ($this.getClass().getComponentType().isPrimitive() && len > 1) {
            int i;
            Object[] a = new Object[len];
            for (i = 0; i < len; ++i) {
                a[i] = ScalaRunTime$.MODULE$.array_apply($this, i);
            }
            Arrays.sort(a, ord);
            Object res = this.elemTag$extension($this).newArray(len);
            for (i = 0; i < len; ++i) {
                ScalaRunTime$.MODULE$.array_update(res, i, a[i]);
            }
            return res;
        }
        Object copy = this.slice$extension($this, 0, len);
        if (len > 1) {
            Arrays.sort((Object[])copy, ord);
        }
        return copy;
    }

    public final <A> Object sortWith$extension(Object $this, Function2<A, A, Object> lt) {
        if (Ordering$.MODULE$ == null) {
            throw null;
        }
        return this.sorted$extension($this, new Ordering<T>(lt){
            private final Function2 cmp$2;

            public Some<Object> tryCompare(T x, T y) {
                return Ordering.tryCompare$(this, x, y);
            }

            public boolean equiv(T x, T y) {
                return Ordering.equiv$(this, x, y);
            }

            public T max(T x, T y) {
                return (T)Ordering.max$(this, x, y);
            }

            public T min(T x, T y) {
                return (T)Ordering.min$(this, x, y);
            }

            public Ordering<T> reverse() {
                return Ordering.reverse$(this);
            }

            public <U> Ordering<U> on(Function1<U, T> f) {
                return Ordering.on$(this, f);
            }

            public Ordering<T> orElse(Ordering<T> other) {
                return Ordering.orElse$(this, other);
            }

            public <S> Ordering<T> orElseBy(Function1<T, S> f, Ordering<S> ord) {
                return Ordering.orElseBy$(this, f, ord);
            }

            public Ordering.Ops mkOrderingOps(T lhs) {
                return Ordering.mkOrderingOps$(this, lhs);
            }

            public int compare(T x, T y) {
                if (BoxesRunTime.unboxToBoolean(this.cmp$2.apply(x, y))) {
                    return -1;
                }
                if (BoxesRunTime.unboxToBoolean(this.cmp$2.apply(y, x))) {
                    return 1;
                }
                return 0;
            }

            public boolean lt(T x, T y) {
                return BoxesRunTime.unboxToBoolean(this.cmp$2.apply(x, y));
            }

            public boolean gt(T x, T y) {
                return BoxesRunTime.unboxToBoolean(this.cmp$2.apply(y, x));
            }

            public boolean gteq(T x, T y) {
                return !BoxesRunTime.unboxToBoolean(this.cmp$2.apply(x, y));
            }

            public boolean lteq(T x, T y) {
                return !BoxesRunTime.unboxToBoolean(this.cmp$2.apply(y, x));
            }
            {
                this.cmp$2 = cmp$2;
                PartialOrdering.$init$(this);
                Ordering.$init$(this);
            }
        });
    }

    public final <B, A> Object sortBy$extension(Object $this, Function1<A, B> f, Ordering<B> ord) {
        return this.sorted$extension($this, ord.on(f));
    }

    public final <A> ArrayOps.WithFilter<A> withFilter$extension(Object $this, Function1<A, Object> p) {
        return new ArrayOps.WithFilter<A>(p, $this);
    }

    public final <A> int indexWhere$extension(Object $this, Function1<A, Object> f, int from) {
        for (int i = from; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (!BoxesRunTime.unboxToBoolean(f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int indexWhere$default$2$extension(Object $this) {
        return 0;
    }

    public final <A> Option<A> find$extension(Object $this, Function1<A, Object> f) {
        int idx = this.indexWhere$extension($this, f, this.indexWhere$default$2$extension($this));
        if (idx == -1) {
            return None$.MODULE$;
        }
        return new Some<Object>(ScalaRunTime$.MODULE$.array_apply($this, idx));
    }

    public final <A> boolean exists$extension(Object $this, Function1<A, Object> f) {
        return this.indexWhere$extension($this, f, this.indexWhere$default$2$extension($this)) >= 0;
    }

    public final <A> boolean forall$extension(Object $this, Function1<A, Object> f) {
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            if (BoxesRunTime.unboxToBoolean(f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)))) continue;
            return false;
        }
        return true;
    }

    public final <B, A> B foldLeft$extension(Object $this, B z, Function2<B, A, B> op) {
        B v = z;
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            v = op.apply(v, ScalaRunTime$.MODULE$.array_apply($this, i));
        }
        return v;
    }

    public final <B, A> B foldRight$extension(Object $this, B z, Function2<A, B, B> op) {
        B v = z;
        for (int i = ScalaRunTime$.MODULE$.array_length($this) - 1; i >= 0; --i) {
            v = op.apply(ScalaRunTime$.MODULE$.array_apply($this, i), v);
        }
        return v;
    }

    public final <B, A> Object map$extension(Object $this, Function1<A, B> f, ClassTag<B> evidence$3) {
        Object res = evidence$3.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update(res, i, f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return res;
    }

    public final <A> Object mapInPlace$extension(Object $this, Function1<A, A> f) {
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            ScalaRunTime$.MODULE$.array_update($this, i, f.apply(ScalaRunTime$.MODULE$.array_apply($this, i)));
        }
        return $this;
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Object flatMap$extension0(Object $this, Function1<A, IterableOnce<B>> f, ClassTag<B> evidence$4) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$4);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            void $plus$plus$eq_xs;
            IterableOnce<B> iterableOnce = f.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            if (b == null) {
                throw null;
            }
            b.addAll($plus$plus$eq_xs);
        }
        return b.result();
    }

    /*
     * WARNING - void declaration
     */
    public final <BS, B, A> Object flatMap$extension1(Object $this, Function1<A, BS> f, Function1<BS, Iterable<B>> asIterable, ClassTag<B> m) {
        ArrayBuilder<B> flatMap$extension0_b = ArrayBuilder$.MODULE$.make(m);
        for (int flatMap$extension0_i = 0; flatMap$extension0_i < ScalaRunTime$.MODULE$.array_length($this); ++flatMap$extension0_i) {
            void flatMap$extension0_$plus$plus$eq_xs;
            Object object = ScalaRunTime$.MODULE$.array_apply($this, flatMap$extension0_i);
            Iterable iterable = ArrayOps$.$anonfun$flatMap$2(asIterable, f, object);
            if (flatMap$extension0_b == null) {
                throw null;
            }
            flatMap$extension0_b.addAll(flatMap$extension0_$plus$plus$eq_xs);
        }
        return flatMap$extension0_b.result();
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Object flatten$extension(Object $this, Function1<A, Iterable<B>> asIterable, ClassTag<B> m) {
        void var6_5;
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(m);
        Object map$extension_res = ClassTag$.MODULE$.Int().newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int map$extension_i = 0; map$extension_i < ScalaRunTime$.MODULE$.array_length($this); ++map$extension_i) {
            ScalaRunTime$.MODULE$.array_update(map$extension_res, map$extension_i, ArrayOps$.$anonfun$flatten$1$adapted(ScalaRunTime$.MODULE$.array_apply($this, map$extension_i)));
        }
        int[] sizes = (int[])var6_5;
        b.sizeHint(BoxesRunTime.unboxToInt(Predef$.MODULE$.wrapIntArray(sizes).sum(Numeric$IntIsIntegral$.MODULE$)));
        int foreach$extension_len = ScalaRunTime$.MODULE$.array_length($this);
        for (int foreach$extension_i = 0; foreach$extension_i < foreach$extension_len; ++foreach$extension_i) {
            Object object = ScalaRunTime$.MODULE$.array_apply($this, foreach$extension_i);
            ArrayOps$.$anonfun$flatten$2(b, asIterable, object);
        }
        return b.result();
    }

    public final <B, A> Object collect$extension(Object $this, PartialFunction<A, B> f, ClassTag<B> evidence$5) {
        BooleanRef matched = BooleanRef.create(true);
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$5);
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            matched.elem = true;
            Object v = f.applyOrElse(ScalaRunTime$.MODULE$.array_apply($this, i), (Function1<Object, Object> & java.io.Serializable & Serializable)x -> ArrayOps$.d$1(x, matched));
            if (!matched.elem) continue;
            if (b == null) {
                throw null;
            }
            b.addOne(v);
        }
        return b.result();
    }

    public final <B, A> Object $plus$plus$extension(Object $this, Iterable<B> xs, ClassTag<B> evidence$6) {
        return this.appendedAll$extension($this, xs, evidence$6);
    }

    public final <B, A> Tuple2<A, B>[] zip$extension(Object $this, Iterable<B> that) {
        ArrayBuilder.ofRef b = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(Tuple2.class));
        int k = that.knownSize();
        b.sizeHint(k >= 0 ? package$.MODULE$.min(k, ScalaRunTime$.MODULE$.array_length($this)) : ScalaRunTime$.MODULE$.array_length($this));
        Iterator it = that.iterator();
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this) && it.hasNext(); ++i) {
            Tuple2 $plus$eq_elem = new Tuple2(ScalaRunTime$.MODULE$.array_apply($this, i), it.next());
            b.addOne($plus$eq_elem);
        }
        return (Tuple2[])b.result();
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Tuple2<A, Object>[] zipWithIndex$extension(Object $this) {
        void var2_2;
        Tuple2[] b = new Tuple2[ScalaRunTime$.MODULE$.array_length($this)];
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            b[i] = new Tuple2<Object, Integer>(ScalaRunTime$.MODULE$.array_apply($this, i), BoxesRunTime.boxToInteger(i));
        }
        return var2_2;
    }

    public final <B, A> Object appended$extension(Object $this, B x, ClassTag<B> evidence$7) {
        Object dest = this.copyAs($this, ScalaRunTime$.MODULE$.array_length($this) + 1, evidence$7);
        ScalaRunTime$.MODULE$.array_update(dest, ScalaRunTime$.MODULE$.array_length($this), x);
        return dest;
    }

    public final <B, A> Object $colon$plus$extension(Object $this, B x, ClassTag<B> evidence$8) {
        return this.appended$extension($this, x, evidence$8);
    }

    public final <B, A> Object prepended$extension(Object $this, B x, ClassTag<B> evidence$9) {
        Object dest = evidence$9.newArray(ScalaRunTime$.MODULE$.array_length($this) + 1);
        ScalaRunTime$.MODULE$.array_update(dest, 0, x);
        Array$.MODULE$.copy($this, 0, dest, 1, ScalaRunTime$.MODULE$.array_length($this));
        return dest;
    }

    public final <B, A> Object $plus$colon$extension(Object $this, B x, ClassTag<B> evidence$10) {
        return this.prepended$extension($this, x, evidence$10);
    }

    public final <B, A> Object prependedAll$extension(Object $this, Iterable<B> prefix, ClassTag<B> evidence$11) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$11);
        int k = prefix.knownSize();
        if (k >= 0) {
            b.sizeHint(k + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll((IterableOnce)prefix);
        if (k < 0) {
            b.sizeHint(b.length() + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll($this);
        return b.result();
    }

    public final <B, A> Object $plus$plus$colon$extension(Object $this, Iterable<B> prefix, ClassTag<B> evidence$12) {
        return this.prependedAll$extension($this, prefix, evidence$12);
    }

    public final <B, A> Object appendedAll$extension(Object $this, Iterable<B> suffix, ClassTag<B> evidence$13) {
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$13);
        int k = suffix.knownSize();
        if (k >= 0) {
            b.sizeHint(k + ScalaRunTime$.MODULE$.array_length($this));
        }
        b.addAll($this);
        b.addAll((IterableOnce)suffix);
        return b.result();
    }

    public final <B, A> Object $colon$plus$plus$extension(Object $this, Iterable<B> suffix, ClassTag<B> evidence$14) {
        return this.appendedAll$extension($this, suffix, evidence$14);
    }

    public final <B, A> Object concat$extension(Object $this, Iterable<B> suffix, ClassTag<B> evidence$15) {
        return this.appendedAll$extension($this, suffix, evidence$15);
    }

    public final <B, A> Object patch$extension(Object $this, int from, IterableOnce<B> other, int replaced, ClassTag<B> evidence$16) {
        int chunk1;
        ArrayBuilder<B> b = ArrayBuilder$.MODULE$.make(evidence$16);
        int k = other.knownSize();
        if (k >= 0) {
            b.sizeHint(ScalaRunTime$.MODULE$.array_length($this) + k - replaced);
        }
        int n = chunk1 = from > 0 ? package$.MODULE$.min(from, ScalaRunTime$.MODULE$.array_length($this)) : 0;
        if (chunk1 > 0) {
            b.addAll($this, 0, chunk1);
        }
        if (b == null) {
            throw null;
        }
        b.addAll(other);
        int remaining = ScalaRunTime$.MODULE$.array_length($this) - chunk1 - replaced;
        if (remaining > 0) {
            b.addAll($this, ScalaRunTime$.MODULE$.array_length($this) - remaining, remaining);
        }
        return b.result();
    }

    public final <A1, A2, A> Tuple2<Object, Object> unzip$extension(Object $this, Function1<A, Tuple2<A1, A2>> asPair, ClassTag<A1> ct1, ClassTag<A2> ct2) {
        Object a1 = ct1.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a2 = ct2.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Tuple2<A1, A2> e = asPair.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            ScalaRunTime$.MODULE$.array_update(a1, i, e._1());
            ScalaRunTime$.MODULE$.array_update(a2, i, e._2());
        }
        return new Tuple2<Object, Object>(a1, a2);
    }

    public final <A1, A2, A3, A> Tuple3<Object, Object, Object> unzip3$extension(Object $this, Function1<A, Tuple3<A1, A2, A3>> asTriple, ClassTag<A1> ct1, ClassTag<A2> ct2, ClassTag<A3> ct3) {
        Object a1 = ct1.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a2 = ct2.newArray(ScalaRunTime$.MODULE$.array_length($this));
        Object a3 = ct3.newArray(ScalaRunTime$.MODULE$.array_length($this));
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length($this); ++i) {
            Tuple3<A1, A2, A3> e = asTriple.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
            ScalaRunTime$.MODULE$.array_update(a1, i, e._1());
            ScalaRunTime$.MODULE$.array_update(a2, i, e._2());
            ScalaRunTime$.MODULE$.array_update(a3, i, e._3());
        }
        return new Tuple3<Object, Object, Object>(a1, a2, a3);
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Object[] transpose$extension(Object $this, Function1<A, Object> asArray) {
        void var8_7;
        void map$extension_evidence$3;
        Class<?> aClass = $this.getClass().getComponentType();
        ArrayBuilder.ofRef bb = new ArrayBuilder.ofRef(ClassTag$.MODULE$.apply(aClass));
        if (ScalaRunTime$.MODULE$.array_length($this) == 0) {
            return bb.result();
        }
        ClassTag classTag = ClassTag$.MODULE$.apply(ArrayBuilder.class);
        Object map$extension_$this = Predef$.MODULE$.genericArrayOps(asArray.apply(ScalaRunTime$.MODULE$.array_apply($this, 0)));
        Object map$extension_res = map$extension_evidence$3.newArray(ScalaRunTime$.MODULE$.array_length(map$extension_$this));
        for (int map$extension_i = 0; map$extension_i < ScalaRunTime$.MODULE$.array_length(map$extension_$this); ++map$extension_i) {
            Object object = ScalaRunTime$.MODULE$.array_apply(map$extension_$this, map$extension_i);
            ScalaRunTime$.MODULE$.array_update(map$extension_res, map$extension_i, ArrayOps$.mkRowBuilder$1(aClass));
        }
        ArrayBuilder[] bs = (ArrayBuilder[])var8_7;
        int foreach$extension_len = ScalaRunTime$.MODULE$.array_length($this);
        for (int foreach$extension_i = 0; foreach$extension_i < foreach$extension_len; ++foreach$extension_i) {
            Object object = ScalaRunTime$.MODULE$.array_apply($this, foreach$extension_i);
            ArrayOps$.$anonfun$transpose$2$adapted(bs, asArray, object);
        }
        Object foreach$extension_$this = Predef$.MODULE$.refArrayOps(bs);
        int foreach$extension_len2 = ScalaRunTime$.MODULE$.array_length(foreach$extension_$this);
        for (int foreach$extension_i = 0; foreach$extension_i < foreach$extension_len2; ++foreach$extension_i) {
            ArrayBuilder arrayBuilder = (ArrayBuilder)ScalaRunTime$.MODULE$.array_apply(foreach$extension_$this, foreach$extension_i);
            ArrayOps$.$anonfun$transpose$4(bb, arrayBuilder);
        }
        return bb.result();
    }

    public final <U, A> void foreach$extension(Object $this, Function1<A, U> f) {
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            f.apply(ScalaRunTime$.MODULE$.array_apply($this, i));
        }
    }

    public final <A> Object distinct$extension(Object $this) {
        Function1<Object, Object> & java.io.Serializable & Serializable distinctBy$extension_f = (Function1<Object, Object> & java.io.Serializable & Serializable)x -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return x;
        };
        return ArrayBuilder$.MODULE$.make(this.elemTag$extension($this)).addAll((IterableOnce)this.iterator$extension($this).distinctBy(distinctBy$extension_f)).result();
    }

    public final <B, A> Object distinctBy$extension(Object $this, Function1<A, B> f) {
        return ArrayBuilder$.MODULE$.make(this.elemTag$extension($this)).addAll((IterableOnce)this.iterator$extension($this).distinctBy(f)).result();
    }

    public final <B, A> Object padTo$extension(Object $this, int len, B elem, ClassTag<B> evidence$17) {
        int i;
        int newlen = package$.MODULE$.max(i, len);
        Object dest = this.copyAs($this, newlen, evidence$17);
        for (i = ScalaRunTime$.MODULE$.array_length($this); i < newlen; ++i) {
            ScalaRunTime$.MODULE$.array_update(dest, i, elem);
        }
        return dest;
    }

    public final <A> Range indices$extension(Object $this) {
        return Range$.MODULE$.apply(0, ScalaRunTime$.MODULE$.array_length($this));
    }

    public final <A> Object diff$extension(Object $this, Seq<? super A> that) {
        return ((WrappedArray)WrappedArray$.MODULE$.make($this).diff((Seq)that)).array();
    }

    public final <A> Object intersect$extension(Object $this, Seq<? super A> that) {
        return ((WrappedArray)WrappedArray$.MODULE$.make($this).intersect((Seq)that)).array();
    }

    public final <K, A> Map<K, Object> groupBy$extension(Object $this, Function1<A, K> f) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        int len = ScalaRunTime$.MODULE$.array_length($this);
        for (int i = 0; i < len; ++i) {
            Object elem = ScalaRunTime$.MODULE$.array_apply($this, i);
            K key = f.apply(elem);
            ArrayBuilder bldr = (ArrayBuilder)m.getOrElseUpdate(key, (Function0<ArrayBuilder> & java.io.Serializable & Serializable)() -> ArrayBuilder$.MODULE$.make(MODULE$.elemTag$extension($this)));
            if (bldr == null) {
                throw null;
            }
            bldr.addOne(elem);
        }
        return m.mapValues((Function1<ArrayBuilder, Object> & java.io.Serializable & Serializable)x$1 -> x$1.result()).toMap(Predef$.MODULE$.$conforms());
    }

    public final <A> scala.collection.immutable.Seq<A> toSeq$extension(Object $this) {
        return this.toIndexedSeq$extension($this);
    }

    public final <A> scala.collection.immutable.IndexedSeq<A> toIndexedSeq$extension(Object $this) {
        return ImmutableArray$.MODULE$.unsafeWrapArray(this.copyOf($this, ScalaRunTime$.MODULE$.array_length($this)));
    }

    public final <A> int hashCode$extension(Object $this) {
        return $this.hashCode();
    }

    public final <A> boolean equals$extension(Object $this, Object x$1) {
        Object object;
        boolean bl = x$1 instanceof ArrayOps;
        return bl && BoxesRunTime.equals($this, object = x$1 == null ? null : ((ArrayOps)x$1).xs());
    }

    public static final /* synthetic */ boolean $anonfun$takeWhile$1(Function1 p$1, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$1.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$dropWhile$1(Function1 p$2, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$2.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$filterNot$1(Function1 p$3, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$3.apply(x));
    }

    public static final /* synthetic */ Iterable $anonfun$flatMap$2(Function1 asIterable$2, Function1 f$2, Object x) {
        return (Iterable)asIterable$2.apply(f$2.apply(x));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuilder $anonfun$flatten$2(ArrayBuilder b$1, Function1 asIterable$3, Object xs) {
        void $plus$plus$eq_xs;
        IterableOnce iterableOnce = (IterableOnce)asIterable$3.apply(xs);
        if (b$1 == null) {
            throw null;
        }
        return (ArrayBuilder)b$1.addAll($plus$plus$eq_xs);
    }

    private static final Object d$1(Object x, BooleanRef matched$1) {
        matched$1.elem = false;
        return null;
    }

    private static final ArrayBuilder mkRowBuilder$1(Class aClass$1) {
        return ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(aClass$1.getComponentType()));
    }

    public static final /* synthetic */ void $anonfun$transpose$3(ArrayBuilder[] bs$1, IntRef i$1, Object x) {
        ArrayBuilder arrayBuilder = bs$1[i$1.elem];
        if (arrayBuilder == null) {
            throw null;
        }
        arrayBuilder.addOne(x);
        ++i$1.elem;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$transpose$2(ArrayBuilder[] bs$1, Function1 asArray$1, Object xs) {
        void foreach$extension_$this;
        IntRef i = IntRef.create(0);
        Object object = Predef$.MODULE$.genericArrayOps(asArray$1.apply(xs));
        if (MODULE$ == null) {
            throw null;
        }
        int foreach$extension_len = ScalaRunTime$.MODULE$.array_length(foreach$extension_$this);
        for (int foreach$extension_i = 0; foreach$extension_i < foreach$extension_len; ++foreach$extension_i) {
            Object object2 = ScalaRunTime$.MODULE$.array_apply(foreach$extension_$this, foreach$extension_i);
            ArrayOps$.$anonfun$transpose$3$adapted(bs$1, i, object2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuilder.ofRef $anonfun$transpose$4(ArrayBuilder.ofRef bb$1, ArrayBuilder b) {
        void $plus$eq_elem;
        Object To = b.result();
        if (bb$1 == null) {
            throw null;
        }
        return (ArrayBuilder.ofRef)bb$1.addOne($plus$eq_elem);
    }

    private ArrayOps$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$flatten$1$adapted(Object x0$1) {
        return BoxesRunTime.boxToInteger(n = x0$1 instanceof IndexedSeq ? ((SeqOps)x0$1).size() : 0);
    }

    public static final /* synthetic */ Object $anonfun$transpose$2$adapted(ArrayBuilder[] bs$1, Function1 asArray$1, Object xs) {
        ArrayOps$.$anonfun$transpose$2(bs$1, asArray$1, xs);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$transpose$3$adapted(ArrayBuilder[] bs$1, IntRef i$1, Object x) {
        ArrayOps$.$anonfun$transpose$3(bs$1, i$1, x);
        return BoxedUnit.UNIT;
    }
}

