/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl;

import org.apache.milagro.amcl.HASH256;

public class RAND {
    private static final int NK = 21;
    private static final int NJ = 6;
    private static final int NV = 8;
    private int[] ira = new int[21];
    private int rndptr;
    private int borrow;
    private int pool_ptr;
    private byte[] pool = new byte[32];

    public RAND() {
        this.clean();
    }

    private int sbrand() {
        ++this.rndptr;
        if (this.rndptr < 21) {
            return this.ira[this.rndptr];
        }
        this.rndptr = 0;
        int i = 0;
        int k = 15;
        while (i < 21) {
            long t;
            long pdiff;
            if (k == 21) {
                k = 0;
            }
            if ((pdiff = (t = (long)this.ira[k] & 0xFFFFFFFFL) - ((long)this.ira[i] & 0xFFFFFFFFL) - (long)this.borrow & 0xFFFFFFFFL) < t) {
                this.borrow = 0;
            }
            if (pdiff > t) {
                this.borrow = 1;
            }
            this.ira[i] = (int)(pdiff & 0xFFFFFFFFL);
            ++i;
            ++k;
        }
        return this.ira[0];
    }

    public void sirand(int seed) {
        int i;
        int m = 1;
        this.borrow = 0;
        this.rndptr = 0;
        this.ira[0] = this.ira[0] ^ seed;
        for (i = 1; i < 21; ++i) {
            int in;
            int n = in = 8 * i % 21;
            this.ira[n] = this.ira[n] ^ m;
            int t = m;
            m = seed - m;
            seed = t;
        }
        for (i = 0; i < 10000; ++i) {
            this.sbrand();
        }
    }

    private void fill_pool() {
        HASH256 sh = new HASH256();
        for (int i = 0; i < 128; ++i) {
            sh.process(this.sbrand());
        }
        this.pool = sh.hash();
        this.pool_ptr = 0;
    }

    private static int pack(byte[] b) {
        return (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
    }

    public void seed(int rawlen, byte[] raw) {
        int i;
        byte[] b = new byte[4];
        HASH256 sh = new HASH256();
        this.pool_ptr = 0;
        for (i = 0; i < 21; ++i) {
            this.ira[i] = 0;
        }
        if (rawlen > 0) {
            for (i = 0; i < rawlen; ++i) {
                sh.process(raw[i]);
            }
            byte[] digest = sh.hash();
            for (i = 0; i < 8; ++i) {
                b[0] = digest[4 * i];
                b[1] = digest[4 * i + 1];
                b[2] = digest[4 * i + 2];
                b[3] = digest[4 * i + 3];
                this.sirand(RAND.pack(b));
            }
        }
        this.fill_pool();
    }

    public void clean() {
        int i;
        this.rndptr = 0;
        this.pool_ptr = 0;
        for (i = 0; i < 32; ++i) {
            this.pool[i] = 0;
        }
        for (i = 0; i < 21; ++i) {
            this.ira[i] = 0;
        }
        this.borrow = 0;
    }

    public int getByte() {
        byte r = this.pool[this.pool_ptr++];
        if (this.pool_ptr >= 32) {
            this.fill_pool();
        }
        return r & 0xFF;
    }
}

