/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl;

import org.apache.milagro.amcl.AES;

public class GCM {
    public static final int NB = 4;
    public static final int GCM_ACCEPTING_HEADER = 0;
    public static final int GCM_ACCEPTING_CIPHER = 1;
    public static final int GCM_NOT_ACCEPTING_MORE = 2;
    public static final int GCM_FINISHED = 3;
    public static final int GCM_ENCRYPTING = 0;
    public static final int GCM_DECRYPTING = 1;
    private int[][] table = new int[128][4];
    private byte[] stateX = new byte[16];
    private byte[] Y_0 = new byte[16];
    private int counter;
    private int[] lenA = new int[2];
    private int[] lenC = new int[2];
    private int status;
    private AES a = new AES();

    private static int pack(byte[] b) {
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    private static byte[] unpack(int a) {
        byte[] b = new byte[4];
        b[3] = (byte)a;
        b[2] = (byte)(a >>> 8);
        b[1] = (byte)(a >>> 16);
        b[0] = (byte)(a >>> 24);
        return b;
    }

    private void precompute(byte[] H) {
        byte[] b = new byte[4];
        int j = 0;
        int i = 0;
        while (i < 4) {
            b[0] = H[j];
            b[1] = H[j + 1];
            b[2] = H[j + 2];
            b[3] = H[j + 3];
            this.table[0][i] = GCM.pack(b);
            ++i;
            j += 4;
        }
        for (i = 1; i < 128; ++i) {
            int c = 0;
            for (j = 0; j < 4; ++j) {
                this.table[i][j] = c | this.table[i - 1][j] >>> 1;
                c = this.table[i - 1][j] << 31;
            }
            if (c == 0) continue;
            int[] nArray = this.table[i];
            nArray[0] = nArray[0] ^ 0xE1000000;
        }
    }

    private void gf2mul() {
        int i;
        int[] P = new int[4];
        P[3] = 0;
        P[2] = 0;
        P[1] = 0;
        P[0] = 0;
        int j = 8;
        int m = 0;
        for (i = 0; i < 128; ++i) {
            int c = this.stateX[m] >>> --j & 1;
            c = ~c + 1;
            for (int k = 0; k < 4; ++k) {
                int n = k;
                P[n] = P[n] ^ this.table[i][k] & c;
            }
            if (j != 0) continue;
            j = 8;
            if (++m == 16) break;
        }
        j = 0;
        i = 0;
        while (i < 4) {
            byte[] b = GCM.unpack(P[i]);
            this.stateX[j] = b[0];
            this.stateX[j + 1] = b[1];
            this.stateX[j + 2] = b[2];
            this.stateX[j + 3] = b[3];
            ++i;
            j += 4;
        }
    }

    private void wrap() {
        int[] F = new int[4];
        byte[] L = new byte[16];
        F[0] = this.lenA[0] << 3 | (this.lenA[1] & 0xE0000000) >>> 29;
        F[1] = this.lenA[1] << 3;
        F[2] = this.lenC[0] << 3 | (this.lenC[1] & 0xE0000000) >>> 29;
        F[3] = this.lenC[1] << 3;
        int j = 0;
        int i = 0;
        while (i < 4) {
            byte[] b = GCM.unpack(F[i]);
            L[j] = b[0];
            L[j + 1] = b[1];
            L[j + 2] = b[2];
            L[j + 3] = b[3];
            ++i;
            j += 4;
        }
        for (i = 0; i < 16; ++i) {
            int n = i;
            this.stateX[n] = (byte)(this.stateX[n] ^ L[i]);
        }
        this.gf2mul();
    }

    public void init(int nk, byte[] key, int niv, byte[] iv) {
        int i;
        byte[] H = new byte[16];
        for (i = 0; i < 16; ++i) {
            H[i] = 0;
            this.stateX[i] = 0;
        }
        this.a.init(0, nk, key, iv);
        this.a.ecb_encrypt(H);
        this.precompute(H);
        this.lenC[1] = 0;
        this.lenA[1] = 0;
        this.lenC[0] = 0;
        this.lenA[0] = 0;
        if (niv == 12) {
            for (i = 0; i < 12; ++i) {
                this.a.f[i] = iv[i];
            }
            byte[] b = GCM.unpack(1);
            this.a.f[12] = b[0];
            this.a.f[13] = b[1];
            this.a.f[14] = b[2];
            this.a.f[15] = b[3];
            for (i = 0; i < 16; ++i) {
                this.Y_0[i] = this.a.f[i];
            }
        } else {
            this.status = 1;
            this.ghash(iv, niv);
            this.wrap();
            for (i = 0; i < 16; ++i) {
                this.a.f[i] = this.stateX[i];
                this.Y_0[i] = this.a.f[i];
                this.stateX[i] = 0;
            }
            this.lenC[1] = 0;
            this.lenA[1] = 0;
            this.lenC[0] = 0;
            this.lenA[0] = 0;
        }
        this.status = 0;
    }

    public boolean add_header(byte[] header, int len) {
        int j = 0;
        if (this.status != 0) {
            return false;
        }
        while (j < len) {
            for (int i = 0; i < 16 && j < len; ++i) {
                int n = i;
                this.stateX[n] = (byte)(this.stateX[n] ^ header[j++]);
                this.lenA[1] = this.lenA[1] + 1;
                if (this.lenA[1] != 0) continue;
                this.lenA[0] = this.lenA[0] + 1;
            }
            this.gf2mul();
        }
        if (len % 16 != 0) {
            this.status = 1;
        }
        return true;
    }

    private boolean ghash(byte[] plain, int len) {
        int j = 0;
        if (this.status == 0) {
            this.status = 1;
        }
        if (this.status != 1) {
            return false;
        }
        while (j < len) {
            for (int i = 0; i < 16 && j < len; ++i) {
                int n = i;
                this.stateX[n] = (byte)(this.stateX[n] ^ plain[j++]);
                this.lenC[1] = this.lenC[1] + 1;
                if (this.lenC[1] != 0) continue;
                this.lenC[0] = this.lenC[0] + 1;
            }
            this.gf2mul();
        }
        if (len % 16 != 0) {
            this.status = 2;
        }
        return true;
    }

    public byte[] add_plain(byte[] plain, int len) {
        int j = 0;
        byte[] B = new byte[16];
        byte[] b = new byte[4];
        byte[] cipher = new byte[len];
        if (this.status == 0) {
            this.status = 1;
        }
        if (this.status != 1) {
            return new byte[0];
        }
        while (j < len) {
            int i;
            b[0] = this.a.f[12];
            b[1] = this.a.f[13];
            b[2] = this.a.f[14];
            b[3] = this.a.f[15];
            int counter = GCM.pack(b);
            b = GCM.unpack(++counter);
            this.a.f[12] = b[0];
            this.a.f[13] = b[1];
            this.a.f[14] = b[2];
            this.a.f[15] = b[3];
            for (i = 0; i < 16; ++i) {
                B[i] = this.a.f[i];
            }
            this.a.ecb_encrypt(B);
            for (i = 0; i < 16 && j < len; ++i) {
                cipher[j] = (byte)(plain[j] ^ B[i]);
                int n = i;
                this.stateX[n] = (byte)(this.stateX[n] ^ cipher[j++]);
                this.lenC[1] = this.lenC[1] + 1;
                if (this.lenC[1] != 0) continue;
                this.lenC[0] = this.lenC[0] + 1;
            }
            this.gf2mul();
        }
        if (len % 16 != 0) {
            this.status = 2;
        }
        return cipher;
    }

    public byte[] add_cipher(byte[] cipher, int len) {
        int j = 0;
        byte[] B = new byte[16];
        byte[] b = new byte[4];
        byte[] plain = new byte[len];
        if (this.status == 0) {
            this.status = 1;
        }
        if (this.status != 1) {
            return new byte[0];
        }
        while (j < len) {
            int i;
            b[0] = this.a.f[12];
            b[1] = this.a.f[13];
            b[2] = this.a.f[14];
            b[3] = this.a.f[15];
            int counter = GCM.pack(b);
            b = GCM.unpack(++counter);
            this.a.f[12] = b[0];
            this.a.f[13] = b[1];
            this.a.f[14] = b[2];
            this.a.f[15] = b[3];
            for (i = 0; i < 16; ++i) {
                B[i] = this.a.f[i];
            }
            this.a.ecb_encrypt(B);
            for (i = 0; i < 16 && j < len; ++i) {
                byte oc = cipher[j];
                plain[j] = (byte)(cipher[j] ^ B[i]);
                int n = i;
                this.stateX[n] = (byte)(this.stateX[n] ^ oc);
                ++j;
                this.lenC[1] = this.lenC[1] + 1;
                if (this.lenC[1] != 0) continue;
                this.lenC[0] = this.lenC[0] + 1;
            }
            this.gf2mul();
        }
        if (len % 16 != 0) {
            this.status = 2;
        }
        return plain;
    }

    public byte[] finish(boolean extract) {
        byte[] tag = new byte[16];
        this.wrap();
        if (extract) {
            int i;
            this.a.ecb_encrypt(this.Y_0);
            for (i = 0; i < 16; ++i) {
                int n = i;
                this.Y_0[n] = (byte)(this.Y_0[n] ^ this.stateX[i]);
            }
            for (i = 0; i < 16; ++i) {
                tag[i] = this.Y_0[i];
                this.stateX[i] = 0;
                this.Y_0[i] = 0;
            }
        }
        this.status = 3;
        this.a.end();
        return tag;
    }

    public static byte[] hex2bytes(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

