/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.C25519;

import org.apache.milagro.amcl.C25519.BIG;
import org.apache.milagro.amcl.C25519.FP;
import org.apache.milagro.amcl.C25519.ROM;

public final class ECP {
    public static final int WEIERSTRASS = 0;
    public static final int EDWARDS = 1;
    public static final int MONTGOMERY = 2;
    public static final int NOT = 0;
    public static final int BN = 1;
    public static final int BLS = 2;
    public static final int D_TYPE = 0;
    public static final int M_TYPE = 1;
    public static final int POSITIVEX = 0;
    public static final int NEGATIVEX = 1;
    public static final int CURVETYPE = 2;
    public static final int CURVE_PAIRING_TYPE = 0;
    public static final int SEXTIC_TWIST = 0;
    public static final int SIGN_OF_X = 0;
    public static final int SHA256 = 32;
    public static final int SHA384 = 48;
    public static final int SHA512 = 64;
    public static final int HASH_TYPE = 32;
    public static final int AESKEY = 16;
    private FP x;
    private FP y;
    private FP z;

    public ECP() {
        this.x = new FP(0);
        this.y = new FP(1);
        this.z = new FP(0);
    }

    public ECP(ECP e) {
        this.x = new FP(e.x);
        this.y = new FP(e.y);
        this.z = new FP(e.z);
    }

    public boolean is_infinity() {
        return this.z.iszilch();
    }

    private void cswap(ECP Q, int d) {
        this.x.cswap(Q.x, d);
        this.z.cswap(Q.z, d);
    }

    private void cmove(ECP Q, int d) {
        this.x.cmove(Q.x, d);
        this.z.cmove(Q.z, d);
    }

    private static int teq(int b, int c) {
        int x = b ^ c;
        return --x >> 31 & 1;
    }

    private void select(ECP[] W, int b) {
        ECP MP = new ECP();
        int m = b >> 31;
        int babs = (b ^ m) - m;
        babs = (babs - 1) / 2;
        this.cmove(W[0], ECP.teq(babs, 0));
        this.cmove(W[1], ECP.teq(babs, 1));
        this.cmove(W[2], ECP.teq(babs, 2));
        this.cmove(W[3], ECP.teq(babs, 3));
        this.cmove(W[4], ECP.teq(babs, 4));
        this.cmove(W[5], ECP.teq(babs, 5));
        this.cmove(W[6], ECP.teq(babs, 6));
        this.cmove(W[7], ECP.teq(babs, 7));
        MP.copy(this);
        MP.neg();
        this.cmove(MP, m & 1);
    }

    public boolean equals(ECP Q) {
        FP a = new FP(0);
        FP b = new FP(0);
        a.copy(this.x);
        a.mul(Q.z);
        b.copy(Q.x);
        b.mul(this.z);
        return a.equals(b);
    }

    public void copy(ECP P) {
        this.x.copy(P.x);
        this.z.copy(P.z);
    }

    public void neg() {
    }

    public void inf() {
        this.x.zero();
        this.z.zero();
    }

    public static FP RHS(FP x) {
        x.norm();
        FP r = new FP(x);
        r.sqr();
        FP x3 = new FP(0);
        x3.copy(r);
        x3.mul(x);
        r.imul(486662);
        r.add(x3);
        r.add(x);
        r.reduce();
        return r;
    }

    public ECP(BIG ix, BIG iy) {
        this.x = new FP(ix);
        this.y = new FP(iy);
        this.z = new FP(1);
        FP rhs = ECP.RHS(this.x);
        if (rhs.jacobi() != 1) {
            this.inf();
        }
    }

    public ECP(BIG ix, int s) {
        this.x = new FP(ix);
        FP rhs = ECP.RHS(this.x);
        this.y = new FP(0);
        this.z = new FP(1);
        if (rhs.jacobi() == 1) {
            FP ny = rhs.sqrt();
            if (ny.redc().parity() != s) {
                ny.neg();
            }
            this.y.copy(ny);
        } else {
            this.inf();
        }
    }

    public ECP(BIG ix) {
        this.x = new FP(ix);
        FP rhs = ECP.RHS(this.x);
        this.y = new FP(0);
        this.z = new FP(1);
        if (rhs.jacobi() != 1) {
            this.inf();
        }
    }

    public void affine() {
        if (this.is_infinity()) {
            return;
        }
        FP one = new FP(1);
        if (this.z.equals(one)) {
            return;
        }
        this.z.inverse();
        this.x.mul(this.z);
        this.x.reduce();
        this.z.copy(one);
    }

    public BIG getX() {
        ECP W = new ECP(this);
        W.affine();
        return W.x.redc();
    }

    public BIG getY() {
        ECP W = new ECP(this);
        W.affine();
        return W.y.redc();
    }

    public int getS() {
        BIG y = this.getY();
        return y.parity();
    }

    public FP getx() {
        return this.x;
    }

    public FP gety() {
        return this.y;
    }

    public FP getz() {
        return this.z;
    }

    public void toBytes(byte[] b, boolean compress) {
        byte[] t = new byte[32];
        ECP W = new ECP(this);
        W.affine();
        W.x.redc().toBytes(t);
        for (int i = 0; i < 32; ++i) {
            b[i + 1] = t[i];
        }
        b[0] = 6;
    }

    public static ECP fromBytes(byte[] b) {
        byte[] t = new byte[32];
        BIG p = new BIG(ROM.Modulus);
        for (int i = 0; i < 32; ++i) {
            t[i] = b[i + 1];
        }
        BIG px = BIG.fromBytes(t);
        if (BIG.comp(px, p) >= 0) {
            return new ECP();
        }
        return new ECP(px);
    }

    public String toString() {
        ECP W = new ECP(this);
        W.affine();
        if (W.is_infinity()) {
            return "infinity";
        }
        return "(" + W.x.redc().toString() + ")";
    }

    public String toRawString() {
        ECP W = new ECP(this);
        return "(" + W.x.redc().toString() + "," + W.z.redc().toString() + ")";
    }

    public void dbl() {
        FP A = new FP(this.x);
        FP B = new FP(this.x);
        FP AA = new FP(0);
        FP BB = new FP(0);
        FP C = new FP(0);
        A.add(this.z);
        A.norm();
        AA.copy(A);
        AA.sqr();
        B.sub(this.z);
        B.norm();
        BB.copy(B);
        BB.sqr();
        C.copy(AA);
        C.sub(BB);
        C.norm();
        this.x.copy(AA);
        this.x.mul(BB);
        A.copy(C);
        A.imul(121666);
        BB.add(A);
        BB.norm();
        this.z.copy(BB);
        this.z.mul(C);
    }

    public void add(ECP Q) {
    }

    public void dadd(ECP Q, ECP W) {
        FP A = new FP(this.x);
        FP B = new FP(this.x);
        FP C = new FP(Q.x);
        FP D = new FP(Q.x);
        FP DA = new FP(0);
        FP CB = new FP(0);
        A.add(this.z);
        B.sub(this.z);
        C.add(Q.z);
        D.sub(Q.z);
        A.norm();
        D.norm();
        DA.copy(D);
        DA.mul(A);
        C.norm();
        B.norm();
        CB.copy(C);
        CB.mul(B);
        A.copy(DA);
        A.add(CB);
        A.norm();
        A.sqr();
        B.copy(DA);
        B.sub(CB);
        B.norm();
        B.sqr();
        this.x.copy(A);
        this.z.copy(W.x);
        this.z.mul(B);
    }

    public void sub(ECP Q) {
        ECP NQ = new ECP(Q);
        NQ.neg();
        this.add(NQ);
    }

    public ECP pinmul(int e, int bts) {
        return this.mul(new BIG(e));
    }

    public ECP mul(BIG e) {
        if (e.iszilch() || this.is_infinity()) {
            return new ECP();
        }
        ECP P = new ECP();
        ECP D = new ECP();
        ECP R0 = new ECP();
        R0.copy(this);
        ECP R1 = new ECP();
        R1.copy(this);
        R1.dbl();
        D.copy(this);
        D.affine();
        int nb = e.nbits();
        for (int i = nb - 2; i >= 0; --i) {
            int b = e.bit(i);
            P.copy(R1);
            P.dadd(R0, D);
            R0.cswap(R1, b);
            R1.copy(P);
            R0.dbl();
            R0.cswap(R1, b);
        }
        P.copy(R0);
        P.affine();
        return P;
    }

    public ECP mul2(BIG e, ECP Q, BIG f) {
        int i;
        BIG te = new BIG();
        BIG tf = new BIG();
        BIG mt = new BIG();
        ECP S = new ECP();
        ECP T = new ECP();
        ECP C = new ECP();
        ECP[] W = new ECP[8];
        byte[] w = new byte[141];
        te.copy(e);
        tf.copy(f);
        W[1] = new ECP();
        W[1].copy(this);
        W[1].sub(Q);
        W[2] = new ECP();
        W[2].copy(this);
        W[2].add(Q);
        S.copy(Q);
        S.dbl();
        W[0] = new ECP();
        W[0].copy(W[1]);
        W[0].sub(S);
        W[3] = new ECP();
        W[3].copy(W[2]);
        W[3].add(S);
        T.copy(this);
        T.dbl();
        W[5] = new ECP();
        W[5].copy(W[1]);
        W[5].add(T);
        W[6] = new ECP();
        W[6].copy(W[2]);
        W[6].add(T);
        W[4] = new ECP();
        W[4].copy(W[5]);
        W[4].sub(S);
        W[7] = new ECP();
        W[7].copy(W[6]);
        W[7].add(S);
        int s = te.parity();
        te.inc(1);
        te.norm();
        int ns = te.parity();
        mt.copy(te);
        mt.inc(1);
        mt.norm();
        te.cmove(mt, s);
        T.cmove(this, ns);
        C.copy(T);
        s = tf.parity();
        tf.inc(1);
        tf.norm();
        ns = tf.parity();
        mt.copy(tf);
        mt.inc(1);
        mt.norm();
        tf.cmove(mt, s);
        S.cmove(Q, ns);
        C.add(S);
        mt.copy(te);
        mt.add(tf);
        mt.norm();
        int nb = 1 + (mt.nbits() + 1) / 2;
        for (i = 0; i < nb; ++i) {
            byte a = (byte)(te.lastbits(3) - 4);
            te.dec(a);
            te.norm();
            te.fshr(2);
            byte b = (byte)(tf.lastbits(3) - 4);
            tf.dec(b);
            tf.norm();
            tf.fshr(2);
            w[i] = (byte)(4 * a + b);
        }
        w[nb] = (byte)(4 * te.lastbits(3) + tf.lastbits(3));
        S.copy(W[(w[nb] - 1) / 2]);
        for (i = nb - 1; i >= 0; --i) {
            T.select(W, w[i]);
            S.dbl();
            S.dbl();
            S.add(T);
        }
        S.sub(C);
        S.affine();
        return S;
    }

    public void cfp() {
        int cf = 8;
        if (cf == 1) {
            return;
        }
        if (cf == 4) {
            this.dbl();
            this.dbl();
            return;
        }
        if (cf == 8) {
            this.dbl();
            this.dbl();
            this.dbl();
            return;
        }
        BIG c = new BIG(ROM.CURVE_Cof);
        this.copy(this.mul(c));
    }

    /*
     * Unable to fully structure code
     */
    public static ECP mapit(byte[] h) {
        q = new BIG(ROM.Modulus);
        x = BIG.fromBytes(h);
        x.mod(q);
        do lbl-1000:
        // 3 sources

        {
            P = new ECP(x);
            x.inc(1);
            x.norm();
            if (P.is_infinity()) ** GOTO lbl-1000
            P.cfp();
        } while (P.is_infinity());
        return P;
    }

    public static ECP generator() {
        BIG gx = new BIG(ROM.CURVE_Gx);
        ECP G = new ECP(gx);
        return G;
    }
}

