/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BLS24;

import org.apache.milagro.amcl.BLS24.BIG;
import org.apache.milagro.amcl.BLS24.FP;
import org.apache.milagro.amcl.BLS24.FP2;
import org.apache.milagro.amcl.BLS24.FP4;

public final class FP8 {
    private final FP4 a;
    private final FP4 b;

    public void reduce() {
        this.a.reduce();
        this.b.reduce();
    }

    public void norm() {
        this.a.norm();
        this.b.norm();
    }

    public boolean iszilch() {
        return this.a.iszilch() && this.b.iszilch();
    }

    public void cmove(FP8 g, int d) {
        this.a.cmove(g.a, d);
        this.b.cmove(g.b, d);
    }

    public boolean isunity() {
        FP4 one = new FP4(1);
        return this.a.equals(one) && this.b.iszilch();
    }

    public boolean isreal() {
        return this.b.iszilch();
    }

    public FP4 real() {
        return this.a;
    }

    public FP4 geta() {
        return this.a;
    }

    public FP4 getb() {
        return this.b;
    }

    public boolean equals(FP8 x) {
        return this.a.equals(x.a) && this.b.equals(x.b);
    }

    public FP8(int c) {
        this.a = new FP4(c);
        this.b = new FP4(0);
    }

    public FP8(FP8 x) {
        this.a = new FP4(x.a);
        this.b = new FP4(x.b);
    }

    public FP8(FP4 c, FP4 d) {
        this.a = new FP4(c);
        this.b = new FP4(d);
    }

    public FP8(FP4 c) {
        this.a = new FP4(c);
        this.b = new FP4(0);
    }

    public void copy(FP8 x) {
        this.a.copy(x.a);
        this.b.copy(x.b);
    }

    public void zero() {
        this.a.zero();
        this.b.zero();
    }

    public void one() {
        this.a.one();
        this.b.zero();
    }

    public void neg() {
        this.norm();
        FP4 m = new FP4(this.a);
        FP4 t = new FP4(0);
        m.add(this.b);
        m.neg();
        t.copy(m);
        t.add(this.b);
        this.b.copy(m);
        this.b.add(this.a);
        this.a.copy(t);
        this.norm();
    }

    public void conj() {
        this.b.neg();
        this.norm();
    }

    public void nconj() {
        this.a.neg();
        this.norm();
    }

    public void add(FP8 x) {
        this.a.add(x.a);
        this.b.add(x.b);
    }

    public void sub(FP8 x) {
        FP8 m = new FP8(x);
        m.neg();
        this.add(m);
    }

    public void rsub(FP8 x) {
        this.neg();
        this.add(x);
    }

    public void pmul(FP4 s) {
        this.a.mul(s);
        this.b.mul(s);
    }

    public void qmul(FP2 s) {
        this.a.pmul(s);
        this.b.pmul(s);
    }

    public void tmul(FP s) {
        this.a.qmul(s);
        this.b.qmul(s);
    }

    public void imul(int c) {
        this.a.imul(c);
        this.b.imul(c);
    }

    public void sqr() {
        FP4 t1 = new FP4(this.a);
        FP4 t2 = new FP4(this.b);
        FP4 t3 = new FP4(this.a);
        t3.mul(this.b);
        t1.add(this.b);
        t2.times_i();
        t2.add(this.a);
        t1.norm();
        t2.norm();
        this.a.copy(t1);
        this.a.mul(t2);
        t2.copy(t3);
        t2.times_i();
        t2.add(t3);
        t2.norm();
        t2.neg();
        this.a.add(t2);
        this.b.copy(t3);
        this.b.add(t3);
        this.norm();
    }

    public void mul(FP8 y) {
        FP4 t1 = new FP4(this.a);
        FP4 t2 = new FP4(this.b);
        FP4 t3 = new FP4(0);
        FP4 t4 = new FP4(this.b);
        t1.mul(y.a);
        t2.mul(y.b);
        t3.copy(y.b);
        t3.add(y.a);
        t4.add(this.a);
        t3.norm();
        t4.norm();
        t4.mul(t3);
        t3.copy(t1);
        t3.neg();
        t4.add(t3);
        t4.norm();
        t3.copy(t2);
        t3.neg();
        this.b.copy(t4);
        this.b.add(t3);
        t2.times_i();
        this.a.copy(t2);
        this.a.add(t1);
        this.norm();
    }

    public String toString() {
        return "[" + this.a.toString() + "," + this.b.toString() + "]";
    }

    public void inverse() {
        FP4 t1 = new FP4(this.a);
        FP4 t2 = new FP4(this.b);
        t1.sqr();
        t2.sqr();
        t2.times_i();
        t2.norm();
        t1.sub(t2);
        t1.norm();
        t1.inverse();
        this.a.mul(t1);
        t1.neg();
        t1.norm();
        this.b.mul(t1);
    }

    public void times_i() {
        FP4 s = new FP4(this.b);
        FP4 t = new FP4(this.a);
        s.times_i();
        this.b.copy(t);
        this.a.copy(s);
        this.norm();
    }

    public void times_i2() {
        this.a.times_i();
        this.b.times_i();
    }

    public void frob(FP2 f) {
        FP2 ff = new FP2(f);
        ff.sqr();
        ff.mul_ip();
        ff.norm();
        this.a.frob(ff);
        this.b.frob(ff);
        this.b.pmul(f);
        this.b.times_i();
    }

    public FP8 pow(BIG e) {
        this.norm();
        e.norm();
        FP8 w = new FP8(this);
        BIG z = new BIG(e);
        FP8 r = new FP8(1);
        while (true) {
            int bt = z.parity();
            z.fshr(1);
            if (bt == 1) {
                r.mul(w);
            }
            if (z.iszilch()) break;
            w.sqr();
        }
        r.reduce();
        return r;
    }

    public void xtr_A(FP8 w, FP8 y, FP8 z) {
        FP8 r = new FP8(w);
        FP8 t = new FP8(w);
        r.sub(y);
        r.norm();
        r.pmul(this.a);
        t.add(y);
        t.norm();
        t.pmul(this.b);
        t.times_i();
        this.copy(r);
        this.add(t);
        this.add(z);
        this.norm();
    }

    public void xtr_D() {
        FP8 w = new FP8(this);
        this.sqr();
        w.conj();
        w.add(w);
        w.norm();
        this.sub(w);
        this.reduce();
    }

    public FP8 xtr_pow(BIG n) {
        FP8 a = new FP8(3);
        FP8 b = new FP8(this);
        FP8 c = new FP8(b);
        c.xtr_D();
        FP8 t = new FP8(0);
        FP8 r = new FP8(0);
        n.norm();
        int par = n.parity();
        BIG v = new BIG(n);
        v.fshr(1);
        if (par == 0) {
            v.dec(1);
            v.norm();
        }
        int nb = v.nbits();
        for (int i = nb - 1; i >= 0; --i) {
            if (v.bit(i) != 1) {
                t.copy(b);
                this.conj();
                c.conj();
                b.xtr_A(a, this, c);
                this.conj();
                c.copy(t);
                c.xtr_D();
                a.xtr_D();
                continue;
            }
            t.copy(a);
            t.conj();
            a.copy(b);
            a.xtr_D();
            b.xtr_A(c, this, t);
            c.xtr_D();
        }
        if (par == 0) {
            r.copy(c);
        } else {
            r.copy(b);
        }
        r.reduce();
        return r;
    }

    public FP8 xtr_pow2(FP8 ck, FP8 ckml, FP8 ckm2l, BIG a, BIG b) {
        a.norm();
        b.norm();
        BIG e = new BIG(a);
        BIG d = new BIG(b);
        BIG w = new BIG(0);
        FP8 cu = new FP8(ck);
        FP8 cv = new FP8(this);
        FP8 cumv = new FP8(ckml);
        FP8 cum2v = new FP8(ckm2l);
        FP8 r = new FP8(0);
        FP8 t = new FP8(0);
        int f2 = 0;
        while (d.parity() == 0 && e.parity() == 0) {
            d.fshr(1);
            e.fshr(1);
            ++f2;
        }
        while (BIG.comp(d, e) != 0) {
            if (BIG.comp(d, e) > 0) {
                w.copy(e);
                w.imul(4);
                w.norm();
                if (BIG.comp(d, w) <= 0) {
                    w.copy(d);
                    d.copy(e);
                    e.rsub(w);
                    e.norm();
                    t.copy(cv);
                    t.xtr_A(cu, cumv, cum2v);
                    cum2v.copy(cumv);
                    cum2v.conj();
                    cumv.copy(cv);
                    cv.copy(cu);
                    cu.copy(t);
                } else if (d.parity() == 0) {
                    d.fshr(1);
                    r.copy(cum2v);
                    r.conj();
                    t.copy(cumv);
                    t.xtr_A(cu, cv, r);
                    cum2v.copy(cumv);
                    cum2v.xtr_D();
                    cumv.copy(t);
                    cu.xtr_D();
                } else if (e.parity() == 1) {
                    d.sub(e);
                    d.norm();
                    d.fshr(1);
                    t.copy(cv);
                    t.xtr_A(cu, cumv, cum2v);
                    cu.xtr_D();
                    cum2v.copy(cv);
                    cum2v.xtr_D();
                    cum2v.conj();
                    cv.copy(t);
                } else {
                    w.copy(d);
                    d.copy(e);
                    d.fshr(1);
                    e.copy(w);
                    t.copy(cumv);
                    t.xtr_D();
                    cumv.copy(cum2v);
                    cumv.conj();
                    cum2v.copy(t);
                    cum2v.conj();
                    t.copy(cv);
                    t.xtr_D();
                    cv.copy(cu);
                    cu.copy(t);
                }
            }
            if (BIG.comp(d, e) >= 0) continue;
            w.copy(d);
            w.imul(4);
            w.norm();
            if (BIG.comp(e, w) <= 0) {
                e.sub(d);
                e.norm();
                t.copy(cv);
                t.xtr_A(cu, cumv, cum2v);
                cum2v.copy(cumv);
                cumv.copy(cu);
                cu.copy(t);
                continue;
            }
            if (e.parity() == 0) {
                w.copy(d);
                d.copy(e);
                d.fshr(1);
                e.copy(w);
                t.copy(cumv);
                t.xtr_D();
                cumv.copy(cum2v);
                cumv.conj();
                cum2v.copy(t);
                cum2v.conj();
                t.copy(cv);
                t.xtr_D();
                cv.copy(cu);
                cu.copy(t);
                continue;
            }
            if (d.parity() == 1) {
                w.copy(e);
                e.copy(d);
                w.sub(d);
                w.norm();
                d.copy(w);
                d.fshr(1);
                t.copy(cv);
                t.xtr_A(cu, cumv, cum2v);
                cumv.conj();
                cum2v.copy(cu);
                cum2v.xtr_D();
                cum2v.conj();
                cu.copy(cv);
                cu.xtr_D();
                cv.copy(t);
                continue;
            }
            d.fshr(1);
            r.copy(cum2v);
            r.conj();
            t.copy(cumv);
            t.xtr_A(cu, cv, r);
            cum2v.copy(cumv);
            cum2v.xtr_D();
            cumv.copy(t);
            cu.xtr_D();
        }
        r.copy(cv);
        r.xtr_A(cu, cumv, cum2v);
        for (int i = 0; i < f2; ++i) {
            r.xtr_D();
        }
        r = r.xtr_pow(d);
        return r;
    }

    public void div2() {
        this.a.div2();
        this.b.div2();
    }

    public void div_i() {
        FP4 u = new FP4(this.a);
        FP4 v = new FP4(this.b);
        u.div_i();
        this.a.copy(v);
        this.b.copy(u);
    }

    public void div_i2() {
        this.a.div_i();
        this.b.div_i();
    }

    public void div_2i() {
        FP4 u = new FP4(this.a);
        FP4 v = new FP4(this.b);
        u.div_2i();
        v.add(v);
        v.norm();
        this.a.copy(v);
        this.b.copy(u);
    }

    public boolean sqrt() {
        if (this.iszilch()) {
            return true;
        }
        FP4 wa = new FP4(this.a);
        FP4 ws = new FP4(this.b);
        FP4 wt = new FP4(this.a);
        if (ws.iszilch()) {
            if (wt.sqrt()) {
                this.a.copy(wt);
                this.b.zero();
            } else {
                wt.div_i();
                wt.sqrt();
                this.b.copy(wt);
                this.a.zero();
            }
            return true;
        }
        ws.sqr();
        wa.sqr();
        ws.times_i();
        ws.norm();
        wa.sub(ws);
        ws.copy(wa);
        if (!ws.sqrt()) {
            return false;
        }
        wa.copy(wt);
        wa.add(ws);
        wa.norm();
        wa.div2();
        if (!wa.sqrt()) {
            wa.copy(wt);
            wa.sub(ws);
            wa.norm();
            wa.div2();
            if (!wa.sqrt()) {
                return false;
            }
        }
        wt.copy(this.b);
        ws.copy(wa);
        ws.add(wa);
        ws.inverse();
        wt.mul(ws);
        this.a.copy(wa);
        this.b.copy(wt);
        return true;
    }
}

