/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl;

public class AES {
    int Nk;
    int Nr;
    int mode;
    private int[] fkey = new int[60];
    private int[] rkey = new int[60];
    public byte[] f = new byte[16];
    public static final int ECB = 0;
    public static final int CBC = 1;
    public static final int CFB1 = 2;
    public static final int CFB2 = 3;
    public static final int CFB4 = 5;
    public static final int OFB1 = 14;
    public static final int OFB2 = 15;
    public static final int OFB4 = 17;
    public static final int OFB8 = 21;
    public static final int OFB16 = 29;
    public static final int CTR1 = 30;
    public static final int CTR2 = 31;
    public static final int CTR4 = 33;
    public static final int CTR8 = 37;
    public static final int CTR16 = 45;
    private static final byte[] InCo = new byte[]{11, 13, 9, 14};
    public static final int KS = 16;
    public static final int BS = 16;
    private static final byte[] ptab = new byte[]{1, 3, 5, 15, 17, 51, 85, -1, 26, 46, 114, -106, -95, -8, 19, 53, 95, -31, 56, 72, -40, 115, -107, -92, -9, 2, 6, 10, 30, 34, 102, -86, -27, 52, 92, -28, 55, 89, -21, 38, 106, -66, -39, 112, -112, -85, -26, 49, 83, -11, 4, 12, 20, 60, 68, -52, 79, -47, 104, -72, -45, 110, -78, -51, 76, -44, 103, -87, -32, 59, 77, -41, 98, -90, -15, 8, 24, 40, 120, -120, -125, -98, -71, -48, 107, -67, -36, 127, -127, -104, -77, -50, 73, -37, 118, -102, -75, -60, 87, -7, 16, 48, 80, -16, 11, 29, 39, 105, -69, -42, 97, -93, -2, 25, 43, 125, -121, -110, -83, -20, 47, 113, -109, -82, -23, 32, 96, -96, -5, 22, 58, 78, -46, 109, -73, -62, 93, -25, 50, 86, -6, 21, 63, 65, -61, 94, -30, 61, 71, -55, 64, -64, 91, -19, 44, 116, -100, -65, -38, 117, -97, -70, -43, 100, -84, -17, 42, 126, -126, -99, -68, -33, 122, -114, -119, -128, -101, -74, -63, 88, -24, 35, 101, -81, -22, 37, 111, -79, -56, 67, -59, 84, -4, 31, 33, 99, -91, -12, 7, 9, 27, 45, 119, -103, -80, -53, 70, -54, 69, -49, 74, -34, 121, -117, -122, -111, -88, -29, 62, 66, -58, 81, -13, 14, 18, 54, 90, -18, 41, 123, -115, -116, -113, -118, -123, -108, -89, -14, 13, 23, 57, 75, -35, 124, -124, -105, -94, -3, 28, 36, 108, -76, -57, 82, -10, 1};
    private static final byte[] ltab = new byte[]{0, -1, 25, 1, 50, 2, 26, -58, 75, -57, 27, 104, 51, -18, -33, 3, 100, 4, -32, 14, 52, -115, -127, -17, 76, 113, 8, -56, -8, 105, 28, -63, 125, -62, 29, -75, -7, -71, 39, 106, 77, -28, -90, 114, -102, -55, 9, 120, 101, 47, -118, 5, 33, 15, -31, 36, 18, -16, -126, 69, 53, -109, -38, -114, -106, -113, -37, -67, 54, -48, -50, -108, 19, 92, -46, -15, 64, 70, -125, 56, 102, -35, -3, 48, -65, 6, -117, 98, -77, 37, -30, -104, 34, -120, -111, 16, 126, 110, 72, -61, -93, -74, 30, 66, 58, 107, 40, 84, -6, -123, 61, -70, 43, 121, 10, 21, -101, -97, 94, -54, 78, -44, -84, -27, -13, 115, -89, 87, -81, 88, -88, 80, -12, -22, -42, 116, 79, -82, -23, -43, -25, -26, -83, -24, 44, -41, 117, 122, -21, 22, 11, -11, 89, -53, 95, -80, -100, -87, 81, -96, 127, 12, -10, 111, 23, -60, 73, -20, -40, 67, 31, 45, -92, 118, 123, -73, -52, -69, 62, 90, -5, 96, -79, -122, 59, 82, -95, 108, -86, 85, 41, -99, -105, -78, -121, -112, 97, -66, -36, -4, -68, -107, -49, -51, 55, 63, 91, -47, 83, 57, -124, 60, 65, -94, 109, 71, 20, 42, -98, 93, 86, -14, -45, -85, 68, 17, -110, -39, 35, 32, 46, -119, -76, 124, -72, 38, 119, -103, -29, -91, 103, 74, -19, -34, -59, 49, -2, 24, 13, 99, -116, -128, -64, -9, 112, 7};
    private static final byte[] fbsub = new byte[]{99, 124, 119, 123, -14, 107, 111, -59, 48, 1, 103, 43, -2, -41, -85, 118, -54, -126, -55, 125, -6, 89, 71, -16, -83, -44, -94, -81, -100, -92, 114, -64, -73, -3, -109, 38, 54, 63, -9, -52, 52, -91, -27, -15, 113, -40, 49, 21, 4, -57, 35, -61, 24, -106, 5, -102, 7, 18, -128, -30, -21, 39, -78, 117, 9, -125, 44, 26, 27, 110, 90, -96, 82, 59, -42, -77, 41, -29, 47, -124, 83, -47, 0, -19, 32, -4, -79, 91, 106, -53, -66, 57, 74, 76, 88, -49, -48, -17, -86, -5, 67, 77, 51, -123, 69, -7, 2, 127, 80, 60, -97, -88, 81, -93, 64, -113, -110, -99, 56, -11, -68, -74, -38, 33, 16, -1, -13, -46, -51, 12, 19, -20, 95, -105, 68, 23, -60, -89, 126, 61, 100, 93, 25, 115, 96, -127, 79, -36, 34, 42, -112, -120, 70, -18, -72, 20, -34, 94, 11, -37, -32, 50, 58, 10, 73, 6, 36, 92, -62, -45, -84, 98, -111, -107, -28, 121, -25, -56, 55, 109, -115, -43, 78, -87, 108, 86, -12, -22, 101, 122, -82, 8, -70, 120, 37, 46, 28, -90, -76, -58, -24, -35, 116, 31, 75, -67, -117, -118, 112, 62, -75, 102, 72, 3, -10, 14, 97, 53, 87, -71, -122, -63, 29, -98, -31, -8, -104, 17, 105, -39, -114, -108, -101, 30, -121, -23, -50, 85, 40, -33, -116, -95, -119, 13, -65, -26, 66, 104, 65, -103, 45, 15, -80, 84, -69, 22};
    private static final byte[] rbsub = new byte[]{82, 9, 106, -43, 48, 54, -91, 56, -65, 64, -93, -98, -127, -13, -41, -5, 124, -29, 57, -126, -101, 47, -1, -121, 52, -114, 67, 68, -60, -34, -23, -53, 84, 123, -108, 50, -90, -62, 35, 61, -18, 76, -107, 11, 66, -6, -61, 78, 8, 46, -95, 102, 40, -39, 36, -78, 118, 91, -94, 73, 109, -117, -47, 37, 114, -8, -10, 100, -122, 104, -104, 22, -44, -92, 92, -52, 93, 101, -74, -110, 108, 112, 72, 80, -3, -19, -71, -38, 94, 21, 70, 87, -89, -115, -99, -124, -112, -40, -85, 0, -116, -68, -45, 10, -9, -28, 88, 5, -72, -77, 69, 6, -48, 44, 30, -113, -54, 63, 15, 2, -63, -81, -67, 3, 1, 19, -118, 107, 58, -111, 17, 65, 79, 103, -36, -22, -105, -14, -49, -50, -16, -76, -26, 115, -106, -84, 116, 34, -25, -83, 53, -123, -30, -7, 55, -24, 28, 117, -33, 110, 71, -15, 26, 113, 29, 41, -59, -119, 111, -73, 98, 14, -86, 24, -66, 27, -4, 86, 62, 75, -58, -46, 121, 32, -102, -37, -64, -2, 120, -51, 90, -12, 31, -35, -88, 51, -120, 7, -57, 49, -79, 18, 16, 89, 39, -128, -20, 95, 96, 81, 127, -87, 25, -75, 74, 13, 45, -27, 122, -97, -109, -55, -100, -17, -96, -32, 59, 77, -82, 42, -11, -80, -56, -21, -69, 60, -125, 83, -103, 97, 23, 43, 4, 126, -70, 119, -42, 38, -31, 105, 20, 99, 85, 33, 12, 125};
    private static final byte[] rco = new byte[]{1, 2, 4, 8, 16, 32, 64, -128, 27, 54, 108, -40, -85, 77, -102, 47};
    private static final int[] ftable = new int[]{-1520213050, -2072216328, -1720223762, -1921287178, 0xDF2F2FF, -1117033514, -1318096930, 1422247313, 1345335392, 50397442, -1452841010, 2099981142, 436141799, 1658312629, -424957107, -1703512340, 1170918031, -1652391393, 1086966153, -2021818886, 368769775, -346465870, -918075506, 0xBF0F0FB, -324162239, 1742001331, -39673249, -357585083, -1080255453, -140204973, -1770884380, 1539358875, -1028147339, 486407649, -1366060227, 1780885068, 1513502316, 1094664062, 49805301, 1338821763, 1546925160, -190470831, 887481809, 150073849, -1821281822, 1943591083, 1395732834, 1058346282, 201589768, 1388824469, 1696801606, 1589887901, 672667696, -1583966665, 251987210, -1248159185, 151455502, 907153956, -1686077413, 1038279391, 652995533, 1764173646, -843926913, -1619692054, 453576978, -1635548387, 1949051992, 773462580, 756751158, -1301385508, -296068428, -73359269, -162377052, 1295727478, 1641469623, -827083907, 2066295122, 0x3EE3E3DD, 1898917726, -1752923117, -179088474, 1758581177, 0, 753790401, 1612718144, 536673507, -927878791, -312779850, -1100322092, 1187761037, -641810841, 1262041458, -565556588, -733197160, -396863312, 1255133061, 1808847035, 720367557, -441800113, 385612781, -985447546, -682799718, 0x55333366, -1803188975, -817543798, 284817897, 100794884, -2122350594, -263171936, 1144798328, -1163944155, -475486133, -212774494, -22830243, -1069531008, -1970303227, -1382903233, -1130521311, 1211644016, 83228145, -541279133, -1044990345, 1977277103, 1663115586, 806359072, 452984805, 250868733, 1842533055, 1288555905, 336333848, 890442534, 804056259, -513843266, -1567123659, -867941240, 957814574, 1472513171, -223893675, -2105639172, 1195195770, -1402706744, -413311558, 723065138, -1787595802, -1604296512, -1736343271, -783331426, 2145180835, 0x66222244, 2116692564, -1416589253, -2088204277, -901364084, 703524551, -742868885, 1007948840, 2044649127, -497131844, 487262998, 1994120109, 1004593371, 1446130276, 1312438900, 503974420, -615954030, 168166924, 1814307912, -463709000, 1573044895, 1859376061, -273896381, -1503501628, -1466855111, -1533700815, 937747667, -1954973198, 854058965, 1137232011, 1496790894, -1217565222, -1936880383, 1691735473, -766620004, -525751991, -1267962664, -95005012, 133494003, 636152527, -1352309302, -1904575756, -374428089, 0x18080810, -709182865, -2005370640, 1864705354, 1915629148, 605822008, -240736681, -944458637, 1371981463, 602466507, 2094914977, -1670089496, 555687742, -582268010, -591544991, -2037675251, -2054518257, -1871679264, 1111375484, -994724495, -1436129588, -666351472, 84083462, 32962295, 302911004, -1553899070, 1597322602, -111716434, -793134743, -1853454825, 1489093017, 656219450, -1180787161, 954327513, 335083755, -1281845205, 0x33111122, -1150719534, 1893325225, -1987146233, -1483434957, -1231316179, 572399164, -1836611819, 552200649, 1238290055, -11184726, 2015897680, 2061492133, -1886614525, -123625127, -2138470135, 386731290, -624967835, 837215959, -968736124, -1201116976, -1019133566, -1332111063, 1999449434, 286199582, -877612933, -61582168, -692339859, 974525996};
    private static final int[] rtable = new int[]{1353184337, 1399144830, -1012656358, -1772214470, -882136261, -247096033, -1420232020, -1828461749, 1442459680, -160598355, -1854485368, 625738485, -52959921, -674551099, -2143013594, -1885117771, 1230680542, 1729870373, -1743852987, -507445667, 41234371, 317738113, -1550367091, -956705941, -413167869, -1784901099, -344298049, -631680363, 763608788, -752782248, 694804553, 1154009486, 1787413109, 2021232372, 1799248025, -579749593, -1236278850, 397248752, 1722556617, -1271214467, 407560035, -2110711067, 1613975959, 1165972322, -529046351, -2068943941, 480281086, -1809118983, 1483229296, 436028815, -2022908268, -1208452270, 601060267, -503166094, 1468997603, 715871590, 120122290, 63092015, -1703164538, -1526188077, -226023376, -1297760477, -1167457534, 1552029421, 723308426, -1833666137, -252573709, -1578997426, -839591323, -708967162, 526529745, -1963022652, -1655493068, -1604979806, 853641733, 1978398372, 971801355, -1427152832, 111112542, 1360031421, -108388034, 1023860118, -1375387939, 1186850381, -1249028975, 90031217, 1876166148, -15380384, 620468249, -1746289194, -868007799, 2006899047, -1119688528, -2004121337, 945494503, -605108103, 1191869601, -384875908, -920746760, 0, -2088337399, 1223502642, -1401941730, 1316117100, -67170563, 1446544655, 517320253, 658058550, 1691946762, 564550760, -783000677, 976107044, -1318647284, 266819475, -761860428, -1634624741, 1338359936, -1574904735, 1766553434, 370807324, 179999714, -450191168, 1138762300, 488053522, 185403662, -1379431438, -1180125651, -928440812, -2061897385, 1275557295, -1143105042, -44007517, -1624899081, -1124765092, -985962940, 880737115, 1982415755, -590994485, 1761406390, 1676797112, -891538985, 277177154, 1076008723, 538035844, 2099530373, -130171950, 288553390, 1839278535, 1261411869, -214912292, -330136051, -790380169, 1813426987, -1715900247, -95906799, 577038663, -997393240, 440397984, -668172970, -275762398, -951170681, -1043253031, -22885748, 906744984, -813566554, 685669029, 646887386, -1530942145, -459458004, 227702864, -1681105046, 1648787028, -1038905866, -390539120, 1593260334, -173030526, -1098883681, 2090061929, -1456614033, -1290656305, 999926984, -1484974064, 1852021992, 2075868123, 158869197, -199730834, 28809964, -1466282109, 1701746150, 2129067946, 147831841, -420997649, -644094022, -835293366, -737566742, -696471511, -1347247055, 824393514, 815048134, -1067015627, 935087732, -1496677636, -1328508704, 366520115, 1251476721, -136647615, 240176511, 804688151, -1915335306, 1303441219, 1414376140, -553347356, -474623586, 461924940, -1205916479, 2136040774, 82468509, 1563790337, 1937016826, 776014843, 1511876531, 1389550482, 861278441, 323475053, -1939744870, 2047648055, -1911228327, -1992551445, -299390514, 902390199, -303751967, 1018251130, 1507840668, 1064563285, 2043548696, -1086863501, -355600557, 1537932639, 342834655, -2032450440, -2114736182, 1053059257, 741614648, 1598071746, 1925389590, 203809468, -1958134744, 1100287487, 1895934009, -558691320, -1662733096, -1866377628, 1636092795, 1890988757, 1952214088, 1113045200};

    private static int ROTL8(int x) {
        return x << 8 | x >>> 24;
    }

    private static int ROTL16(int x) {
        return x << 16 | x >>> 16;
    }

    private static int ROTL24(int x) {
        return x << 24 | x >>> 8;
    }

    private static int pack(byte[] b) {
        return (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
    }

    private static byte[] unpack(int a) {
        byte[] b = new byte[]{(byte)a, (byte)(a >>> 8), (byte)(a >>> 16), (byte)(a >>> 24)};
        return b;
    }

    private static byte bmul(byte x, byte y) {
        int ix = x & 0xFF;
        int iy = y & 0xFF;
        int lx = ltab[ix] & 0xFF;
        int ly = ltab[iy] & 0xFF;
        if (x != 0 && y != 0) {
            return ptab[(lx + ly) % 255];
        }
        return 0;
    }

    private static int SubByte(int a) {
        byte[] b = AES.unpack(a);
        b[0] = fbsub[b[0] & 0xFF];
        b[1] = fbsub[b[1] & 0xFF];
        b[2] = fbsub[b[2] & 0xFF];
        b[3] = fbsub[b[3] & 0xFF];
        return AES.pack(b);
    }

    private static byte product(int x, int y) {
        byte[] xb = AES.unpack(x);
        byte[] yb = AES.unpack(y);
        return (byte)(AES.bmul(xb[0], yb[0]) ^ AES.bmul(xb[1], yb[1]) ^ AES.bmul(xb[2], yb[2]) ^ AES.bmul(xb[3], yb[3]));
    }

    private static int InvMixCol(int x) {
        byte[] b = new byte[4];
        int m = AES.pack(InCo);
        b[3] = AES.product(m, x);
        m = AES.ROTL24(m);
        b[2] = AES.product(m, x);
        m = AES.ROTL24(m);
        b[1] = AES.product(m, x);
        m = AES.ROTL24(m);
        b[0] = AES.product(m, x);
        int y = AES.pack(b);
        return y;
    }

    private static void increment(byte[] f) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            f[n] = (byte)(f[n] + 1);
            if (f[i] != 0) break;
        }
    }

    public void reset(int m, byte[] iv) {
        int i;
        this.mode = m;
        for (i = 0; i < 16; ++i) {
            this.f[i] = 0;
        }
        if (this.mode != 0 && iv != null) {
            for (i = 0; i < 16; ++i) {
                this.f[i] = iv[i];
            }
        }
    }

    public byte[] getreg() {
        byte[] ir = new byte[16];
        for (int i = 0; i < 16; ++i) {
            ir[i] = this.f[i];
        }
        return ir;
    }

    public boolean init(int m, int nk, byte[] key, byte[] iv) {
        int k;
        int[] CipherKey = new int[8];
        byte[] b = new byte[4];
        if ((nk /= 4) != 4 && nk != 6 && nk != 8) {
            return false;
        }
        int nr = 6 + nk;
        this.Nk = nk;
        this.Nr = nr;
        this.reset(m, iv);
        int N = 4 * (nr + 1);
        int j = 0;
        int i = 0;
        while (i < nk) {
            for (k = 0; k < 4; ++k) {
                b[k] = key[j + k];
            }
            CipherKey[i] = AES.pack(b);
            ++i;
            j += 4;
        }
        for (i = 0; i < nk; ++i) {
            this.fkey[i] = CipherKey[i];
        }
        j = nk;
        k = 0;
        while (j < N) {
            this.fkey[j] = this.fkey[j - nk] ^ AES.SubByte(AES.ROTL24(this.fkey[j - 1])) ^ rco[k] & 0xFF;
            for (i = 1; i < nk && i + j < N; ++i) {
                this.fkey[i + j] = this.fkey[i + j - nk] ^ this.fkey[i + j - 1];
            }
            j += nk;
            ++k;
        }
        for (j = 0; j < 4; ++j) {
            this.rkey[j + N - 4] = this.fkey[j];
        }
        for (i = 4; i < N - 4; i += 4) {
            k = N - 4 - i;
            for (j = 0; j < 4; ++j) {
                this.rkey[k + j] = AES.InvMixCol(this.fkey[i + j]);
            }
        }
        for (j = N - 4; j < N; ++j) {
            this.rkey[j - N + 4] = this.fkey[j];
        }
        return true;
    }

    public void ecb_encrypt(byte[] buff) {
        int k;
        byte[] b = new byte[4];
        int[] p = new int[4];
        int[] q = new int[4];
        int j = 0;
        int i = 0;
        while (i < 4) {
            for (k = 0; k < 4; ++k) {
                b[k] = buff[j + k];
            }
            p[i] = AES.pack(b);
            int n = i;
            p[n] = p[n] ^ this.fkey[i];
            ++i;
            j += 4;
        }
        k = 4;
        for (i = 1; i < this.Nr; ++i) {
            q[0] = this.fkey[k] ^ ftable[p[0] & 0xFF] ^ AES.ROTL8(ftable[p[1] >>> 8 & 0xFF]) ^ AES.ROTL16(ftable[p[2] >>> 16 & 0xFF]) ^ AES.ROTL24(ftable[p[3] >>> 24 & 0xFF]);
            q[1] = this.fkey[k + 1] ^ ftable[p[1] & 0xFF] ^ AES.ROTL8(ftable[p[2] >>> 8 & 0xFF]) ^ AES.ROTL16(ftable[p[3] >>> 16 & 0xFF]) ^ AES.ROTL24(ftable[p[0] >>> 24 & 0xFF]);
            q[2] = this.fkey[k + 2] ^ ftable[p[2] & 0xFF] ^ AES.ROTL8(ftable[p[3] >>> 8 & 0xFF]) ^ AES.ROTL16(ftable[p[0] >>> 16 & 0xFF]) ^ AES.ROTL24(ftable[p[1] >>> 24 & 0xFF]);
            q[3] = this.fkey[k + 3] ^ ftable[p[3] & 0xFF] ^ AES.ROTL8(ftable[p[0] >>> 8 & 0xFF]) ^ AES.ROTL16(ftable[p[1] >>> 16 & 0xFF]) ^ AES.ROTL24(ftable[p[2] >>> 24 & 0xFF]);
            k += 4;
            for (j = 0; j < 4; ++j) {
                int t = p[j];
                p[j] = q[j];
                q[j] = t;
            }
        }
        q[0] = this.fkey[k] ^ fbsub[p[0] & 0xFF] & 0xFF ^ AES.ROTL8(fbsub[p[1] >>> 8 & 0xFF] & 0xFF) ^ AES.ROTL16(fbsub[p[2] >>> 16 & 0xFF] & 0xFF) ^ AES.ROTL24(fbsub[p[3] >>> 24 & 0xFF] & 0xFF);
        q[1] = this.fkey[k + 1] ^ fbsub[p[1] & 0xFF] & 0xFF ^ AES.ROTL8(fbsub[p[2] >>> 8 & 0xFF] & 0xFF) ^ AES.ROTL16(fbsub[p[3] >>> 16 & 0xFF] & 0xFF) ^ AES.ROTL24(fbsub[p[0] >>> 24 & 0xFF] & 0xFF);
        q[2] = this.fkey[k + 2] ^ fbsub[p[2] & 0xFF] & 0xFF ^ AES.ROTL8(fbsub[p[3] >>> 8 & 0xFF] & 0xFF) ^ AES.ROTL16(fbsub[p[0] >>> 16 & 0xFF] & 0xFF) ^ AES.ROTL24(fbsub[p[1] >>> 24 & 0xFF] & 0xFF);
        q[3] = this.fkey[k + 3] ^ fbsub[p[3] & 0xFF] & 0xFF ^ AES.ROTL8(fbsub[p[0] >>> 8 & 0xFF] & 0xFF) ^ AES.ROTL16(fbsub[p[1] >>> 16 & 0xFF] & 0xFF) ^ AES.ROTL24(fbsub[p[2] >>> 24 & 0xFF] & 0xFF);
        j = 0;
        i = 0;
        while (i < 4) {
            b = AES.unpack(q[i]);
            for (k = 0; k < 4; ++k) {
                buff[j + k] = b[k];
            }
            ++i;
            j += 4;
        }
    }

    public void ecb_decrypt(byte[] buff) {
        int k;
        byte[] b = new byte[4];
        int[] p = new int[4];
        int[] q = new int[4];
        int j = 0;
        int i = 0;
        while (i < 4) {
            for (k = 0; k < 4; ++k) {
                b[k] = buff[j + k];
            }
            p[i] = AES.pack(b);
            int n = i;
            p[n] = p[n] ^ this.rkey[i];
            ++i;
            j += 4;
        }
        k = 4;
        for (i = 1; i < this.Nr; ++i) {
            q[0] = this.rkey[k] ^ rtable[p[0] & 0xFF] ^ AES.ROTL8(rtable[p[3] >>> 8 & 0xFF]) ^ AES.ROTL16(rtable[p[2] >>> 16 & 0xFF]) ^ AES.ROTL24(rtable[p[1] >>> 24 & 0xFF]);
            q[1] = this.rkey[k + 1] ^ rtable[p[1] & 0xFF] ^ AES.ROTL8(rtable[p[0] >>> 8 & 0xFF]) ^ AES.ROTL16(rtable[p[3] >>> 16 & 0xFF]) ^ AES.ROTL24(rtable[p[2] >>> 24 & 0xFF]);
            q[2] = this.rkey[k + 2] ^ rtable[p[2] & 0xFF] ^ AES.ROTL8(rtable[p[1] >>> 8 & 0xFF]) ^ AES.ROTL16(rtable[p[0] >>> 16 & 0xFF]) ^ AES.ROTL24(rtable[p[3] >>> 24 & 0xFF]);
            q[3] = this.rkey[k + 3] ^ rtable[p[3] & 0xFF] ^ AES.ROTL8(rtable[p[2] >>> 8 & 0xFF]) ^ AES.ROTL16(rtable[p[1] >>> 16 & 0xFF]) ^ AES.ROTL24(rtable[p[0] >>> 24 & 0xFF]);
            k += 4;
            for (j = 0; j < 4; ++j) {
                int t = p[j];
                p[j] = q[j];
                q[j] = t;
            }
        }
        q[0] = this.rkey[k] ^ rbsub[p[0] & 0xFF] & 0xFF ^ AES.ROTL8(rbsub[p[3] >>> 8 & 0xFF] & 0xFF) ^ AES.ROTL16(rbsub[p[2] >>> 16 & 0xFF] & 0xFF) ^ AES.ROTL24(rbsub[p[1] >>> 24 & 0xFF] & 0xFF);
        q[1] = this.rkey[k + 1] ^ rbsub[p[1] & 0xFF] & 0xFF ^ AES.ROTL8(rbsub[p[0] >>> 8 & 0xFF] & 0xFF) ^ AES.ROTL16(rbsub[p[3] >>> 16 & 0xFF] & 0xFF) ^ AES.ROTL24(rbsub[p[2] >>> 24 & 0xFF] & 0xFF);
        q[2] = this.rkey[k + 2] ^ rbsub[p[2] & 0xFF] & 0xFF ^ AES.ROTL8(rbsub[p[1] >>> 8 & 0xFF] & 0xFF) ^ AES.ROTL16(rbsub[p[0] >>> 16 & 0xFF] & 0xFF) ^ AES.ROTL24(rbsub[p[3] >>> 24 & 0xFF] & 0xFF);
        q[3] = this.rkey[k + 3] ^ rbsub[p[3] & 0xFF] & 0xFF ^ AES.ROTL8(rbsub[p[2] >>> 8 & 0xFF] & 0xFF) ^ AES.ROTL16(rbsub[p[1] >>> 16 & 0xFF] & 0xFF) ^ AES.ROTL24(rbsub[p[0] >>> 24 & 0xFF] & 0xFF);
        j = 0;
        i = 0;
        while (i < 4) {
            b = AES.unpack(q[i]);
            for (k = 0; k < 4; ++k) {
                buff[j + k] = b[k];
            }
            ++i;
            j += 4;
        }
    }

    public int encrypt(byte[] buff) {
        byte[] st = new byte[16];
        int fell_off = 0;
        switch (this.mode) {
            case 0: {
                this.ecb_encrypt(buff);
                return 0;
            }
            case 1: {
                int j;
                for (j = 0; j < 16; ++j) {
                    int n = j;
                    buff[n] = (byte)(buff[n] ^ this.f[j]);
                }
                this.ecb_encrypt(buff);
                for (j = 0; j < 16; ++j) {
                    this.f[j] = buff[j];
                }
                return 0;
            }
            case 2: 
            case 3: 
            case 5: {
                int j;
                int bytes = this.mode - 2 + 1;
                for (j = 0; j < bytes; ++j) {
                    fell_off = fell_off << 8 | this.f[j];
                }
                for (j = 0; j < 16; ++j) {
                    st[j] = this.f[j];
                }
                for (j = bytes; j < 16; ++j) {
                    this.f[j - bytes] = this.f[j];
                }
                this.ecb_encrypt(st);
                for (j = 0; j < bytes; ++j) {
                    int n = j;
                    buff[n] = (byte)(buff[n] ^ st[j]);
                    this.f[16 - bytes + j] = buff[j];
                }
                return fell_off;
            }
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 29: {
                int bytes = this.mode - 14 + 1;
                this.ecb_encrypt(this.f);
                for (int j = 0; j < bytes; ++j) {
                    int n = j;
                    buff[n] = (byte)(buff[n] ^ this.f[j]);
                }
                return 0;
            }
            case 30: 
            case 31: 
            case 33: 
            case 37: 
            case 45: {
                int j;
                int bytes = this.mode - 30 + 1;
                for (j = 0; j < 16; ++j) {
                    st[j] = this.f[j];
                }
                this.ecb_encrypt(st);
                for (j = 0; j < bytes; ++j) {
                    int n = j;
                    buff[n] = (byte)(buff[n] ^ st[j]);
                }
                AES.increment(this.f);
            }
        }
        return 0;
    }

    public int decrypt(byte[] buff) {
        byte[] st = new byte[16];
        int fell_off = 0;
        switch (this.mode) {
            case 0: {
                this.ecb_decrypt(buff);
                return 0;
            }
            case 1: {
                int j;
                for (j = 0; j < 16; ++j) {
                    st[j] = this.f[j];
                    this.f[j] = buff[j];
                }
                this.ecb_decrypt(buff);
                for (j = 0; j < 16; ++j) {
                    int n = j;
                    buff[n] = (byte)(buff[n] ^ st[j]);
                    st[j] = 0;
                }
                return 0;
            }
            case 2: 
            case 3: 
            case 5: {
                int j;
                int bytes = this.mode - 2 + 1;
                for (j = 0; j < bytes; ++j) {
                    fell_off = fell_off << 8 | this.f[j];
                }
                for (j = 0; j < 16; ++j) {
                    st[j] = this.f[j];
                }
                for (j = bytes; j < 16; ++j) {
                    this.f[j - bytes] = this.f[j];
                }
                this.ecb_encrypt(st);
                for (j = 0; j < bytes; ++j) {
                    this.f[16 - bytes + j] = buff[j];
                    int n = j;
                    buff[n] = (byte)(buff[n] ^ st[j]);
                }
                return fell_off;
            }
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 29: {
                int bytes = this.mode - 14 + 1;
                this.ecb_encrypt(this.f);
                for (int j = 0; j < bytes; ++j) {
                    int n = j;
                    buff[n] = (byte)(buff[n] ^ this.f[j]);
                }
                return 0;
            }
            case 30: 
            case 31: 
            case 33: 
            case 37: 
            case 45: {
                int j;
                int bytes = this.mode - 30 + 1;
                for (j = 0; j < 16; ++j) {
                    st[j] = this.f[j];
                }
                this.ecb_encrypt(st);
                for (j = 0; j < bytes; ++j) {
                    int n = j;
                    buff[n] = (byte)(buff[n] ^ st[j]);
                }
                AES.increment(this.f);
            }
        }
        return 0;
    }

    public void end() {
        int i;
        for (i = 0; i < 4 * (this.Nr + 1); ++i) {
            this.rkey[i] = 0;
            this.fkey[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            this.f[i] = 0;
        }
    }

    public static void main(String[] args) {
        int i;
        byte[] key = new byte[32];
        byte[] block = new byte[16];
        byte[] iv = new byte[16];
        for (i = 0; i < 32; ++i) {
            key[i] = 0;
        }
        key[0] = 1;
        for (i = 0; i < 16; ++i) {
            iv[i] = (byte)i;
        }
        for (i = 0; i < 16; ++i) {
            block[i] = (byte)i;
        }
        AES a = new AES();
        a.init(45, 32, key, iv);
        System.out.println("Plain= ");
        for (i = 0; i < 16; ++i) {
            System.out.format("%02X ", block[i] & 0xFF);
        }
        System.out.println("");
        a.encrypt(block);
        System.out.println("Encrypt= ");
        for (i = 0; i < 16; ++i) {
            System.out.format("%02X ", block[i] & 0xFF);
        }
        System.out.println("");
        a.reset(45, iv);
        a.decrypt(block);
        System.out.println("Decrypt= ");
        for (i = 0; i < 16; ++i) {
            System.out.format("%02X ", block[i] & 0xFF);
        }
        System.out.println("");
        a.end();
    }
}

