/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.discovery;

import java.lang.reflect.Method;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.DiscoverySelector;

@API(value=API.Usage.Experimental)
public class MethodSelector
implements DiscoverySelector {
    private final Class<?> testClass;
    private final Method testMethod;

    public static MethodSelector forMethod(String testClassName, String testMethodName) {
        Class<?> testClass = MethodSelector.getTestClass(testClassName);
        Method testMethod = MethodSelector.getTestMethod(testClass, testMethodName);
        return MethodSelector.forMethod(testClass, testMethod);
    }

    public static MethodSelector forMethod(Class<?> testClass, String testMethodName) {
        Method testMethod = MethodSelector.getTestMethod(testClass, testMethodName);
        return MethodSelector.forMethod(testClass, testMethod);
    }

    public static MethodSelector forMethod(Class<?> testClass, Method testMethod) {
        return new MethodSelector(testClass, testMethod);
    }

    private MethodSelector(Class<?> testClass, Method testMethod) {
        this.testClass = testClass;
        this.testMethod = testMethod;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    private static Class<?> getTestClass(String testClassName) {
        return (Class)ReflectionUtils.loadClass((String)testClassName).get();
    }

    private static Method getTestMethod(Class<?> testClass, String testMethodName) {
        return (Method)ReflectionUtils.findMethod(testClass, (String)testMethodName, (Class[])new Class[0]).get();
    }
}

