/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.discovery;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.DiscoverySelector;

@API(value=API.Usage.Experimental)
public class ClasspathSelector
implements DiscoverySelector {
    private final File classpathRoot;

    public static List<DiscoverySelector> forPath(String path) {
        return ClasspathSelector.forPaths(Collections.singleton(new File(path)));
    }

    public static List<DiscoverySelector> forPaths(Set<File> paths) {
        return paths.stream().filter(File::exists).map(ClasspathSelector::new).collect(Collectors.toList());
    }

    private ClasspathSelector(File classpathRoot) {
        this.classpathRoot = classpathRoot;
    }

    public File getClasspathRoot() {
        return this.classpathRoot;
    }
}

