/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.percolator.PercolateAction;
import org.elasticsearch.percolator.PercolateRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestToXContentListener;

@Deprecated
public class RestPercolateAction
extends BaseRestHandler {
    @Inject
    public RestPercolateAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_percolate", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_percolate", (RestHandler)this);
        RestPercolateExistingDocHandler existingDocHandler = new RestPercolateExistingDocHandler(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_percolate", (RestHandler)existingDocHandler);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_percolate", (RestHandler)existingDocHandler);
        RestCountPercolateDocHandler countHandler = new RestCountPercolateDocHandler(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_percolate/count", (RestHandler)countHandler);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_percolate/count", (RestHandler)countHandler);
        RestCountPercolateExistingDocHandler countExistingDocHandler = new RestCountPercolateExistingDocHandler(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_percolate/count", (RestHandler)countExistingDocHandler);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_percolate/count", (RestHandler)countExistingDocHandler);
    }

    private BaseRestHandler.RestChannelConsumer parseDocPercolate(PercolateRequest percolateRequest, RestRequest restRequest, NodeClient client) {
        percolateRequest.indices(Strings.splitStringByCommaToArray((String)restRequest.param("index")));
        percolateRequest.documentType(restRequest.param("type"));
        percolateRequest.routing(restRequest.param("routing"));
        percolateRequest.preference(restRequest.param("preference"));
        percolateRequest.source((BytesReference)restRequest.contentOrSourceParam().v2());
        percolateRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)restRequest, (IndicesOptions)percolateRequest.indicesOptions()));
        return channel -> this.executePercolate(client, percolateRequest, (RestChannel)channel);
    }

    private BaseRestHandler.RestChannelConsumer parseExistingDocPercolate(PercolateRequest percolateRequest, RestRequest restRequest, NodeClient client) {
        String index = restRequest.param("index");
        String type = restRequest.param("type");
        percolateRequest.indices(Strings.splitStringByCommaToArray((String)restRequest.param("percolate_index", index)));
        percolateRequest.documentType(restRequest.param("percolate_type", type));
        GetRequest getRequest = new GetRequest(index, type, restRequest.param("id"));
        getRequest.routing(restRequest.param("routing"));
        getRequest.preference(restRequest.param("preference"));
        getRequest.refresh(restRequest.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.realtime(restRequest.paramAsBoolean("realtime", getRequest.realtime()));
        getRequest.version(RestActions.parseVersion((RestRequest)restRequest));
        getRequest.versionType(VersionType.fromString((String)restRequest.param("version_type"), (VersionType)getRequest.versionType()));
        percolateRequest.getRequest(getRequest);
        percolateRequest.routing(restRequest.param("percolate_routing"));
        percolateRequest.preference(restRequest.param("percolate_preference"));
        if (restRequest.hasContentOrSourceParam()) {
            percolateRequest.source((BytesReference)restRequest.contentOrSourceParam().v2());
        }
        percolateRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)restRequest, (IndicesOptions)percolateRequest.indicesOptions()));
        return channel -> this.executePercolate(client, percolateRequest, (RestChannel)channel);
    }

    private void executePercolate(NodeClient client, PercolateRequest percolateRequest, RestChannel restChannel) {
        client.execute((Action)PercolateAction.INSTANCE, (ActionRequest)percolateRequest, (ActionListener)new RestToXContentListener(restChannel));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        PercolateRequest percolateRequest = new PercolateRequest();
        return this.parseDocPercolate(percolateRequest, restRequest, client);
    }

    private final class RestCountPercolateExistingDocHandler
    extends BaseRestHandler {
        RestCountPercolateExistingDocHandler(Settings settings) {
            super(settings);
        }

        public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
            PercolateRequest percolateRequest = new PercolateRequest();
            percolateRequest.onlyCount(true);
            return RestPercolateAction.this.parseExistingDocPercolate(percolateRequest, restRequest, client);
        }
    }

    private final class RestPercolateExistingDocHandler
    extends BaseRestHandler {
        RestPercolateExistingDocHandler(Settings settings) {
            super(settings);
        }

        public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
            PercolateRequest percolateRequest = new PercolateRequest();
            return RestPercolateAction.this.parseExistingDocPercolate(percolateRequest, restRequest, client);
        }
    }

    private final class RestCountPercolateDocHandler
    extends BaseRestHandler {
        private RestCountPercolateDocHandler(Settings settings) {
            super(settings);
        }

        public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
            PercolateRequest percolateRequest = new PercolateRequest();
            percolateRequest.onlyCount(true);
            return RestPercolateAction.this.parseDocPercolate(percolateRequest, restRequest, client);
        }
    }
}

