/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.support;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import org.apache.rocketmq.client.annotation.RocketMQMessageListener;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.FilterExpressionType;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.consumer.PushConsumer;
import org.apache.rocketmq.client.apis.consumer.PushConsumerBuilder;
import org.apache.rocketmq.client.core.RocketMQListener;
import org.apache.rocketmq.client.support.RocketMQListenerContainer;
import org.apache.rocketmq.client.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultListenerContainer
implements InitializingBean,
RocketMQListenerContainer,
SmartLifecycle,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultListenerContainer.class);
    private ApplicationContext applicationContext;
    private String name;
    private boolean running;
    private PushConsumer pushConsumer;
    private PushConsumerBuilder pushConsumerBuilder;
    private RocketMQListener rocketMQListener;
    private RocketMQMessageListener rocketMQMessageListener;
    String accessKey;
    String secretKey;
    String endpoints;
    String consumerGroup;
    String tag;
    String topic;
    String type;
    FilterExpressionType filterExpressionType;
    Duration requestTimeout;
    int maxCachedMessageCount = 1024;
    int maxCacheMessageSizeInBytes = 0x4000000;
    int consumptionThreadCount = 20;
    Boolean sslEnabled;
    String namespace;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public PushConsumer getPushConsumer() {
        return this.pushConsumer;
    }

    public void setPushConsumer(PushConsumer pushConsumer) {
        this.pushConsumer = pushConsumer;
    }

    public PushConsumerBuilder getPushConsumerBuilder() {
        return this.pushConsumerBuilder;
    }

    public void setPushConsumerBuilder(PushConsumerBuilder pushConsumerBuilder) {
        this.pushConsumerBuilder = pushConsumerBuilder;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(String endpoints) {
        this.endpoints = endpoints;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public FilterExpressionType getFilterExpressionType() {
        return this.filterExpressionType;
    }

    public void setFilterExpressionType(FilterExpressionType filterExpressionType) {
        this.filterExpressionType = filterExpressionType;
    }

    public int getMaxCachedMessageCount() {
        return this.maxCachedMessageCount;
    }

    public void setMaxCachedMessageCount(int maxCachedMessageCount) {
        this.maxCachedMessageCount = maxCachedMessageCount;
    }

    public int getMaxCacheMessageSizeInBytes() {
        return this.maxCacheMessageSizeInBytes;
    }

    public void setMaxCacheMessageSizeInBytes(int maxCacheMessageSizeInBytes) {
        this.maxCacheMessageSizeInBytes = maxCacheMessageSizeInBytes;
    }

    public int getConsumptionThreadCount() {
        return this.consumptionThreadCount;
    }

    public void setConsumptionThreadCount(int consumptionThreadCount) {
        this.consumptionThreadCount = consumptionThreadCount;
    }

    public RocketMQListener getMessageListener() {
        return this.rocketMQListener;
    }

    public void setMessageListener(RocketMQListener rocketMQListener) {
        this.rocketMQListener = rocketMQListener;
    }

    public RocketMQMessageListener getRocketMQMessageListener() {
        return this.rocketMQMessageListener;
    }

    public void setRocketMQMessageListener(RocketMQMessageListener rocketMQMessageListener) {
        this.rocketMQMessageListener = rocketMQMessageListener;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    private void initRocketMQPushConsumer() {
        if (this.rocketMQMessageListener == null) {
            throw new IllegalArgumentException("Property 'rocketMQMessageListener' is required");
        }
        Assert.notNull((Object)this.consumerGroup, (String)"Property 'consumerGroup' is required");
        Assert.notNull((Object)this.topic, (String)"Property 'topic' is required");
        Assert.notNull((Object)this.tag, (String)"Property 'tag' is required");
        FilterExpression filterExpression = null;
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        if (StringUtils.hasLength((String)this.getTag())) {
            filterExpression = RocketMQUtil.createFilterExpression(this.getTag(), this.getType());
        }
        ClientConfiguration clientConfiguration = RocketMQUtil.createClientConfiguration(this.getAccessKey(), this.getSecretKey(), this.getEndpoints(), this.getRequestTimeout(), this.sslEnabled, this.namespace);
        PushConsumerBuilder pushConsumerBuilder = provider.newPushConsumerBuilder().setClientConfiguration(clientConfiguration);
        if (StringUtils.hasLength((String)this.getConsumerGroup())) {
            pushConsumerBuilder.setConsumerGroup(this.getConsumerGroup());
        }
        if (StringUtils.hasLength((String)this.getTopic()) && Objects.nonNull(filterExpression)) {
            pushConsumerBuilder.setSubscriptionExpressions(Collections.singletonMap(this.getTopic(), filterExpression));
        }
        pushConsumerBuilder.setConsumptionThreadCount(this.getConsumptionThreadCount()).setMaxCacheMessageSizeInBytes(this.getMaxCacheMessageSizeInBytes()).setMaxCacheMessageCount(this.getMaxCachedMessageCount()).setMessageListener((MessageListener)this.rocketMQListener);
        this.setPushConsumerBuilder(pushConsumerBuilder);
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void destroy() throws Exception {
        this.setRunning(false);
        if (Objects.nonNull(this.pushConsumer)) {
            this.pushConsumer.close();
        }
        log.info("container destroyed, {}", (Object)this.toString());
    }

    public void stop() {
        if (this.isRunning()) {
            if (Objects.nonNull(this.pushConsumer)) {
                try {
                    this.pushConsumer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.setRunning(false);
        }
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("container already running. " + this.name);
        }
        if (Objects.nonNull(this.pushConsumer)) {
            throw new IllegalStateException("consumer has been build. " + this.name);
        }
        try {
            this.pushConsumer = this.pushConsumerBuilder.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to start RocketMQ push consumer", e);
        }
        this.setRunning(true);
        log.info("running container: {}", (Object)this.toString());
    }

    public void afterPropertiesSet() throws Exception {
        this.initRocketMQPushConsumer();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String toString() {
        return "DefaultListenerContainer{name='" + this.name + '\'' + ", running=" + this.running + ", accessKey='" + this.accessKey + '\'' + ", secretKey='" + this.secretKey + '\'' + ", endpoints='" + this.endpoints + '\'' + ", consumerGroup='" + this.consumerGroup + '\'' + ", tag='" + this.tag + '\'' + ", topic='" + this.topic + '\'' + ", type='" + this.type + '\'' + ", filterExpressionType=" + this.filterExpressionType + ", requestTimeout=" + this.requestTimeout + ", maxCachedMessageCount=" + this.maxCachedMessageCount + ", maxCacheMessageSizeInBytes=" + this.maxCacheMessageSizeInBytes + ", consumptionThreadCount=" + this.consumptionThreadCount + ", namespace='" + this.namespace + '\'' + '}';
    }
}

