/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.core;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumer;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumerBuilder;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.ProducerBuilder;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.apache.rocketmq.client.apis.producer.Transaction;
import org.apache.rocketmq.client.common.Pair;
import org.apache.rocketmq.client.support.RocketMQMessageConverter;
import org.apache.rocketmq.client.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.support.MessageBuilder;

public class RocketMQClientTemplate
extends AbstractMessageSendingTemplate<String>
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RocketMQClientTemplate.class);
    private ProducerBuilder producerBuilder;
    private SimpleConsumerBuilder simpleConsumerBuilder;
    private volatile Producer producer;
    private volatile SimpleConsumer simpleConsumer;
    private RocketMQMessageConverter rocketMQMessageConverter = new RocketMQMessageConverter();
    private String charset = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Producer getProducer() {
        if (!Objects.isNull(this.producer)) return this.producer;
        Class<RocketMQClientTemplate> clazz = RocketMQClientTemplate.class;
        synchronized (RocketMQClientTemplate.class) {
            if (!Objects.isNull(this.producer)) return this.producer;
            try {
                this.producer = this.producerBuilder.build();
            }
            catch (ClientException e) {
                throw new RuntimeException(e);
            }
            return this.producer;
        }
    }

    public void setProducer(Producer producer) {
        this.producer = producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleConsumer getSimpleConsumer() {
        if (!Objects.isNull(this.simpleConsumer)) return this.simpleConsumer;
        Class<RocketMQClientTemplate> clazz = RocketMQClientTemplate.class;
        synchronized (RocketMQClientTemplate.class) {
            if (!Objects.isNull(this.simpleConsumer)) return this.simpleConsumer;
            try {
                this.simpleConsumer = this.simpleConsumerBuilder.build();
            }
            catch (ClientException e) {
                throw new RuntimeException(e);
            }
            return this.simpleConsumer;
        }
    }

    public void setSimpleConsumer(SimpleConsumer simpleConsumer) {
        this.simpleConsumer = simpleConsumer;
    }

    public ProducerBuilder getProducerBuilder() {
        return this.producerBuilder;
    }

    public void setProducerBuilder(ProducerBuilder producerBuilder) {
        this.producerBuilder = producerBuilder;
    }

    public SimpleConsumerBuilder getSimpleConsumerBuilder() {
        return this.simpleConsumerBuilder;
    }

    public void setSimpleConsumerBuilder(SimpleConsumerBuilder simpleConsumerBuilder) {
        this.simpleConsumerBuilder = simpleConsumerBuilder;
    }

    public RocketMQMessageConverter getRocketMQMessageConverter() {
        return this.rocketMQMessageConverter;
    }

    public void setRocketMQMessageConverter(RocketMQMessageConverter rocketMQMessageConverter) {
        this.rocketMQMessageConverter = rocketMQMessageConverter;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void destroy() throws Exception {
        if (Objects.nonNull(this.producer)) {
            this.producer.close();
        }
        if (Objects.nonNull(this.simpleConsumer)) {
            this.simpleConsumer.close();
        }
    }

    protected void doSend(String destination, org.springframework.messaging.Message<?> message) {
        SendReceipt sendReceipt = this.syncSendGrpcMessage(destination, message, null, null);
        if (log.isDebugEnabled()) {
            log.debug("send message to `{}` finished. result:{}", (Object)destination, (Object)sendReceipt);
        }
    }

    public SendReceipt syncSendDelayMessage(String destination, Object payload, Duration messageDelayTime) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.syncSendGrpcMessage(destination, message, messageDelayTime, null);
    }

    public SendReceipt syncSendDelayMessage(String destination, String payload, Duration messageDelayTime) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.syncSendGrpcMessage(destination, message, messageDelayTime, null);
    }

    public SendReceipt syncSendDelayMessage(String destination, byte[] payload, Duration messageDelayTime) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.syncSendGrpcMessage(destination, message, messageDelayTime, null);
    }

    public SendReceipt syncSendDelayMessage(String destination, org.springframework.messaging.Message<?> message, Duration messageDelayTime) {
        return this.syncSendGrpcMessage(destination, message, messageDelayTime, null);
    }

    public SendReceipt syncSendFifoMessage(String destination, Object payload, String messageGroup) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.syncSendGrpcMessage(destination, message, null, messageGroup);
    }

    public SendReceipt syncSendFifoMessage(String destination, String payload, String messageGroup) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.syncSendGrpcMessage(destination, message, null, messageGroup);
    }

    public SendReceipt syncSendFifoMessage(String destination, byte[] payload, String messageGroup) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.syncSendGrpcMessage(destination, message, null, messageGroup);
    }

    public SendReceipt syncSendFifoMessage(String destination, org.springframework.messaging.Message<?> message, String messageGroup) {
        return this.syncSendGrpcMessage(destination, message, null, messageGroup);
    }

    public SendReceipt syncSendNormalMessage(String destination, Object payload) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.syncSendGrpcMessage(destination, message, null, null);
    }

    public SendReceipt syncSendNormalMessage(String destination, String payload) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.syncSendGrpcMessage(destination, message, null, null);
    }

    public SendReceipt syncSendNormalMessage(String destination, org.springframework.messaging.Message<?> message) {
        return this.syncSendGrpcMessage(destination, message, null, null);
    }

    public SendReceipt syncSendNormalMessage(String destination, byte[] payload) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.syncSendGrpcMessage(destination, message, null, null);
    }

    public SendReceipt syncSendGrpcMessage(String destination, org.springframework.messaging.Message<?> message, Duration messageDelayTime, String messageGroup) {
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        Object sendReceipt = null;
        try {
            Message rocketMsg = this.createRocketMQMessage(destination, message, messageDelayTime, messageGroup);
            Producer grpcProducer = this.getProducer();
            return grpcProducer.send(rocketMsg);
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
    }

    public CompletableFuture<SendReceipt> asyncSendWithObjectPayload(String destination, Object payload, Duration messageDelayTime, String messageGroup, CompletableFuture<SendReceipt> future) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.asyncSend(destination, message, messageDelayTime, messageGroup, future);
    }

    public CompletableFuture<SendReceipt> asyncSendWithStringPayload(String destination, String payload, Duration messageDelayTime, String messageGroup, CompletableFuture<SendReceipt> future) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.asyncSend(destination, message, messageDelayTime, messageGroup, future);
    }

    public CompletableFuture<SendReceipt> asyncSendWithBytePayload(String destination, byte[] payload, Duration messageDelayTime, String messageGroup, CompletableFuture<SendReceipt> future) {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.asyncSend(destination, message, messageDelayTime, messageGroup, future);
    }

    public CompletableFuture<SendReceipt> asyncSendWithMessagePayload(String destination, org.springframework.messaging.Message<?> payload, Duration messageDelayTime, String messageGroup, CompletableFuture<SendReceipt> future) {
        return this.asyncSend(destination, payload, messageDelayTime, messageGroup, future);
    }

    public CompletableFuture<SendReceipt> asyncSendNormalMessage(String destination, Object payload, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithObjectPayload(destination, payload, null, null, future);
    }

    public CompletableFuture<SendReceipt> asyncSendNormalMessage(String destination, String payload, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithStringPayload(destination, payload, null, null, future);
    }

    public CompletableFuture<SendReceipt> asyncSendNormalMessage(String destination, byte[] payload, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithBytePayload(destination, payload, null, null, future);
    }

    public CompletableFuture<SendReceipt> asyncSendNormalMessage(String destination, org.springframework.messaging.Message<?> payload, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithMessagePayload(destination, payload, null, null, future);
    }

    public CompletableFuture<SendReceipt> asyncSendFifoMessage(String destination, Object payload, String messageGroup, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithObjectPayload(destination, payload, null, messageGroup, future);
    }

    public CompletableFuture<SendReceipt> asyncSendFifoMessage(String destination, String payload, String messageGroup, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithStringPayload(destination, payload, null, messageGroup, future);
    }

    public CompletableFuture<SendReceipt> asyncSendFifoMessage(String destination, byte[] payload, String messageGroup, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithBytePayload(destination, payload, null, messageGroup, future);
    }

    public CompletableFuture<SendReceipt> asyncSendFifoMessage(String destination, org.springframework.messaging.Message<?> payload, String messageGroup, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithMessagePayload(destination, payload, null, messageGroup, future);
    }

    public CompletableFuture<SendReceipt> asyncSendDelayMessage(String destination, Object payload, Duration messageDelayTime, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithObjectPayload(destination, payload, messageDelayTime, null, future);
    }

    public CompletableFuture<SendReceipt> asyncSendDelayMessage(String destination, String payload, Duration messageDelayTime, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithStringPayload(destination, payload, messageDelayTime, null, future);
    }

    public CompletableFuture<SendReceipt> asyncSendDelayMessage(String destination, byte[] payload, Duration messageDelayTime, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithBytePayload(destination, payload, messageDelayTime, null, future);
    }

    public CompletableFuture<SendReceipt> asyncSendDelayMessage(String destination, org.springframework.messaging.Message<?> payload, Duration messageDelayTime, CompletableFuture<SendReceipt> future) {
        return this.asyncSendWithMessagePayload(destination, payload, messageDelayTime, null, future);
    }

    public CompletableFuture<SendReceipt> asyncSend(String destination, org.springframework.messaging.Message<?> message, Duration messageDelayTime, String messageGroup, CompletableFuture<SendReceipt> future) {
        CompletableFuture future0;
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        Producer grpcProducer = this.getProducer();
        try {
            Message rocketMsg = this.createRocketMQMessage(destination, message, messageDelayTime, messageGroup);
            future0 = grpcProducer.sendAsync(rocketMsg);
            if (null != future) {
                future0.whenComplete((sendReceipt, throwable) -> {
                    if (null != throwable) {
                        future.completeExceptionally((Throwable)throwable);
                    } else {
                        future.complete((SendReceipt)sendReceipt);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), (Throwable)e);
        }
        return future0;
    }

    public Pair<SendReceipt, Transaction> sendMessageInTransaction(String destination, Object payload) throws ClientException {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.sendTransactionMessage(destination, message);
    }

    public Pair<SendReceipt, Transaction> sendMessageInTransaction(String destination, String payload) throws ClientException {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.sendTransactionMessage(destination, message);
    }

    public Pair<SendReceipt, Transaction> sendMessageInTransaction(String destination, byte[] payload) throws ClientException {
        org.springframework.messaging.Message message = MessageBuilder.withPayload((Object)payload).build();
        return this.sendTransactionMessage(destination, message);
    }

    public Pair<SendReceipt, Transaction> sendTransactionMessage(String destination, org.springframework.messaging.Message<?> message) {
        SendReceipt sendReceipt;
        Transaction transaction;
        if (Objects.isNull(message) || Objects.isNull(message.getPayload())) {
            throw new IllegalArgumentException("`message` and `message.payload` cannot be null");
        }
        Producer grpcProducer = this.getProducer();
        Message rocketMsg = this.createRocketMQMessage(destination, message, null, null);
        try {
            transaction = grpcProducer.beginTransaction();
            sendReceipt = grpcProducer.send(rocketMsg, transaction);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return new Pair<SendReceipt, Transaction>(sendReceipt, transaction);
    }

    public List<MessageView> receive(int maxMessageNum, Duration invisibleDuration) throws ClientException {
        SimpleConsumer simpleConsumer = this.getSimpleConsumer();
        return simpleConsumer.receive(maxMessageNum, invisibleDuration);
    }

    public CompletableFuture<List<MessageView>> receiveAsync(int maxMessageNum, Duration invisibleDuration) throws ClientException, IOException {
        SimpleConsumer simpleConsumer = this.getSimpleConsumer();
        CompletableFuture listCompletableFuture = simpleConsumer.receiveAsync(maxMessageNum, invisibleDuration);
        simpleConsumer.close();
        return listCompletableFuture;
    }

    public void ack(MessageView message) throws ClientException {
        SimpleConsumer simpleConsumer = this.getSimpleConsumer();
        simpleConsumer.ack(message);
    }

    public CompletableFuture<Void> ackAsync(MessageView messageView) {
        SimpleConsumer simpleConsumer = this.getSimpleConsumer();
        return simpleConsumer.ackAsync(messageView);
    }

    private Message createRocketMQMessage(String destination, org.springframework.messaging.Message<?> message, Duration messageDelayTime, String messageGroup) {
        org.springframework.messaging.Message msg = this.doConvert(message.getPayload(), (Map)message.getHeaders(), null);
        return RocketMQUtil.convertToClientMessage(this.getMessageConverter(), this.charset, destination, msg, messageDelayTime, messageGroup);
    }
}

