/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.autoconfigure;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.annotation.RocketMQTransactionListener;
import org.apache.rocketmq.client.apis.producer.TransactionChecker;
import org.apache.rocketmq.client.core.RocketMQClientTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RocketMQTransactionConfiguration
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(RocketMQTransactionConfiguration.class);
    private ConfigurableApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterSingletonsInstantiated() {
        Map<String, Object> beans = this.applicationContext.getBeansWithAnnotation(RocketMQTransactionListener.class).entrySet().stream().filter(entry -> !ScopedProxyUtils.isScopedTarget((String)((String)entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        beans.forEach(this::handleTransactionChecker);
    }

    public void handleTransactionChecker(String beanName, Object bean) {
        Class clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!TransactionChecker.class.isAssignableFrom(bean.getClass())) {
            throw new IllegalStateException(clazz + " is not instance of " + TransactionChecker.class.getName());
        }
        RocketMQTransactionListener annotation = clazz.getAnnotation(RocketMQTransactionListener.class);
        if (Objects.isNull(annotation)) {
            throw new IllegalStateException("The transactionListener annotation is missing");
        }
        RocketMQClientTemplate rocketMQTemplate = (RocketMQClientTemplate)((Object)this.applicationContext.getBean(annotation.rocketMQTemplateBeanName()));
        if (rocketMQTemplate.getProducerBuilder() != null) {
            rocketMQTemplate.getProducerBuilder().setTransactionChecker((TransactionChecker)bean);
        }
    }
}

