/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.autoconfigure;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumerBuilder;
import org.apache.rocketmq.client.apis.producer.ProducerBuilder;
import org.apache.rocketmq.client.autoconfigure.ExtConsumerResetConfiguration;
import org.apache.rocketmq.client.autoconfigure.ExtTemplateResetConfiguration;
import org.apache.rocketmq.client.autoconfigure.ListenerContainerConfiguration;
import org.apache.rocketmq.client.autoconfigure.MessageConverterConfiguration;
import org.apache.rocketmq.client.autoconfigure.RocketMQListenerConfiguration;
import org.apache.rocketmq.client.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.client.autoconfigure.RocketMQTransactionConfiguration;
import org.apache.rocketmq.client.core.RocketMQClientTemplate;
import org.apache.rocketmq.client.java.impl.producer.ProducerBuilderImpl;
import org.apache.rocketmq.client.support.RocketMQMessageConverter;
import org.apache.rocketmq.client.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={RocketMQProperties.class})
@Import(value={MessageConverterConfiguration.class, ListenerContainerConfiguration.class, ExtTemplateResetConfiguration.class, ExtConsumerResetConfiguration.class, RocketMQTransactionConfiguration.class, RocketMQListenerConfiguration.class})
@AutoConfigureAfter(value={MessageConverterConfiguration.class})
@AutoConfigureBefore(value={RocketMQTransactionConfiguration.class})
public class RocketMQAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RocketMQAutoConfiguration.class);
    public static final String ROCKETMQ_TEMPLATE_DEFAULT_GLOBAL_NAME = "rocketMQClientTemplate";
    public static final String PRODUCER_BUILDER_BEAN_NAME = "producerBuilder";
    public static final String SIMPLE_CONSUMER_BUILDER_BEAN_NAME = "simpleConsumerBuilder";
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean(value={"producerBuilder"})
    @ConditionalOnMissingBean(value={ProducerBuilderImpl.class})
    @ConditionalOnProperty(prefix="rocketmq", value={"producer.endpoints"})
    public ProducerBuilder producerBuilder(RocketMQProperties rocketMQProperties) {
        RocketMQProperties.Producer rocketMQProducer = rocketMQProperties.getProducer();
        log.info("Init Producer Args: " + rocketMQProducer);
        String topic = rocketMQProducer.getTopic();
        String endPoints = rocketMQProducer.getEndpoints();
        Assert.hasText((String)endPoints, (String)"[rocketmq.producer.endpoints] must not be null");
        ClientConfiguration clientConfiguration = RocketMQUtil.createProducerClientConfiguration(rocketMQProducer);
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        ProducerBuilder producerBuilder = provider.newProducerBuilder().setClientConfiguration(clientConfiguration).setMaxAttempts(rocketMQProducer.getMaxAttempts());
        if (StringUtils.hasLength((String)topic)) {
            producerBuilder.setTopics(new String[]{rocketMQProducer.getTopic()});
        }
        log.info(String.format("a producer init on proxy %s", endPoints));
        return producerBuilder;
    }

    @Bean(value={"simpleConsumerBuilder"})
    @ConditionalOnMissingBean(value={SimpleConsumerBuilder.class})
    @ConditionalOnProperty(prefix="rocketmq", value={"simple-consumer.endpoints"})
    public SimpleConsumerBuilder simpleConsumerBuilder(RocketMQProperties rocketMQProperties) {
        RocketMQProperties.SimpleConsumer simpleConsumer = rocketMQProperties.getSimpleConsumer();
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        String consumerGroup = simpleConsumer.getConsumerGroup();
        FilterExpression filterExpression = RocketMQUtil.createFilterExpression(simpleConsumer.getTag(), simpleConsumer.getFilterExpressionType());
        ClientConfiguration clientConfiguration = RocketMQUtil.createConsumerClientConfiguration(simpleConsumer);
        SimpleConsumerBuilder simpleConsumerBuilder = provider.newSimpleConsumerBuilder().setClientConfiguration(clientConfiguration);
        simpleConsumerBuilder.setAwaitDuration(Duration.ofSeconds(simpleConsumer.getAwaitDuration()));
        if (StringUtils.hasLength((String)consumerGroup)) {
            simpleConsumerBuilder.setConsumerGroup(consumerGroup);
        }
        if (Objects.nonNull(filterExpression)) {
            simpleConsumerBuilder.setSubscriptionExpressions(Collections.singletonMap(simpleConsumer.getTopic(), filterExpression));
        }
        return simpleConsumerBuilder;
    }

    @Bean(destroyMethod="destroy")
    @Conditional(value={ProducerOrConsumerPropertyCondition.class})
    @ConditionalOnMissingBean(name={"rocketMQClientTemplate"})
    public RocketMQClientTemplate rocketMQClientTemplate(RocketMQMessageConverter rocketMQMessageConverter) {
        RocketMQClientTemplate rocketMQClientTemplate = new RocketMQClientTemplate();
        if (this.applicationContext.containsBean(PRODUCER_BUILDER_BEAN_NAME)) {
            rocketMQClientTemplate.setProducerBuilder((ProducerBuilder)this.applicationContext.getBean(PRODUCER_BUILDER_BEAN_NAME));
        }
        if (this.applicationContext.containsBean(SIMPLE_CONSUMER_BUILDER_BEAN_NAME)) {
            rocketMQClientTemplate.setSimpleConsumerBuilder((SimpleConsumerBuilder)this.applicationContext.getBean(SIMPLE_CONSUMER_BUILDER_BEAN_NAME));
        }
        rocketMQClientTemplate.setMessageConverter(rocketMQMessageConverter.getMessageConverter());
        return rocketMQClientTemplate;
    }

    static class ProducerOrConsumerPropertyCondition
    extends AnyNestedCondition {
        public ProducerOrConsumerPropertyCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={SimpleConsumerBuilder.class})
        static class SimpleConsumerExistsCondition {
            SimpleConsumerExistsCondition() {
            }
        }

        @ConditionalOnBean(value={ProducerBuilder.class})
        static class DefaultMQProducerExistsCondition {
            DefaultMQProducerExistsCondition() {
            }
        }
    }
}

