/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.autoconfigure;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.client.annotation.RocketMQMessageListener;
import org.apache.rocketmq.client.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.client.core.RocketMQListener;
import org.apache.rocketmq.client.support.DefaultListenerContainer;
import org.apache.rocketmq.client.support.RocketMQMessageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;

@Configuration
public class ListenerContainerConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ListenerContainerConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    private AtomicLong counter = new AtomicLong(0L);
    private ConfigurableEnvironment environment;
    private RocketMQProperties rocketMQProperties;
    private RocketMQMessageConverter rocketMQMessageConverter;
    private final List<DefaultListenerContainer> containers = new ArrayList<DefaultListenerContainer>();

    public ListenerContainerConfiguration(RocketMQMessageConverter rocketMQMessageConverter, ConfigurableEnvironment environment, RocketMQProperties rocketMQProperties) {
        this.rocketMQMessageConverter = rocketMQMessageConverter;
        this.environment = environment;
        this.rocketMQProperties = rocketMQProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void registerContainer(String beanName, Object bean, RocketMQMessageListener annotation) {
        this.validate(annotation);
        String containerBeanName = String.format("%s_%s", DefaultListenerContainer.class.getName(), this.counter.incrementAndGet());
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)this.applicationContext;
        genericApplicationContext.registerBean(containerBeanName, DefaultListenerContainer.class, () -> this.createRocketMQListenerContainer(containerBeanName, bean, annotation), new BeanDefinitionCustomizer[0]);
        DefaultListenerContainer container = (DefaultListenerContainer)genericApplicationContext.getBean(containerBeanName, DefaultListenerContainer.class);
        this.containers.add(container);
        log.info("Register the listener to container, listenerBeanName:{}, containerBeanName:{}", (Object)beanName, (Object)containerBeanName);
    }

    public void startContainer() {
        for (DefaultListenerContainer container : this.containers) {
            if (container.isRunning()) continue;
            try {
                container.start();
            }
            catch (Exception e) {
                log.error("Started container failed. {}", (Object)container, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private DefaultListenerContainer createRocketMQListenerContainer(String name, Object bean, RocketMQMessageListener annotation) {
        DefaultListenerContainer container = new DefaultListenerContainer();
        container.setName(name);
        container.setRocketMQMessageListener(annotation);
        container.setMessageListener((RocketMQListener)bean);
        container.setAccessKey(this.environment.resolvePlaceholders(annotation.accessKey()));
        container.setSecretKey(this.environment.resolvePlaceholders(annotation.secretKey()));
        container.setConsumerGroup(this.environment.resolvePlaceholders(annotation.consumerGroup()));
        container.setTag(this.environment.resolvePlaceholders(annotation.tag()));
        container.setEndpoints(this.environment.resolvePlaceholders(annotation.endpoints()));
        container.setTopic(this.environment.resolvePlaceholders(annotation.topic()));
        container.setNamespace(this.environment.resolvePlaceholders(annotation.namespace()));
        container.setRequestTimeout(Duration.ofSeconds(annotation.requestTimeout()));
        container.setMaxCachedMessageCount(annotation.maxCachedMessageCount());
        container.setConsumptionThreadCount(annotation.consumptionThreadCount());
        container.setMaxCacheMessageSizeInBytes(annotation.maxCacheMessageSizeInBytes());
        container.setType(annotation.filterExpressionType());
        return container;
    }

    private void validate(RocketMQMessageListener annotation) {
        Assert.hasText((String)annotation.accessKey(), (String)"[accessKey] must not be null");
        Assert.hasText((String)annotation.secretKey(), (String)"[secretKey] must not be null");
        Assert.hasText((String)annotation.topic(), (String)"[topic] must not be null");
        Assert.hasText((String)annotation.endpoints(), (String)"[endpoints] must not be null");
    }
}

