/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.autoconfigure;

import java.time.Duration;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.annotation.ExtProducerResetConfiguration;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.producer.ProducerBuilder;
import org.apache.rocketmq.client.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.client.core.RocketMQClientTemplate;
import org.apache.rocketmq.client.support.RocketMQMessageConverter;
import org.apache.rocketmq.client.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

@Configuration
public class ExtTemplateResetConfiguration
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(ExtTemplateResetConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    private ConfigurableEnvironment environment;
    private RocketMQProperties rocketMQProperties;
    private RocketMQMessageConverter rocketMQMessageConverter;

    public ExtTemplateResetConfiguration(RocketMQMessageConverter rocketMQMessageConverter, ConfigurableEnvironment environment, RocketMQProperties rocketMQProperties) {
        this.rocketMQMessageConverter = rocketMQMessageConverter;
        this.environment = environment;
        this.rocketMQProperties = rocketMQProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterSingletonsInstantiated() {
        Map<String, Object> beans = this.applicationContext.getBeansWithAnnotation(ExtProducerResetConfiguration.class).entrySet().stream().filter(entry -> !ScopedProxyUtils.isScopedTarget((String)((String)entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        beans.forEach(this::registerTemplate);
    }

    private void registerTemplate(String beanName, Object bean) {
        Class clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!RocketMQClientTemplate.class.isAssignableFrom(bean.getClass())) {
            throw new IllegalStateException(clazz + " is not instance of " + RocketMQClientTemplate.class.getName());
        }
        ExtProducerResetConfiguration annotation = clazz.getAnnotation(ExtProducerResetConfiguration.class);
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)this.applicationContext;
        this.validate(annotation, genericApplicationContext);
        ProducerBuilder producerBuilder = this.createProducer(annotation);
        RocketMQClientTemplate rocketMQTemplate = (RocketMQClientTemplate)((Object)bean);
        rocketMQTemplate.setProducerBuilder(producerBuilder);
        rocketMQTemplate.setMessageConverter(this.rocketMQMessageConverter.getMessageConverter());
        String topic = this.environment.resolvePlaceholders(annotation.topic());
        log.info("Set real producer to {} using topic {}", (Object)beanName, (Object)topic);
    }

    private ProducerBuilder createProducer(ExtProducerResetConfiguration annotation) {
        String topic;
        RocketMQProperties.Producer producerConfig = this.rocketMQProperties.getProducer();
        if (producerConfig == null) {
            producerConfig = new RocketMQProperties.Producer();
        }
        topic = StringUtils.hasLength((String)(topic = this.environment.resolvePlaceholders(annotation.topic()))) ? topic : producerConfig.getTopic();
        String endpoints = this.environment.resolvePlaceholders(annotation.endpoints());
        endpoints = StringUtils.hasLength((String)endpoints) ? endpoints : producerConfig.getEndpoints();
        String accessKey = this.environment.resolvePlaceholders(annotation.accessKey());
        accessKey = StringUtils.hasLength((String)accessKey) ? accessKey : producerConfig.getAccessKey();
        String secretKey = this.environment.resolvePlaceholders(annotation.secretKey());
        secretKey = StringUtils.hasLength((String)secretKey) ? secretKey : producerConfig.getSecretKey();
        String namespace = this.environment.resolvePlaceholders(annotation.namespace());
        namespace = StringUtils.hasLength((String)namespace) ? namespace : producerConfig.getNamespace();
        int requestTimeout = annotation.requestTimeout();
        Boolean sslEnabled = producerConfig.isSslEnabled();
        ClientConfiguration clientConfiguration = RocketMQUtil.createClientConfiguration(accessKey, secretKey, endpoints, Duration.ofSeconds(requestTimeout), sslEnabled, namespace);
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        ProducerBuilder producerBuilder = provider.newProducerBuilder().setClientConfiguration(clientConfiguration).setMaxAttempts(annotation.maxAttempts()).setTopics(new String[]{topic});
        return producerBuilder;
    }

    private void validate(ExtProducerResetConfiguration annotation, GenericApplicationContext genericApplicationContext) {
        if (genericApplicationContext.isBeanNameInUse(annotation.value())) {
            throw new BeanDefinitionValidationException(String.format("Bean {} has been used in Spring Application Context, please check the @ExtTemplateConfiguration", annotation.value()));
        }
    }
}

