/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.autoconfigure;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumer;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumerBuilder;
import org.apache.rocketmq.client.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.client.core.RocketMQClientTemplate;
import org.apache.rocketmq.client.support.RocketMQMessageConverter;
import org.apache.rocketmq.client.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
public class ExtConsumerResetConfiguration
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(ExtConsumerResetConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    private ConfigurableEnvironment environment;
    private RocketMQProperties rocketMQProperties;
    private RocketMQMessageConverter rocketMQMessageConverter;

    public ExtConsumerResetConfiguration(RocketMQMessageConverter rocketMQMessageConverter, ConfigurableEnvironment environment, RocketMQProperties rocketMQProperties) {
        this.rocketMQMessageConverter = rocketMQMessageConverter;
        this.environment = environment;
        this.rocketMQProperties = rocketMQProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterSingletonsInstantiated() {
        Map<String, Object> beans = this.applicationContext.getBeansWithAnnotation(org.apache.rocketmq.client.annotation.ExtConsumerResetConfiguration.class).entrySet().stream().filter(entry -> !ScopedProxyUtils.isScopedTarget((String)((String)entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        beans.forEach(this::registerTemplate);
    }

    private void registerTemplate(String beanName, Object bean) {
        Class clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!RocketMQClientTemplate.class.isAssignableFrom(bean.getClass())) {
            throw new IllegalStateException(clazz + " is not instance of " + RocketMQClientTemplate.class.getName());
        }
        org.apache.rocketmq.client.annotation.ExtConsumerResetConfiguration annotation = clazz.getAnnotation(org.apache.rocketmq.client.annotation.ExtConsumerResetConfiguration.class);
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)this.applicationContext;
        this.validate(annotation, genericApplicationContext);
        SimpleConsumerBuilder consumerBuilder = null;
        SimpleConsumer simpleConsumer = null;
        SimpleConsumerInfo simpleConsumerInfo = null;
        try {
            ClientServiceProvider provider = ClientServiceProvider.loadService();
            SimpleConsumerBuilder simpleConsumerBuilder = provider.newSimpleConsumerBuilder();
            simpleConsumerInfo = this.createConsumer(annotation, simpleConsumerBuilder);
        }
        catch (Exception e) {
            log.error("Failed to startup SimpleConsumer for RocketMQTemplate {}", (Object)beanName, (Object)e);
        }
        RocketMQClientTemplate rocketMQTemplate = (RocketMQClientTemplate)((Object)bean);
        rocketMQTemplate.setSimpleConsumerBuilder(consumerBuilder);
        rocketMQTemplate.setSimpleConsumer(simpleConsumer);
        rocketMQTemplate.setMessageConverter(this.rocketMQMessageConverter.getMessageConverter());
        log.info("Set real simpleConsumer {} to {}", (Object)simpleConsumerInfo, (Object)beanName);
    }

    private SimpleConsumerInfo createConsumer(org.apache.rocketmq.client.annotation.ExtConsumerResetConfiguration annotation, SimpleConsumerBuilder simpleConsumerBuilder) {
        RocketMQProperties.SimpleConsumer simpleConsumer = this.rocketMQProperties.getSimpleConsumer();
        String consumerGroupName = this.resolvePlaceholders(annotation.consumerGroup(), simpleConsumer.getConsumerGroup());
        String topicName = this.resolvePlaceholders(annotation.topic(), simpleConsumer.getTopic());
        String accessKey = this.resolvePlaceholders(annotation.accessKey(), simpleConsumer.getAccessKey());
        String secretKey = this.resolvePlaceholders(annotation.secretKey(), simpleConsumer.getSecretKey());
        String endPoints = this.resolvePlaceholders(annotation.endpoints(), simpleConsumer.getEndpoints());
        String namespace = this.resolvePlaceholders(annotation.namespace(), simpleConsumer.getNamespace());
        String tag = this.resolvePlaceholders(annotation.tag(), simpleConsumer.getTag());
        String filterExpressionType = this.resolvePlaceholders(annotation.filterExpressionType(), simpleConsumer.getFilterExpressionType());
        Duration requestTimeout = Duration.ofSeconds(annotation.requestTimeout());
        int awaitDuration = annotation.awaitDuration();
        Boolean sslEnabled = simpleConsumer.isSslEnabled();
        Assert.hasText((String)topicName, (String)"[topic] must not be null");
        ClientConfiguration clientConfiguration = RocketMQUtil.createClientConfiguration(accessKey, secretKey, endPoints, requestTimeout, sslEnabled, namespace);
        FilterExpression filterExpression = RocketMQUtil.createFilterExpression(tag, filterExpressionType);
        Duration duration = Duration.ofSeconds(awaitDuration);
        simpleConsumerBuilder.setClientConfiguration(clientConfiguration);
        if (StringUtils.hasLength((String)consumerGroupName)) {
            simpleConsumerBuilder.setConsumerGroup(consumerGroupName);
        }
        simpleConsumerBuilder.setAwaitDuration(duration);
        if (Objects.nonNull(filterExpression)) {
            simpleConsumerBuilder.setSubscriptionExpressions(Collections.singletonMap(topicName, filterExpression));
        }
        return new SimpleConsumerInfo(consumerGroupName, topicName, endPoints, namespace, tag, filterExpressionType, requestTimeout, awaitDuration, sslEnabled);
    }

    private String resolvePlaceholders(String text, String defaultValue) {
        String value = this.environment.resolvePlaceholders(text);
        return StringUtils.hasLength((String)value) ? value : defaultValue;
    }

    private void validate(org.apache.rocketmq.client.annotation.ExtConsumerResetConfiguration annotation, GenericApplicationContext genericApplicationContext) {
        if (genericApplicationContext.isBeanNameInUse(annotation.value())) {
            throw new BeanDefinitionValidationException(String.format("Bean {} has been used in Spring Application Context, please check the @ExtRocketMQConsumerConfiguration", annotation.value()));
        }
    }

    static class SimpleConsumerInfo {
        String consumerGroup;
        String topicName;
        String endPoints;
        String namespace;
        String tag;
        String filterExpressionType;
        Duration requestTimeout;
        int awaitDuration;
        Boolean sslEnabled;

        public SimpleConsumerInfo(String consumerGroupName, String topicName, String endPoints, String namespace, String tag, String filterExpressionType, Duration requestTimeout, int awaitDuration, Boolean sslEnabled) {
            this.consumerGroup = consumerGroupName;
            this.topicName = topicName;
            this.endPoints = endPoints;
            this.namespace = namespace;
            this.tag = tag;
            this.filterExpressionType = filterExpressionType;
            this.requestTimeout = requestTimeout;
            this.awaitDuration = awaitDuration;
            this.sslEnabled = sslEnabled;
        }

        public String toString() {
            return "SimpleConsumerInfo{consumerGroup='" + this.consumerGroup + '\'' + ", topicName='" + this.topicName + '\'' + ", endPoints='" + this.endPoints + '\'' + ", namespace='" + this.namespace + '\'' + ", tag='" + this.tag + '\'' + ", filterExpressionType='" + this.filterExpressionType + '\'' + ", requestTimeout(seconds)=" + this.requestTimeout.getSeconds() + ", awaitDuration=" + this.awaitDuration + ", sslEnabled=" + this.sslEnabled + '}';
        }
    }
}

