/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.annotation.RocketMQMessageListener;
import org.apache.rocketmq.client.autoconfigure.ListenerContainerConfiguration;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationUtils;

public class RocketMQMessageListenerBeanPostProcessor
implements ApplicationContextAware,
BeanPostProcessor,
InitializingBean,
SmartLifecycle {
    private ApplicationContext applicationContext;
    private AnnotationEnhancer enhancer;
    private ListenerContainerConfiguration listenerContainerConfiguration;
    private boolean running = false;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        RocketMQMessageListener ann = targetClass.getAnnotation(RocketMQMessageListener.class);
        if (ann != null) {
            RocketMQMessageListener enhance = this.enhance(targetClass, ann);
            if (this.listenerContainerConfiguration != null) {
                this.listenerContainerConfiguration.registerContainer(beanName, bean, enhance);
            }
        }
        return bean;
    }

    public int getPhase() {
        return 2147481647;
    }

    public void start() {
        if (!this.isRunning()) {
            this.setRunning(true);
            this.listenerContainerConfiguration.startContainer();
        }
    }

    public void stop() {
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.buildEnhancer();
        this.listenerContainerConfiguration = (ListenerContainerConfiguration)this.applicationContext.getBean(ListenerContainerConfiguration.class);
    }

    private void buildEnhancer() {
        Map enhancersMap;
        if (this.applicationContext != null && (enhancersMap = this.applicationContext.getBeansOfType(AnnotationEnhancer.class, false, false)).size() > 0) {
            List enhancers = enhancersMap.values().stream().sorted(new OrderComparator()).collect(Collectors.toList());
            this.enhancer = (attrs, element) -> {
                Map newAttrs = attrs;
                for (AnnotationEnhancer enh : enhancers) {
                    newAttrs = (Map)enh.apply(newAttrs, element);
                }
                return attrs;
            };
        }
    }

    private RocketMQMessageListener enhance(AnnotatedElement element, RocketMQMessageListener ann) {
        if (this.enhancer == null) {
            return ann;
        }
        return (RocketMQMessageListener)AnnotationUtils.synthesizeAnnotation((Map)((Map)this.enhancer.apply(AnnotationUtils.getAnnotationAttributes((Annotation)ann), element)), RocketMQMessageListener.class, null);
    }

    public static interface AnnotationEnhancer
    extends BiFunction<Map<String, Object>, AnnotatedElement, Map<String, Object>> {
    }
}

