/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rocketmq;

import java.util.Map;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.rocketmq.AvailableOffsetRange;
import org.apache.spark.sql.rocketmq.CachedRocketMQConsumer;
import org.apache.spark.sql.rocketmq.CachedRocketMQConsumer$;
import org.apache.spark.sql.rocketmq.RocketMQOffsetRangeLimit$;
import org.apache.spark.sql.rocketmq.RocketMQSource$;
import org.apache.spark.sql.rocketmq.RocketMQSourceRDDOffsetRange;
import org.apache.spark.sql.rocketmq.RocketMQSourceRDDPartition;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.NextIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd!B\u0001\u0003\u0001\ta!!\u0005*pG.,G/T)T_V\u00148-\u001a*E\t*\u00111\u0001B\u0001\te>\u001c7.\u001a;nc*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0005\u0001i\u0001c\u0001\b\u0012'5\tqB\u0003\u0002\u0011\r\u0005\u0019!\u000f\u001a3\n\u0005Iy!a\u0001*E\tB\u0011ACG\u0007\u0002+)\u0011acF\u0001\b[\u0016\u001c8/Y4f\u0015\tA\u0012$\u0001\u0004d_6lwN\u001c\u0006\u0003\u0007!I!aG\u000b\u0003\u00155+7o]1hK\u0016CH\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003 \u0003\t\u00198m\u0001\u0001\u0011\u0005\u0001\nS\"\u0001\u0004\n\u0005\t2!\u0001D*qCJ\\7i\u001c8uKb$\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002-\u0015DXmY;u_J\u0014vnY6fi6\u000b\u0006+\u0019:b[N\u0004BAJ\u0016.[5\tqE\u0003\u0002)S\u0005!Q\u000f^5m\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\u00075\u000b\u0007\u000f\u0005\u0002/i9\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019\u0004\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u00031ygMZ:fiJ\u000bgnZ3t!\rQ$)\u0012\b\u0003w\u0001s!\u0001P \u000e\u0003uR!A\u0010\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014BA!1\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0011#\u0003\u0007M+\u0017O\u0003\u0002BaA\u0011aiR\u0007\u0002\u0005%\u0011\u0001J\u0001\u0002\u001d%>\u001c7.\u001a;N#N{WO]2f%\u0012#uJ\u001a4tKR\u0014\u0016M\\4f\u0011!Q\u0005A!A!\u0002\u0013Y\u0015!\u00049pY2$\u0016.\\3pkRl5\u000f\u0005\u00020\u0019&\u0011Q\n\r\u0002\u0005\u0019>tw\r\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u000391\u0017-\u001b7P]\u0012\u000bG/\u0019'pgN\u0004\"aL)\n\u0005I\u0003$a\u0002\"p_2,\u0017M\u001c\u0005\t)\u0002\u0011\t\u0011)A\u0005!\u0006)\"/Z;tKJ{7m[3u\u001bF\u001buN\\:v[\u0016\u0014\b\"\u0002,\u0001\t\u00039\u0016A\u0002\u001fj]&$h\bF\u0004Y3j[F,\u00180\u0011\u0005\u0019\u0003\u0001\"B\u000fV\u0001\u0004y\u0002\"\u0002\u0013V\u0001\u0004)\u0003\"\u0002\u001dV\u0001\u0004I\u0004\"\u0002&V\u0001\u0004Y\u0005\"B(V\u0001\u0004\u0001\u0006\"\u0002+V\u0001\u0004\u0001\u0006\"\u00021\u0001\t\u0003\n\u0017a\u00029feNL7\u000f\u001e\u000b\u0003E\u000el\u0011\u0001\u0001\u0005\u0006I~\u0003\r!Z\u0001\t]\u0016<H*\u001a<fYB\u0011a-[\u0007\u0002O*\u0011\u0001NB\u0001\bgR|'/Y4f\u0013\tQwM\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eC\u0003m\u0001\u0011\u0005S.A\u0007hKR\u0004\u0016M\u001d;ji&|gn]\u000b\u0002]B\u0019qf\\9\n\u0005A\u0004$!B!se\u0006L\bC\u0001\u0011s\u0013\t\u0019hAA\u0005QCJ$\u0018\u000e^5p]\")Q\u000f\u0001C!m\u0006)1m\\;oiR\t1\nC\u0003y\u0001\u0011\u0005\u00130A\u0006d_VtG/\u00119qe>DH#\u0002>\u0002\b\u0005-\u0001\u0003B>\u007f\u0003\u0003i\u0011\u0001 \u0006\u0003{\u001a\tq\u0001]1si&\fG.\u0003\u0002\u0000y\ni\u0001+\u0019:uS\u0006d'+Z:vYR\u00042a_A\u0002\u0013\r\t)\u0001 \u0002\u000e\u0005>,h\u000eZ3e\t>,(\r\\3\t\r\u0005%q\u000f1\u0001L\u0003\u001d!\u0018.\\3pkRD\u0011\"!\u0004x!\u0003\u0005\r!a\u0004\u0002\u0015\r|gNZ5eK:\u001cW\rE\u00020\u0003#I1!a\u00051\u0005\u0019!u.\u001e2mK\"9\u0011q\u0003\u0001\u0005B\u0005e\u0011aB5t\u000b6\u0004H/\u001f\u000b\u0002!\"9\u0011Q\u0004\u0001\u0005B\u0005}\u0011\u0001\u0002;bW\u0016$B!!\t\u0002$A\u0019qf\\\n\t\u0011\u0005\u0015\u00121\u0004a\u0001\u0003O\t1A\\;n!\ry\u0013\u0011F\u0005\u0004\u0003W\u0001$aA%oi\"9\u0011q\u0006\u0001\u0005B\u0005E\u0012!F4fiB\u0013XMZ3se\u0016$Gj\\2bi&|gn\u001d\u000b\u0005\u0003g\t)\u0004E\u0002;\u00056Bq!a\u000e\u0002.\u0001\u0007\u0011/A\u0003ta2LG\u000fC\u0004\u0002<\u0001!\t%!\u0010\u0002\u000f\r|W\u000e];uKR1\u0011qHA#\u0003\u0013\u0002BAOA!'%\u0019\u00111\t#\u0003\u0011%#XM]1u_JDq!a\u0012\u0002:\u0001\u0007\u0011/A\u0004uQ\u0016\u0004\u0016M\u001d;\t\u0011\u0005-\u0013\u0011\ba\u0001\u0003\u001b\nqaY8oi\u0016DH\u000fE\u0002!\u0003\u001fJ1!!\u0015\u0007\u0005-!\u0016m]6D_:$X\r\u001f;\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X\u0005a!/Z:pYZ,'+\u00198hKR)Q)!\u0017\u0002d!A\u00111LA*\u0001\u0004\ti&\u0001\u0005d_:\u001cX/\\3s!\r1\u0015qL\u0005\u0004\u0003C\u0012!AF\"bG\",GMU8dW\u0016$X*U\"p]N,X.\u001a:\t\u000f\u0005\u0015\u00141\u000ba\u0001\u000b\u0006)!/\u00198hK\u0002")
public class RocketMQSourceRDD
extends RDD<MessageExt> {
    public final Map<String, String> org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$executorRocketMQParams;
    private final Seq<RocketMQSourceRDDOffsetRange> offsetRanges;
    public final long org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$pollTimeoutMs;
    public final boolean org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$failOnDataLoss;
    public final boolean org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$reuseRocketMQConsumer;

    public RocketMQSourceRDD persist(StorageLevel newLevel) {
        this.logError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "RocketMQ ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window";
            }
        });
        return (RocketMQSourceRDD)super.persist(newLevel);
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.offsetRanges.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RocketMQSourceRDDPartition apply(Tuple2<RocketMQSourceRDDOffsetRange, Object> x0$1) {
                Tuple2<RocketMQSourceRDDOffsetRange, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    RocketMQSourceRDDOffsetRange o = (RocketMQSourceRDDOffsetRange)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    RocketMQSourceRDDPartition rocketMQSourceRDDPartition = new RocketMQSourceRDDPartition(i, o);
                    return rocketMQSourceRDDPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public long count() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.offsetRanges.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RocketMQSourceRDDOffsetRange x$1) {
                return x$1.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public PartialResult<BoundedDouble> countApprox(long timeout, double confidence) {
        long c = this.count();
        return new PartialResult((Object)new BoundedDouble((double)c, 1.0, (double)c, (double)c), true);
    }

    public boolean isEmpty() {
        return this.count() == 0L;
    }

    public MessageExt[] take(int num) {
        RocketMQSourceRDDPartition[] nonEmptyPartitions = (RocketMQSourceRDDPartition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.partitions()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RocketMQSourceRDDPartition apply(Partition x$2) {
                return (RocketMQSourceRDDPartition)x$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RocketMQSourceRDDPartition.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RocketMQSourceRDDPartition x$3) {
                return x$3.offsetRange().size() > 0L;
            }
        });
        if (num < 1 || Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).isEmpty()) {
            return new MessageExt[0];
        }
        scala.collection.immutable.Map parts = (scala.collection.immutable.Map)Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2)new Serializable(this, num){
            public static final long serialVersionUID = 0L;
            private final int num$1;

            public final scala.collection.immutable.Map<Object, Object> apply(scala.collection.immutable.Map<Object, Object> result, RocketMQSourceRDDPartition part) {
                scala.collection.immutable.Map map;
                int remain = this.num$1 - BoxesRunTime.unboxToInt((Object)result.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if (remain > 0) {
                    long taken = Math.min((long)remain, part.offsetRange().size());
                    map = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)part.index())), (Object)BoxesRunTime.boxToInteger((int)((int)taken))));
                } else {
                    map = result;
                }
                return map;
            }
            {
                this.num$1 = num$1;
            }
        });
        ArrayBuffer buf = new ArrayBuffer();
        MessageExt[][] res = (MessageExt[][])this.context().runJob((RDD)this, (Function2)new Serializable(this, parts){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map parts$1;

            public final MessageExt[] apply(TaskContext tc, Iterator<MessageExt> it) {
                return (MessageExt[])it.take(BoxesRunTime.unboxToInt((Object)this.parts$1.apply((Object)BoxesRunTime.boxToInteger((int)tc.partitionId())))).toArray(ClassTag$.MODULE$.apply(MessageExt.class));
            }
            {
                this.parts$1 = parts$1;
            }
        }, (Seq)Predef$.MODULE$.wrapIntArray((int[])parts.keys().toArray(ClassTag$.MODULE$.Int())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(MessageExt.class)));
        Predef$.MODULE$.refArrayOps((Object[])res).foreach((Function1)new Serializable(this, buf){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer buf$1;

            public final ArrayBuffer<MessageExt> apply(MessageExt[] x$4) {
                return this.buf$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])x$4));
            }
            {
                this.buf$1 = buf$1;
            }
        });
        return (MessageExt[])buf.toArray(ClassTag$.MODULE$.apply(MessageExt.class));
    }

    public Seq<String> getPreferredLocations(Partition split) {
        RocketMQSourceRDDPartition part = (RocketMQSourceRDDPartition)split;
        return (Seq)part.offsetRange().preferredLoc().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$5) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$5}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Iterator<MessageExt> compute(Partition thePart, TaskContext context) {
        Object object;
        RocketMQSourceRDDPartition sourcePartition = (RocketMQSourceRDDPartition)thePart;
        CachedRocketMQConsumer consumer = this.org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$reuseRocketMQConsumer ? CachedRocketMQConsumer$.MODULE$.createUncached(sourcePartition.offsetRange().messageQueue(), this.org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$executorRocketMQParams) : CachedRocketMQConsumer$.MODULE$.getOrCreate(sourcePartition.offsetRange().messageQueue(), this.org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$executorRocketMQParams);
        RocketMQSourceRDDOffsetRange range = this.resolveRange(consumer, sourcePartition.offsetRange());
        Predef$.MODULE$.assert(range.fromOffset() <= range.untilOffset(), (Function0)new Serializable(this, range){
            public static final long serialVersionUID = 0L;
            private final RocketMQSourceRDDOffsetRange range$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is after the ending offset ", " for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$1.fromOffset()), BoxesRunTime.boxToLong((long)this.range$1.untilOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". You either provided an invalid fromOffset, or the RocketMQ topic has been damaged"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.messageQueue()}))).toString();
            }
            {
                this.range$1 = range$1;
            }
        });
        if (range.fromOffset() == range.untilOffset()) {
            this.logInfo((Function0)new Serializable(this, range){
                public static final long serialVersionUID = 0L;
                private final RocketMQSourceRDDOffsetRange range$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is the same as ending offset, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$1.fromOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"skipping ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.messageQueue()}))).toString();
                }
                {
                    this.range$1 = range$1;
                }
            });
            object = package$.MODULE$.Iterator().empty();
        } else {
            NextIterator<MessageExt> underlying = new NextIterator<MessageExt>(this, sourcePartition, consumer, range){
                private long requestOffset;
                private final /* synthetic */ RocketMQSourceRDD $outer;
                private final RocketMQSourceRDDPartition sourcePartition$1;
                private final CachedRocketMQConsumer consumer$1;
                private final RocketMQSourceRDDOffsetRange range$1;

                private long requestOffset() {
                    return this.requestOffset;
                }

                private void requestOffset_$eq(long x$1) {
                    this.requestOffset = x$1;
                }

                public MessageExt getNext() {
                    MessageExt messageExt;
                    if (this.requestOffset() >= this.range$1.untilOffset()) {
                        this.finished_$eq(true);
                        messageExt = null;
                    } else {
                        MessageExt r = this.consumer$1.get(this.requestOffset(), this.range$1.untilOffset(), this.$outer.org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$pollTimeoutMs, this.$outer.org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$failOnDataLoss);
                        if (r == null) {
                            this.finished_$eq(true);
                            messageExt = null;
                        } else {
                            this.requestOffset_$eq(r.getQueueOffset() + 1L);
                            r.putUserProperty(RocketMQSource$.MODULE$.PROP_BROKER_NAME(), this.sourcePartition$1.offsetRange().messageQueue().getBrokerName());
                            messageExt = r;
                        }
                    }
                    return messageExt;
                }

                public void close() {
                    if (this.$outer.org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$reuseRocketMQConsumer) {
                        CachedRocketMQConsumer$.MODULE$.releaseConsumer(this.sourcePartition$1.offsetRange().messageQueue(), this.$outer.org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$executorRocketMQParams);
                    } else {
                        this.consumer$1.close();
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sourcePartition$1 = sourcePartition$1;
                    this.consumer$1 = consumer$1;
                    this.range$1 = range$1;
                    this.requestOffset = range$1.fromOffset();
                }
            };
            context.addTaskCompletionListener((Function1)new Serializable(this, (NextIterator)underlying){
                public static final long serialVersionUID = 0L;
                private final NextIterator underlying$1;

                public final void apply(TaskContext x$6) {
                    this.underlying$1.closeIfNeeded();
                }
                {
                    this.underlying$1 = underlying$1;
                }
            });
            object = underlying;
        }
        return object;
    }

    private RocketMQSourceRDDOffsetRange resolveRange(CachedRocketMQConsumer consumer, RocketMQSourceRDDOffsetRange range) {
        RocketMQSourceRDDOffsetRange rocketMQSourceRDDOffsetRange;
        if (range.fromOffset() < 0L || range.untilOffset() < 0L) {
            long l;
            long fromOffset;
            long l2;
            AvailableOffsetRange availableOffsetRange = consumer.getAvailableOffsetRange();
            if (range.fromOffset() < 0L) {
                Predef$.MODULE$.assert(range.fromOffset() == RocketMQOffsetRangeLimit$.MODULE$.EARLIEST(), (Function0)new Serializable(this, range){
                    public static final long serialVersionUID = 0L;
                    private final RocketMQSourceRDDOffsetRange range$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"earliest offset ", " does not equal ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$2.fromOffset()), BoxesRunTime.boxToLong((long)RocketMQOffsetRangeLimit$.MODULE$.EARLIEST())}));
                    }
                    {
                        this.range$2 = range$2;
                    }
                });
                l2 = availableOffsetRange.earliest();
            } else {
                l2 = fromOffset = range.fromOffset();
            }
            if (range.untilOffset() < 0L) {
                Predef$.MODULE$.assert(range.untilOffset() == RocketMQOffsetRangeLimit$.MODULE$.LATEST(), (Function0)new Serializable(this, range){
                    public static final long serialVersionUID = 0L;
                    private final RocketMQSourceRDDOffsetRange range$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"latest offset ", " does not equal ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$2.untilOffset()), BoxesRunTime.boxToLong((long)RocketMQOffsetRangeLimit$.MODULE$.LATEST())}));
                    }
                    {
                        this.range$2 = range$2;
                    }
                });
                l = availableOffsetRange.latest();
            } else {
                l = range.untilOffset();
            }
            long untilOffset = l;
            rocketMQSourceRDDOffsetRange = new RocketMQSourceRDDOffsetRange(range.messageQueue(), fromOffset, untilOffset, range.preferredLoc());
        } else {
            rocketMQSourceRDDOffsetRange = range;
        }
        return rocketMQSourceRDDOffsetRange;
    }

    public RocketMQSourceRDD(SparkContext sc, Map<String, String> executorRocketMQParams, Seq<RocketMQSourceRDDOffsetRange> offsetRanges, long pollTimeoutMs, boolean failOnDataLoss2, boolean reuseRocketMQConsumer) {
        this.org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$executorRocketMQParams = executorRocketMQParams;
        this.offsetRanges = offsetRanges;
        this.org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$pollTimeoutMs = pollTimeoutMs;
        this.org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$failOnDataLoss = failOnDataLoss2;
        this.org$apache$spark$sql$rocketmq$RocketMQSourceRDD$$reuseRocketMQConsumer = reuseRocketMQConsumer;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(MessageExt.class));
    }
}

