/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rocketmq;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.rocketmq.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.rocketmq.LatestOffsetRangeLimit$;
import org.apache.spark.sql.rocketmq.RocketMQConf$;
import org.apache.spark.sql.rocketmq.RocketMQOffsetRangeLimit;
import org.apache.spark.sql.rocketmq.RocketMQOffsetRangeLimit$;
import org.apache.spark.sql.rocketmq.RocketMQOffsetReader;
import org.apache.spark.sql.rocketmq.RocketMQRelation;
import org.apache.spark.sql.rocketmq.RocketMQSink;
import org.apache.spark.sql.rocketmq.RocketMQSource;
import org.apache.spark.sql.rocketmq.RocketMQSource$;
import org.apache.spark.sql.rocketmq.RocketMQSourceProvider$;
import org.apache.spark.sql.rocketmq.RocketMQWriter$;
import org.apache.spark.sql.rocketmq.SpecificOffsetRangeLimit;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.StreamSinkProvider;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rEa\u0001B\u0001\u0003\u00015\u0011aCU8dW\u0016$X*U*pkJ\u001cW\r\u0015:pm&$WM\u001d\u0006\u0003\u0007\u0011\t\u0001B]8dW\u0016$X.\u001d\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\t\u00019!\"$\b\u0011$MA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000fM|WO]2fg&\u0011\u0011D\u0006\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002\u00167%\u0011AD\u0006\u0002\u0015'R\u0014X-Y7T_V\u00148-\u001a)s_ZLG-\u001a:\u0011\u0005Uq\u0012BA\u0010\u0017\u0005A\u0011V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002\u0016C%\u0011!E\u0006\u0002\u001a\u0007J,\u0017\r^1cY\u0016\u0014V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002\u0016I%\u0011QE\u0006\u0002\u0013'R\u0014X-Y7TS:\\\u0007K]8wS\u0012,'\u000f\u0005\u0002(U5\t\u0001F\u0003\u0002*\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002,Q\t9Aj\\4hS:<\u0007\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\bF\u00010!\t\u0001\u0004!D\u0001\u0003\u0011\u0015\u0011\u0004\u0001\"\u00114\u0003%\u0019\bn\u001c:u\u001d\u0006lW\rF\u00015!\t)\u0004H\u0004\u0002\u0010m%\u0011q\u0007E\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u00028!!)A\b\u0001C!{\u0005a1o\\;sG\u0016\u001c6\r[3nCR)ahR'S)B!qb\u0010\u001bB\u0013\t\u0001\u0005C\u0001\u0004UkBdWM\r\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u0012\tQ\u0001^=qKNL!AR\"\u0003\u0015M#(/^2u)f\u0004X\rC\u0003Iw\u0001\u0007\u0011*\u0001\u0006tc2\u001cuN\u001c;fqR\u0004\"AS&\u000e\u0003\u0011I!\u0001\u0014\u0003\u0003\u0015M\u000bFjQ8oi\u0016DH\u000fC\u0003Ow\u0001\u0007q*\u0001\u0004tG\",W.\u0019\t\u0004\u001fA\u000b\u0015BA)\u0011\u0005\u0019y\u0005\u000f^5p]\")1k\u000fa\u0001i\u0005a\u0001O]8wS\u0012,'OT1nK\")Qk\u000fa\u0001-\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\tU:F\u0007N\u0005\u00031j\u00121!T1q\u0011\u0015Q\u0006\u0001\"\u0011\\\u00031\u0019'/Z1uKN{WO]2f)\u0019aF-Z4iSB\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\ngR\u0014X-Y7j]\u001eT!!\u0019\u0003\u0002\u0013\u0015DXmY;uS>t\u0017BA2_\u0005\u0019\u0019v.\u001e:dK\")\u0001*\u0017a\u0001\u0013\")a-\u0017a\u0001i\u0005aQ.\u001a;bI\u0006$\u0018\rU1uQ\")a*\u0017a\u0001\u001f\")1+\u0017a\u0001i!)Q+\u0017a\u0001-\")1\u000e\u0001C!Y\u0006q1M]3bi\u0016\u0014V\r\\1uS>tGcA7qcB\u0011QC\\\u0005\u0003_Z\u0011ABQ1tKJ+G.\u0019;j_:DQ\u0001\u00136A\u0002%CQ!\u00166A\u0002YCQa\u001b\u0001\u0005BM$R!\u001c;vunDQ\u0001\u0013:A\u0002%CQA\u001e:A\u0002]\fA!\\8eKB\u0011!\n_\u0005\u0003s\u0012\u0011\u0001bU1wK6{G-\u001a\u0005\u0006+J\u0004\rA\u0016\u0005\u0006yJ\u0004\r!`\u0001\u0005I\u0006$\u0018\rE\u0002\u007f\u00033q1a`A\u000b\u001d\u0011\t\t!a\u0005\u000f\t\u0005\r\u0011\u0011\u0003\b\u0005\u0003\u000b\tyA\u0004\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tY\u0001D\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\r\t9\u0002B\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY\"!\b\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAA\f\t!9\u0011\u0011\u0005\u0001\u0005\n\u0005\r\u0012A\u00044bS2|e\u000eR1uC2{7o\u001d\u000b\u0005\u0003K\tY\u0003E\u0002\u0010\u0003OI1!!\u000b\u0011\u0005\u001d\u0011un\u001c7fC:Dq!!\f\u0002 \u0001\u0007a+A\u000bdCN,\u0017J\\:f]NLG/\u001b<f!\u0006\u0014\u0018-\\:\t\u000f\u0005E\u0002\u0001\"\u0003\u00024\u00051b/\u00197jI\u0006$XmR3oKJ\fGn\u00149uS>t7\u000f\u0006\u0003\u00026\u0005m\u0002cA\b\u00028%\u0019\u0011\u0011\b\t\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003[\ty\u00031\u0001W\u0011\u001d\ty\u0004\u0001C!\u0003\u0003\n!b\u0019:fCR,7+\u001b8l))\t\u0019%!\u0013\u0002L\u00055\u0013\u0011\r\t\u0004;\u0006\u0015\u0013bAA$=\n!1+\u001b8l\u0011\u0019A\u0015Q\ba\u0001\u0013\"1Q+!\u0010A\u0002YC\u0001\"a\u0014\u0002>\u0001\u0007\u0011\u0011K\u0001\u0011a\u0006\u0014H/\u001b;j_:\u001cu\u000e\\;n]N\u0004R!a\u0015\u0002\\QrA!!\u0016\u0002Z9!\u0011qAA,\u0013\u0005\t\u0012bAA\f!%!\u0011QLA0\u0005\r\u0019V-\u001d\u0006\u0004\u0003/\u0001\u0002\u0002CA2\u0003{\u0001\r!!\u001a\u0002\u0015=,H\u000f];u\u001b>$W\r\u0005\u0003\u0002h\u0005-TBAA5\u0015\tyF!\u0003\u0003\u0002n\u0005%$AC(viB,H/T8eK\"9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0014!\u0006<bY&$\u0017\r^3TiJ,\u0017-\\(qi&|gn\u001d\u000b\u0005\u0003k\t)\bC\u0004\u0002.\u0005=\u0004\u0019\u0001,\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|\u0005!b/\u00197jI\u0006$XMQ1uG\"|\u0005\u000f^5p]N$B!!\u000e\u0002~!9\u0011QFA<\u0001\u00041vaBAA\u0005!\u0005\u00111Q\u0001\u0017%>\u001c7.\u001a;N#N{WO]2f!J|g/\u001b3feB\u0019\u0001'!\"\u0007\r\u0005\u0011\u0001\u0012AAD'\u0011\t)I\u0004\u0014\t\u000f5\n)\t\"\u0001\u0002\fR\u0011\u00111\u0011\u0005\f\u0003\u001f\u000b)I1A\u0005\u0002\t\t\t*A\u000eT)\u0006\u0013F+\u0013(H?>3eiU#U'~{\u0005\u000bV%P\u001d~[U)W\u000b\u0003\u0003'\u0003B!!&\u0002 6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY*\u0001\u0003mC:<'BAAO\u0003\u0011Q\u0017M^1\n\u0007e\n9\nC\u0005\u0002$\u0006\u0015\u0005\u0015!\u0003\u0002\u0014\u0006a2\u000bV!S)&suiX(G\rN+EkU0P!RKuJT0L\u000bf\u0003\u0003bCAT\u0003\u000b\u0013\r\u0011\"\u0001\u0003\u0003#\u000b\u0011$\u0012(E\u0013:;ul\u0014$G'\u0016#6kX(Q)&{ejX&F3\"I\u00111VACA\u0003%\u00111S\u0001\u001b\u000b:#\u0015JT$`\u001f\u001a35+\u0012+T?>\u0003F+S(O?.+\u0015\f\t\u0005\f\u0003_\u000b)I1A\u0005\u0002\t\t\t*\u0001\u000fG\u0003&cul\u0014(`\t\u0006#\u0016i\u0018'P'N{v\n\u0015+J\u001f:{6*R-\t\u0013\u0005M\u0016Q\u0011Q\u0001\n\u0005M\u0015!\b$B\u00132{vJT0E\u0003R\u000bu\fT(T'~{\u0005\u000bV%P\u001d~[U)\u0017\u0011\t\u0011\u0005]\u0016Q\u0011C\u0001\u0003s\u000b1dZ3u%>\u001c7.\u001a;N#>3gm]3u%\u0006tw-\u001a'j[&$H\u0003CA^\u0003\u0003\f)-!3\u0011\u0007A\ni,C\u0002\u0002@\n\u0011\u0001DU8dW\u0016$X*U(gMN,GOU1oO\u0016d\u0015.\\5u\u0011\u001d\t\u0019-!.A\u0002Y\u000ba\u0001]1sC6\u001c\bbBAd\u0003k\u0003\r\u0001N\u0001\u0010_\u001a47/\u001a;PaRLwN\\&fs\"A\u00111ZA[\u0001\u0004\tY,\u0001\beK\u001a\fW\u000f\u001c;PM\u001a\u001cX\r^:\t\u0011\u0005=\u0017Q\u0011C\u0001\u0003#\fq\u0002]1sC6\u001chi\u001c:Ee&4XM\u001d\u000b\u0005\u0003'\fi\u000e\u0005\u0004\u0002V\u0006mG\u0007N\u0007\u0003\u0003/TA!!7\u0002\u001c\u0006!Q\u000f^5m\u0013\rA\u0016q\u001b\u0005\b\u0003?\fi\r1\u0001W\u0003]\u0019\b/Z2jM&,GMU8dW\u0016$X*\u0015)be\u0006l7\u000f\u0003\u0005\u0002d\u0006\u0015E\u0011AAs\u0003I\u0001\u0018M]1ng\u001a{'/\u0012=fGV$xN]:\u0015\r\u0005M\u0017q]Au\u0011\u001d\ty.!9A\u0002YCq!a;\u0002b\u0002\u0007A'A\u0007v]&\fX/Z$s_V\u0004\u0018\n\u001a\u0005\t\u0003_\f)\t\"\u0001\u0002r\u0006\t\u0002/\u0019:b[N4uN\u001d)s_\u0012,8-\u001a:\u0015\r\u0005M\u00171_A{\u0011\u001d\ty.!<A\u0002YCq!a;\u0002n\u0002\u0007AGB\u0004\u0002z\u0006\u0015E)a?\u0003\u001b\r{gNZ5h+B$\u0017\r^3s'\u001d\t9PDA\u007f\u0005\u0007\u00012aDA\u0000\u0013\r\u0011\t\u0001\u0005\u0002\b!J|G-^2u!\ry!QA\u0005\u0004\u0005\u000f\u0001\"\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0003B\u0006\u0003o\u0014)\u001a!C\u0001\u0005\u001b\ta!\\8ek2,W#\u0001\u001b\t\u0015\tE\u0011q\u001fB\tB\u0003%A'A\u0004n_\u0012,H.\u001a\u0011\t\u0017\u0005\r\u0017q\u001fBK\u0002\u0013\u0005!QC\u000b\u0002-\"Q!\u0011DA|\u0005#\u0005\u000b\u0011\u0002,\u0002\u000fA\f'/Y7tA!9Q&a>\u0005\u0002\tuAC\u0002B\u0010\u0005G\u0011)\u0003\u0005\u0003\u0003\"\u0005]XBAAC\u0011\u001d\u0011YAa\u0007A\u0002QBq!a1\u0003\u001c\u0001\u0007a\u000b\u0003\u0006\u0003*\u0005](\u0019!C\u0005\u0005W\t1!\\1q+\t\u0011i\u0003\u0005\u0004\u0002V\n=B\u0007N\u0005\u0005\u0005c\t9NA\u0004ICNDW*\u00199\t\u0013\tU\u0012q\u001fQ\u0001\n\t5\u0012\u0001B7ba\u0002B\u0001B!\u000f\u0002x\u0012\u0005!1H\u0001\u0004g\u0016$HC\u0002B\u001f\u0005\u007f\u0011\u0019%\u0004\u0002\u0002x\"9!\u0011\tB\u001c\u0001\u0004!\u0014aA6fs\"9!Q\tB\u001c\u0001\u0004!\u0014!\u0002<bYV,\u0007\u0002\u0003B%\u0003o$\tAa\u0013\u0002\u0015M,G/\u00134V]N,G\u000f\u0006\u0004\u0003 \t5#q\n\u0005\b\u0005\u0003\u00129\u00051\u00015\u0011\u001d\u0011)Ea\u0012A\u0002QB\u0001Ba\u0015\u0002x\u0012\u0005!QK\u0001\u0006EVLG\u000e\u001a\u000b\u0003\u0003'D!B!\u0017\u0002x\u0006\u0005I\u0011\u0001B.\u0003\u0011\u0019w\u000e]=\u0015\r\t}!Q\fB0\u0011%\u0011YAa\u0016\u0011\u0002\u0003\u0007A\u0007C\u0005\u0002D\n]\u0003\u0013!a\u0001-\"Q!1MA|#\u0003%\tA!\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\r\u0016\u0004i\t%4F\u0001B6!\u0011\u0011iGa\u001e\u000e\u0005\t=$\u0002\u0002B9\u0005g\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tU\u0004#\u0001\u0006b]:|G/\u0019;j_:LAA!\u001f\u0003p\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\tu\u0014q_I\u0001\n\u0003\u0011y(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0005%f\u0001,\u0003j!Q!QQA|\u0003\u0003%\t%!%\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u0011)\u0011I)a>\u0002\u0002\u0013\u0005!1R\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u001b\u00032a\u0004BH\u0013\r\u0011\t\n\u0005\u0002\u0004\u0013:$\bB\u0003BK\u0003o\f\t\u0011\"\u0001\u0003\u0018\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002BM\u0005?\u00032a\u0004BN\u0013\r\u0011i\n\u0005\u0002\u0004\u0003:L\bB\u0003BQ\u0005'\u000b\t\u00111\u0001\u0003\u000e\u0006\u0019\u0001\u0010J\u0019\t\u0015\t\u0015\u0016q_A\u0001\n\u0003\u00129+A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u000b\u0005\u0004\u0003,\nE&\u0011T\u0007\u0003\u0005[S1Aa,\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005g\u0013iK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u00119,a>\u0002\u0002\u0013\u0005!\u0011X\u0001\tG\u0006tW)];bYR!\u0011Q\u0005B^\u0011)\u0011\tK!.\u0002\u0002\u0003\u0007!\u0011\u0014\u0005\u000b\u0005\u007f\u000b90!A\u0005B\t\u0005\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t5\u0005B\u0003Bc\u0003o\f\t\u0011\"\u0011\u0003H\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0014\"Q!1ZA|\u0003\u0003%\tE!4\u0002\r\u0015\fX/\u00197t)\u0011\t)Ca4\t\u0015\t\u0005&\u0011ZA\u0001\u0002\u0004\u0011Ij\u0002\u0006\u0003T\u0006\u0015\u0015\u0011!E\u0005\u0005+\fQbQ8oM&<W\u000b\u001d3bi\u0016\u0014\b\u0003\u0002B\u0011\u0005/4!\"!?\u0002\u0006\u0006\u0005\t\u0012\u0002Bm'\u0019\u00119Na7\u0003\u0004AA!Q\u001cBriY\u0013y\"\u0004\u0002\u0003`*\u0019!\u0011\u001d\t\u0002\u000fI,h\u000e^5nK&!!Q\u001dBp\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b[\t]G\u0011\u0001Bu)\t\u0011)\u000e\u0003\u0006\u0003F\n]\u0017\u0011!C#\u0005\u000fD!Ba<\u0003X\u0006\u0005I\u0011\u0011By\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0011yBa=\u0003v\"9!1\u0002Bw\u0001\u0004!\u0004bBAb\u0005[\u0004\rA\u0016\u0005\u000b\u0005s\u00149.!A\u0005\u0002\nm\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0005{\u001c\t\u0001\u0005\u0003\u0010!\n}\b\u0003B\b@iYC!ba\u0001\u0003x\u0006\u0005\t\u0019\u0001B\u0010\u0003\rAH\u0005\r\u0005\u000b\u0007\u000f\u00119.!A\u0005\n\r%\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa\u0003\u0011\t\u0005U5QB\u0005\u0005\u0007\u001f\t9J\u0001\u0004PE*,7\r\u001e")
public class RocketMQSourceProvider
implements DataSourceRegister,
StreamSourceProvider,
RelationProvider,
CreatableRelationProvider,
StreamSinkProvider,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Map<String, String> paramsForProducer(scala.collection.immutable.Map<String, String> map, String string) {
        return RocketMQSourceProvider$.MODULE$.paramsForProducer(map, string);
    }

    public static Map<String, String> paramsForExecutors(scala.collection.immutable.Map<String, String> map, String string) {
        return RocketMQSourceProvider$.MODULE$.paramsForExecutors(map, string);
    }

    public static Map<String, String> paramsForDriver(scala.collection.immutable.Map<String, String> map) {
        return RocketMQSourceProvider$.MODULE$.paramsForDriver(map);
    }

    public static RocketMQOffsetRangeLimit getRocketMQOffsetRangeLimit(scala.collection.immutable.Map<String, String> map, String string, RocketMQOffsetRangeLimit rocketMQOffsetRangeLimit) {
        return RocketMQSourceProvider$.MODULE$.getRocketMQOffsetRangeLimit(map, string, rocketMQOffsetRangeLimit);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String shortName() {
        return "rocketmq";
    }

    public Tuple2<String, StructType> sourceSchema(SQLContext sqlContext, Option<StructType> schema, String providerName, scala.collection.immutable.Map<String, String> parameters) {
        this.validateStreamOptions(parameters);
        Predef$.MODULE$.require(schema.isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "RocketMQ source has a fixed schema and cannot be set with a custom one";
            }
        });
        return new Tuple2((Object)this.shortName(), (Object)RocketMQSource$.MODULE$.schema());
    }

    public Source createSource(SQLContext sqlContext, String metadataPath, Option<StructType> schema, String providerName, scala.collection.immutable.Map<String, String> parameters) {
        this.validateStreamOptions(parameters);
        String uniqueGroupId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-rocketmq-source-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID(), RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(metadataPath.hashCode()))}));
        scala.collection.immutable.Map caseInsensitiveParams = (scala.collection.immutable.Map)parameters.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)k.toLowerCase(Locale.ROOT), (Object)v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        RocketMQOffsetRangeLimit startingStreamOffsets = RocketMQSourceProvider$.MODULE$.getRocketMQOffsetRangeLimit((scala.collection.immutable.Map<String, String>)caseInsensitiveParams, RocketMQConf$.MODULE$.CONSUMER_OFFSET(), LatestOffsetRangeLimit$.MODULE$);
        RocketMQOffsetReader offsetReader = new RocketMQOffsetReader(RocketMQSourceProvider$.MODULE$.paramsForDriver((scala.collection.immutable.Map<String, String>)caseInsensitiveParams), parameters, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-driver"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uniqueGroupId})));
        return new RocketMQSource(sqlContext, offsetReader, RocketMQSourceProvider$.MODULE$.paramsForExecutors((scala.collection.immutable.Map<String, String>)caseInsensitiveParams, uniqueGroupId), parameters, metadataPath, startingStreamOffsets, this.failOnDataLoss((scala.collection.immutable.Map<String, String>)caseInsensitiveParams));
    }

    public BaseRelation createRelation(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters) {
        RocketMQOffsetRangeLimit endingRelationOffsets;
        RocketMQOffsetRangeLimit startingRelationOffsets;
        this.validateBatchOptions(parameters);
        scala.collection.immutable.Map caseInsensitiveParams = (scala.collection.immutable.Map)parameters.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)k.toLowerCase(Locale.ROOT), (Object)v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        RocketMQOffsetRangeLimit rocketMQOffsetRangeLimit = startingRelationOffsets = RocketMQSourceProvider$.MODULE$.getRocketMQOffsetRangeLimit((scala.collection.immutable.Map<String, String>)caseInsensitiveParams, RocketMQSourceProvider$.MODULE$.STARTING_OFFSETS_OPTION_KEY(), EarliestOffsetRangeLimit$.MODULE$);
        LatestOffsetRangeLimit$ latestOffsetRangeLimit$ = LatestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(rocketMQOffsetRangeLimit != null ? !rocketMQOffsetRangeLimit.equals(latestOffsetRangeLimit$) : latestOffsetRangeLimit$ != null);
        RocketMQOffsetRangeLimit rocketMQOffsetRangeLimit2 = endingRelationOffsets = RocketMQSourceProvider$.MODULE$.getRocketMQOffsetRangeLimit((scala.collection.immutable.Map<String, String>)caseInsensitiveParams, RocketMQSourceProvider$.MODULE$.ENDING_OFFSETS_OPTION_KEY(), LatestOffsetRangeLimit$.MODULE$);
        EarliestOffsetRangeLimit$ earliestOffsetRangeLimit$ = EarliestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(rocketMQOffsetRangeLimit2 != null ? !rocketMQOffsetRangeLimit2.equals(earliestOffsetRangeLimit$) : earliestOffsetRangeLimit$ != null);
        return new RocketMQRelation(sqlContext, parameters, (scala.collection.immutable.Map<String, String>)caseInsensitiveParams, this.failOnDataLoss((scala.collection.immutable.Map<String, String>)caseInsensitiveParams), startingRelationOffsets, endingRelationOffsets);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> data) {
        SaveMode saveMode = mode;
        boolean bl = SaveMode.Overwrite.equals(saveMode) ? true : SaveMode.Ignore.equals(saveMode);
        if (bl) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Save mode ", " not allowed for RocketMQ. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mode}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Allowed save modes are ", " and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SaveMode.Append}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (default)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SaveMode.ErrorIfExists}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        scala.collection.immutable.Map caseInsensitiveParams = (scala.collection.immutable.Map)parameters.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)k.toLowerCase(Locale.ROOT), (Object)v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        Option defaultTopic = parameters.get((Object)RocketMQConf$.MODULE$.PRODUCER_TOPIC()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.trim();
            }
        });
        String uniqueGroupId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-rocketmq-sink-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID()}));
        Map<String, String> specifiedKafkaParams = RocketMQSourceProvider$.MODULE$.paramsForProducer((scala.collection.immutable.Map<String, String>)caseInsensitiveParams, uniqueGroupId);
        RocketMQWriter$.MODULE$.write(sqlContext.sparkSession(), data.queryExecution(), specifiedKafkaParams, (Option<String>)defaultTopic);
        return new BaseRelation(this){

            public SQLContext sqlContext() {
                throw this.unsupportedException();
            }

            public StructType schema() {
                throw this.unsupportedException();
            }

            public boolean needConversion() {
                throw this.unsupportedException();
            }

            public long sizeInBytes() {
                throw this.unsupportedException();
            }

            public Filter[] unhandledFilters(Filter[] filters) {
                throw this.unsupportedException();
            }

            private Nothing$ unsupportedException() {
                throw new UnsupportedOperationException("BaseRelation from RocketMQ write operation is not usable.");
            }
        };
    }

    private boolean failOnDataLoss(scala.collection.immutable.Map<String, String> caseInsensitiveParams) {
        return new StringOps(Predef$.MODULE$.augmentString((String)caseInsensitiveParams.getOrElse((Object)RocketMQSourceProvider$.MODULE$.FAIL_ON_DATA_LOSS_OPTION_KEY(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "true";
            }
        }))).toBoolean();
    }

    private void validateGeneralOptions(scala.collection.immutable.Map<String, String> caseInsensitiveParams) {
        if (caseInsensitiveParams.contains((Object)RocketMQConf$.MODULE$.CONSUMER_TOPIC())) {
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option '", "' must be specified for RocketMQ source"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RocketMQConf$.MODULE$.CONSUMER_TOPIC()})));
    }

    public Sink createSink(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters, Seq<String> partitionColumns, OutputMode outputMode) {
        scala.collection.immutable.Map caseInsensitiveParams = (scala.collection.immutable.Map)parameters.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)k.toLowerCase(Locale.ROOT), (Object)v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        Option defaultTopic = parameters.get((Object)RocketMQConf$.MODULE$.PRODUCER_TOPIC()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$2) {
                return x$2.trim();
            }
        });
        String uniqueGroupId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-rocketmq-sink-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID()}));
        return new RocketMQSink(sqlContext, RocketMQSourceProvider$.MODULE$.paramsForProducer((scala.collection.immutable.Map<String, String>)caseInsensitiveParams, uniqueGroupId), (Option<String>)defaultTopic);
    }

    private void validateStreamOptions(scala.collection.immutable.Map<String, String> caseInsensitiveParams) {
        this.validateGeneralOptions(caseInsensitiveParams);
    }

    private void validateBatchOptions(scala.collection.immutable.Map<String, String> caseInsensitiveParams) {
        RocketMQOffsetRangeLimit rocketMQOffsetRangeLimit;
        block8: {
            RocketMQOffsetRangeLimit rocketMQOffsetRangeLimit2;
            block11: {
                block10: {
                    block9: {
                        block7: {
                            block6: {
                                rocketMQOffsetRangeLimit = RocketMQSourceProvider$.MODULE$.getRocketMQOffsetRangeLimit(caseInsensitiveParams, RocketMQSourceProvider$.MODULE$.STARTING_OFFSETS_OPTION_KEY(), EarliestOffsetRangeLimit$.MODULE$);
                                if (!EarliestOffsetRangeLimit$.MODULE$.equals(rocketMQOffsetRangeLimit)) break block6;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block7;
                            }
                            if (LatestOffsetRangeLimit$.MODULE$.equals(rocketMQOffsetRangeLimit)) {
                                throw new IllegalArgumentException("starting offset can't be latest for batch queries on RocketMQ");
                            }
                            if (!(rocketMQOffsetRangeLimit instanceof SpecificOffsetRangeLimit)) break block8;
                            SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)rocketMQOffsetRangeLimit;
                            scala.collection.immutable.Map<MessageQueue, Object> partitionOffsets2 = specificOffsetRangeLimit.partitionOffsets();
                            partitionOffsets2.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Tuple2<MessageQueue, Object> x0$5) {
                                    Tuple2<MessageQueue, Object> tuple2 = x0$5;
                                    if (tuple2 != null) {
                                        MessageQueue mq = (MessageQueue)tuple2._1();
                                        long off = tuple2._2$mcJ$sp();
                                        if (off == RocketMQOffsetRangeLimit$.MODULE$.LATEST()) {
                                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"starting offsets for ", " can't be latest for batch queries on RocketMQ"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mq})));
                                        }
                                    }
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        rocketMQOffsetRangeLimit2 = RocketMQSourceProvider$.MODULE$.getRocketMQOffsetRangeLimit(caseInsensitiveParams, RocketMQSourceProvider$.MODULE$.ENDING_OFFSETS_OPTION_KEY(), LatestOffsetRangeLimit$.MODULE$);
                        if (EarliestOffsetRangeLimit$.MODULE$.equals(rocketMQOffsetRangeLimit2)) {
                            throw new IllegalArgumentException("ending offset can't be earliest for batch queries on RocketMQ");
                        }
                        if (!LatestOffsetRangeLimit$.MODULE$.equals(rocketMQOffsetRangeLimit2)) break block9;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block10;
                    }
                    if (!(rocketMQOffsetRangeLimit2 instanceof SpecificOffsetRangeLimit)) break block11;
                    SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)rocketMQOffsetRangeLimit2;
                    scala.collection.immutable.Map<MessageQueue, Object> partitionOffsets3 = specificOffsetRangeLimit.partitionOffsets();
                    partitionOffsets3.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<MessageQueue, Object> x0$6) {
                            Tuple2<MessageQueue, Object> tuple2 = x0$6;
                            if (tuple2 != null) {
                                MessageQueue mq = (MessageQueue)tuple2._1();
                                long off = tuple2._2$mcJ$sp();
                                if (off == RocketMQOffsetRangeLimit$.MODULE$.EARLIEST()) {
                                    throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ending offset for ", " can't be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mq}))).append((Object)"earliest for batch queries on RocketMQ").toString());
                                }
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                this.validateGeneralOptions(caseInsensitiveParams);
                if (caseInsensitiveParams.get((Object)"maxoffsetspertrigger").isDefined()) {
                    this.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "maxOffsetsPerTrigger option ignored in batch queries";
                        }
                    });
                }
                return;
            }
            throw new MatchError((Object)rocketMQOffsetRangeLimit2);
        }
        throw new MatchError((Object)rocketMQOffsetRangeLimit);
    }

    public RocketMQSourceProvider() {
        Logging.class.$init$((Logging)this);
    }

    public static class ConfigUpdater
    implements Product,
    Serializable {
        private final String module;
        private final scala.collection.immutable.Map<String, String> params;
        private final HashMap<String, String> map;

        public String module() {
            return this.module;
        }

        public scala.collection.immutable.Map<String, String> params() {
            return this.params;
        }

        private HashMap<String, String> map() {
            return this.map;
        }

        public ConfigUpdater set(String key, String value) {
            this.map().put(key, value);
            RocketMQSourceProvider$.MODULE$.logDebug((Function0<String>)new Serializable(this, key, value){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConfigUpdater $outer;
                private final String key$1;
                private final String value$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Set ", " to ", ", earlier value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.module(), this.key$1, this.value$1, this.$outer.params().getOrElse((Object)this.key$1, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    })}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.key$1 = key$1;
                    this.value$1 = value$1;
                }
            });
            return this;
        }

        public ConfigUpdater setIfUnset(String key, String value) {
            if (!this.map().containsKey(key)) {
                this.map().put(key, value);
                RocketMQSourceProvider$.MODULE$.logDebug((Function0<String>)new Serializable(this, key, value){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ConfigUpdater $outer;
                    private final String key$2;
                    private final String value$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Set ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.module(), this.key$2, this.value$2}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.key$2 = key$2;
                        this.value$2 = value$2;
                    }
                });
            }
            return this;
        }

        public Map<String, String> build() {
            return this.map();
        }

        public ConfigUpdater copy(String module, scala.collection.immutable.Map<String, String> params) {
            return new ConfigUpdater(module, params);
        }

        public String copy$default$1() {
            return this.module();
        }

        public scala.collection.immutable.Map<String, String> copy$default$2() {
            return this.params();
        }

        public String productPrefix() {
            return "ConfigUpdater";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.params();
                    break;
                }
                case 0: {
                    object = this.module();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConfigUpdater;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConfigUpdater)) return false;
            boolean bl = true;
            if (!bl) return false;
            ConfigUpdater configUpdater = (ConfigUpdater)x$1;
            String string = this.module();
            String string2 = configUpdater.module();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            scala.collection.immutable.Map<String, String> map = this.params();
            scala.collection.immutable.Map<String, String> map2 = configUpdater.params();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!configUpdater.canEqual(this)) return false;
            return true;
        }

        public ConfigUpdater(String module, scala.collection.immutable.Map<String, String> params) {
            this.module = module;
            this.params = params;
            Product.class.$init$((Product)this);
            this.map = new HashMap((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(params).asJava());
        }
    }
}

