/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rocketmq;

import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;

public final class RocketMQSource$ {
    public static final RocketMQSource$ MODULE$;
    private final String INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE;
    private final String INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE;
    private final int VERSION;
    private final String PROP_BROKER_NAME;

    static {
        new RocketMQSource$();
    }

    public String INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE() {
        return this.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE;
    }

    public String INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE() {
        return this.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE;
    }

    public int VERSION() {
        return this.VERSION;
    }

    public String PROP_BROKER_NAME() {
        return this.PROP_BROKER_NAME;
    }

    public String[] getSortedExecutorList(SparkContext sc) {
        BlockManager bm = sc.env().blockManager();
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])bm.master().getPeers(bm.blockManagerId()).toArray(ClassTag$.MODULE$.apply(BlockManagerId.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ExecutorCacheTaskLocation apply(BlockManagerId x) {
                return new ExecutorCacheTaskLocation(x.host(), x.executorId());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExecutorCacheTaskLocation.class)))).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
                return RocketMQSource$.MODULE$.org$apache$spark$sql$rocketmq$RocketMQSource$$compare(a, b);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ExecutorCacheTaskLocation x$5) {
                return x$5.toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public boolean org$apache$spark$sql$rocketmq$RocketMQSource$$compare(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
        String string = a.host();
        String string2 = b.host();
        return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString(a.executorId())).$greater((Object)b.executorId()) : new StringOps(Predef$.MODULE$.augmentString(a.host())).$greater((Object)b.host());
    }

    public StructType schema() {
        return StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("topic", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("flag", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("body", (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("properties", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("brokerName", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("queueId", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("queueOffset", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("bornTimestamp", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("storeTimestamp", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
    }

    private RocketMQSource$() {
        MODULE$ = this;
        this.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE = new StringOps(Predef$.MODULE$.augmentString("\r\n      |Some data may have been lost because they are not available in RocketMQ any more; either the\r\n      | data was aged out by RocketMQ or the topic may have been deleted before all the data in the\r\n      | topic was processed. If you want your streaming query to fail on such cases, set the source\r\n      | option \"failOnDataLoss\" to \"true\".\r\n    ")).stripMargin();
        this.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE = new StringOps(Predef$.MODULE$.augmentString("\r\n      |Some data may have been lost because they are not available in RocketMQ any more; either the\r\n      | data was aged out by RocketMQ or the topic may have been deleted before all the data in the\r\n      | topic was processed. If you don't want your streaming query to fail on such cases, set the\r\n      | source option \"failOnDataLoss\" to \"false\".\r\n    ")).stripMargin();
        this.VERSION = 1;
        this.PROP_BROKER_NAME = "_brokerName";
    }
}

