/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rocketmq;

import java.util.Map;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.rocketmq.RocketMQWriter$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4Q!\u0001\u0002\u0001\u00051\u0011ABU8dW\u0016$X*U*j].T!a\u0001\u0003\u0002\u0011I|7m[3u[FT!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\u0011\u0001Q\"F\u000f\u0011\u00059\u0019R\"A\b\u000b\u0005A\t\u0012\u0001\u00027b]\u001eT\u0011AE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0015\u001f\t1qJ\u00196fGR\u0004\"AF\u000e\u000e\u0003]Q!\u0001G\r\u0002\u0013M$(/Z1nS:<'B\u0001\u000e\u0005\u0003%)\u00070Z2vi&|g.\u0003\u0002\u001d/\t!1+\u001b8l!\tq\u0012%D\u0001 \u0015\t\u0001c!\u0001\u0005j]R,'O\\1m\u0013\t\u0011sDA\u0004M_\u001e<\u0017N\\4\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0019\n!b]9m\u0007>tG/\u001a=u\u0007\u0001\u0001\"a\n\u0015\u000e\u0003\u0011I!!\u000b\u0003\u0003\u0015M\u000bFjQ8oi\u0016DH\u000f\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003Y)\u00070Z2vi>\u0014(k\\2lKRl\u0015\u000bU1sC6\u001c\b\u0003B\u00171eIj\u0011A\f\u0006\u0003_E\tA!\u001e;jY&\u0011\u0011G\f\u0002\u0004\u001b\u0006\u0004\bCA\u001a:\u001d\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a*\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002\u000bQ|\u0007/[2\u0011\u0007Qz$'\u0003\u0002Ak\t1q\n\u001d;j_:DQA\u0011\u0001\u0005\u0002\r\u000ba\u0001P5oSRtD\u0003\u0002#G\u000f\"\u0003\"!\u0012\u0001\u000e\u0003\tAQ\u0001J!A\u0002\u0019BQaK!A\u00021BQ!P!A\u0002yBqA\u0013\u0001A\u0002\u0013%1*A\u0007mCR,7\u000f\u001e\"bi\u000eD\u0017\nZ\u000b\u0002\u0019B\u0011A'T\u0005\u0003\u001dV\u0012A\u0001T8oO\"9\u0001\u000b\u0001a\u0001\n\u0013\t\u0016!\u00057bi\u0016\u001cHOQ1uG\"LEm\u0018\u0013fcR\u0011!+\u0016\t\u0003iMK!\u0001V\u001b\u0003\tUs\u0017\u000e\u001e\u0005\b->\u000b\t\u00111\u0001M\u0003\rAH%\r\u0005\u00071\u0002\u0001\u000b\u0015\u0002'\u0002\u001d1\fG/Z:u\u0005\u0006$8\r[%eA!\u0012qK\u0017\t\u0003imK!\u0001X\u001b\u0003\u0011Y|G.\u0019;jY\u0016DQA\u0018\u0001\u0005B}\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002e!)\u0011\r\u0001C!E\u0006A\u0011\r\u001a3CCR\u001c\u0007\u000eF\u0002SG\u0016DQ\u0001\u001a1A\u00021\u000bqAY1uG\"LE\rC\u0003gA\u0002\u0007q-\u0001\u0003eCR\f\u0007C\u00015w\u001d\tIGO\u0004\u0002kg:\u00111N\u001d\b\u0003YFt!!\u001c9\u000e\u00039T!a\\\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011Q\u000fB\u0001\ba\u0006\u001c7.Y4f\u0013\t9\bPA\u0005ECR\fgI]1nK*\u0011Q\u000f\u0002")
public class RocketMQSink
implements Sink,
Logging {
    private final SQLContext sqlContext;
    private final Map<String, String> executorRocketMQParams;
    private final Option<String> topic;
    private volatile long latestBatchId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private long latestBatchId() {
        return this.latestBatchId;
    }

    private void latestBatchId_$eq(long x$1) {
        this.latestBatchId = x$1;
    }

    public String toString() {
        return "RocketMQSink";
    }

    public void addBatch(long batchId, Dataset<Row> data) {
        if (batchId <= this.latestBatchId()) {
            this.logInfo((Function0<String>)new Serializable(this, batchId){
                public static final long serialVersionUID = 0L;
                private final long batchId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping already committed batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.batchId$1)}));
                }
                {
                    this.batchId$1 = batchId$1;
                }
            });
        } else {
            RocketMQWriter$.MODULE$.write(this.sqlContext.sparkSession(), data.queryExecution(), this.executorRocketMQParams, this.topic);
            this.latestBatchId_$eq(batchId);
        }
    }

    public RocketMQSink(SQLContext sqlContext, Map<String, String> executorRocketMQParams, Option<String> topic) {
        this.sqlContext = sqlContext;
        this.executorRocketMQParams = executorRocketMQParams;
        this.topic = topic;
        Logging.class.$init$((Logging)this);
        this.latestBatchId = -1L;
    }
}

