/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rocketmq;

import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.rocketmq.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.rocketmq.JsonUtils$;
import org.apache.spark.sql.rocketmq.LatestOffsetRangeLimit$;
import org.apache.spark.sql.rocketmq.RocketMQConf$;
import org.apache.spark.sql.rocketmq.RocketMQOffsetRangeLimit;
import org.apache.spark.sql.rocketmq.RocketMQOffsetRangeLimit$;
import org.apache.spark.sql.rocketmq.RocketMQOffsetReader;
import org.apache.spark.sql.rocketmq.RocketMQSource$;
import org.apache.spark.sql.rocketmq.RocketMQSourceProvider$;
import org.apache.spark.sql.rocketmq.RocketMQSourceRDD;
import org.apache.spark.sql.rocketmq.RocketMQSourceRDDOffsetRange;
import org.apache.spark.sql.rocketmq.SpecificOffsetRangeLimit;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!B\u0001\u0003\u0001\ta!\u0001\u0005*pG.,G/T)SK2\fG/[8o\u0015\t\u0019A!\u0001\u0005s_\u000e\\W\r^7r\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0005\u00015\u0019b\u0003\u0005\u0002\u000f#5\tqB\u0003\u0002\u0011\t\u000591o\\;sG\u0016\u001c\u0018B\u0001\n\u0010\u00051\u0011\u0015m]3SK2\fG/[8o!\tqA#\u0003\u0002\u0016\u001f\tIA+\u00192mKN\u001b\u0017M\u001c\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00037a\u0011q\u0001T8hO&tw\r\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0011 \u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010^\u0002\u0001+\u0005\u0001\u0003CA\u0011#\u001b\u0005!\u0011BA\u0012\u0005\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010\u001e\u0005\tK\u0001\u0011\t\u0011)A\u0005A\u0005Y1/\u001d7D_:$X\r\u001f;!\u0011!9\u0003A!A!\u0002\u0013A\u0013!D:pkJ\u001cWm\u00149uS>t7\u000f\u0005\u0003*_I\u0012dB\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z\u0013A\u0002)sK\u0012,g-\u0003\u00021c\t\u0019Q*\u00199\u000b\u00059Z\u0003CA\u00154\u0013\t!\u0014G\u0001\u0004TiJLgn\u001a\u0005\tm\u0001\u0011\t\u0011)A\u0005Q\u0005aq\u000e\u001d;j_:\u0004\u0016M]1ng\"A\u0001\b\u0001B\u0001B\u0003%\u0011(\u0001\bgC&dwJ\u001c#bi\u0006dun]:\u0011\u0005)R\u0014BA\u001e,\u0005\u001d\u0011un\u001c7fC:D\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\u0010gR\f'\u000f^5oO>3gm]3ugB\u0011q\bQ\u0007\u0002\u0005%\u0011\u0011I\u0001\u0002\u0019%>\u001c7.\u001a;N#>3gm]3u%\u0006tw-\u001a'j[&$\b\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002\u001b\u0015tG-\u001b8h\u001f\u001a47/\u001a;t\u0011\u0015)\u0005\u0001\"\u0001G\u0003\u0019a\u0014N\\5u}Q9q\tS%K\u00172k\u0005CA \u0001\u0011\u0015iB\t1\u0001!\u0011\u00159C\t1\u0001)\u0011\u00151D\t1\u0001)\u0011\u0015AD\t1\u0001:\u0011\u0015iD\t1\u0001?\u0011\u0015\u0019E\t1\u0001?\u0011\u001dy\u0005A1A\u0005\nA\u000bQ\u0002]8mYRKW.Z8vi6\u001bX#A)\u0011\u0005)\u0012\u0016BA*,\u0005\u0011auN\\4\t\rU\u0003\u0001\u0015!\u0003R\u00039\u0001x\u000e\u001c7US6,w.\u001e;Ng\u0002BQa\u0016\u0001\u0005Ba\u000baa]2iK6\fW#A-\u0011\u0005ikV\"A.\u000b\u0005q#\u0011!\u0002;za\u0016\u001c\u0018B\u00010\\\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006A\u0002!\t%Y\u0001\nEVLG\u000eZ*dC:$\u0012A\u0019\t\u0004G\u001aDW\"\u00013\u000b\u0005\u00154\u0011a\u0001:eI&\u0011q\r\u001a\u0002\u0004%\u0012#\u0005CA\u0011j\u0013\tQGAA\u0002S_^DQ\u0001\u001c\u0001\u0005\n5\f1cZ3u!\u0006\u0014H/\u001b;j_:|eMZ:fiN$2A\u001c=~!\u0011Isf\\)\u0011\u0005A4X\"A9\u000b\u0005I\u001c\u0018aB7fgN\fw-\u001a\u0006\u0003iV\faaY8n[>t'BA\u0002\t\u0013\t9\u0018O\u0001\u0007NKN\u001c\u0018mZ3Rk\u0016,X\rC\u0003zW\u0002\u0007!0\u0001\u0007pM\u001a\u001cX\r\u001e*fC\u0012,'\u000f\u0005\u0002@w&\u0011AP\u0001\u0002\u0015%>\u001c7.\u001a;N#>3gm]3u%\u0016\fG-\u001a:\t\u000by\\\u0007\u0019\u0001 \u0002!=4gm]3u%\u0006tw-\u001a'j[&$\bbBA\u0001\u0001\u0011\u0005\u00131A\u0001\ti>\u001cFO]5oOR\t!\u0007")
public class RocketMQRelation
extends BaseRelation
implements TableScan,
Logging {
    private final SQLContext sqlContext;
    private final scala.collection.immutable.Map<String, String> sourceOptions;
    private final scala.collection.immutable.Map<String, String> optionParams;
    private final boolean failOnDataLoss;
    private final RocketMQOffsetRangeLimit startingOffsets;
    private final RocketMQOffsetRangeLimit endingOffsets;
    private final long pollTimeoutMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public StructType schema() {
        return RocketMQSource$.MODULE$.schema();
    }

    /*
     * WARNING - void declaration
     */
    public RDD<Row> buildScan() {
        Tuple2 tuple2;
        String uniqueGroupId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-rocketmq-relation-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID()}));
        RocketMQOffsetReader offsetReader = new RocketMQOffsetReader(RocketMQSourceProvider$.MODULE$.paramsForDriver(this.optionParams), this.sourceOptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-driver"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uniqueGroupId})));
        try {
            tuple2 = new Tuple2(this.getPartitionOffsets(offsetReader, this.startingOffsets), this.getPartitionOffsets(offsetReader, this.endingOffsets));
            offsetReader.close();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 != null) {
            void var10_9;
            void var9_8;
            Tuple2 tuple23;
            scala.collection.immutable.Map fromPartitionOffsets = (scala.collection.immutable.Map)tuple22._1();
            scala.collection.immutable.Map untilPartitionOffsets = (scala.collection.immutable.Map)tuple22._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)fromPartitionOffsets, (Object)untilPartitionOffsets);
            scala.collection.immutable.Map fromPartitionOffsets2 = (scala.collection.immutable.Map)tuple24._1();
            scala.collection.immutable.Map untilPartitionOffsets2 = (scala.collection.immutable.Map)tuple24._2();
            Set set2 = fromPartitionOffsets2.keySet();
            Set set3 = untilPartitionOffsets2.keySet();
            if (!(set2 != null ? !set2.equals(set3) : set3 != null)) {
                RocketMQSourceRDDOffsetRange[] offsetRanges = (RocketMQSourceRDDOffsetRange[])((TraversableOnce)untilPartitionOffsets2.keySet().map((Function1)new Serializable(this, fromPartitionOffsets2, untilPartitionOffsets2){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map fromPartitionOffsets$1;
                    private final scala.collection.immutable.Map untilPartitionOffsets$1;

                    public final RocketMQSourceRDDOffsetRange apply(MessageQueue tp) {
                        long fromOffset = BoxesRunTime.unboxToLong((Object)this.fromPartitionOffsets$1.getOrElse((Object)tp, (Function0)new Serializable(this, tp){
                            public static final long serialVersionUID = 0L;
                            private final MessageQueue tp$1;

                            public final Nothing$ apply() {
                                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " doesn't have a from offset"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1})));
                            }
                            {
                                this.tp$1 = tp$1;
                            }
                        }));
                        long untilOffset = BoxesRunTime.unboxToLong((Object)this.untilPartitionOffsets$1.apply((Object)tp));
                        return new RocketMQSourceRDDOffsetRange(tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
                    }
                    {
                        this.fromPartitionOffsets$1 = fromPartitionOffsets$1;
                        this.untilPartitionOffsets$1 = untilPartitionOffsets$1;
                    }
                }, Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RocketMQSourceRDDOffsetRange.class));
                this.logInfo((Function0<String>)new Serializable(this, offsetRanges){
                    public static final long serialVersionUID = 0L;
                    private final RocketMQSourceRDDOffsetRange[] offsetRanges$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"GetBatch generating RDD of offset range: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges$1).sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(RocketMQSourceRDDOffsetRange x$2) {
                                return x$2.messageQueue().toString();
                            }
                        }, (Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString();
                    }
                    {
                        this.offsetRanges$1 = offsetRanges$1;
                    }
                });
                Map<String, String> executorRocketMQParams = RocketMQSourceProvider$.MODULE$.paramsForExecutors(this.optionParams, uniqueGroupId);
                RDD rdd = new RocketMQSourceRDD(this.sqlContext().sparkContext(), executorRocketMQParams, (Seq<RocketMQSourceRDDOffsetRange>)Predef$.MODULE$.wrapRefArray((Object[])offsetRanges), this.pollTimeoutMs(), this.failOnDataLoss, false).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply(MessageExt cr) {
                        String brokerName = (String)cr.getProperties().remove(RocketMQSource$.MODULE$.PROP_BROKER_NAME());
                        return InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)cr.getTopic()), BoxesRunTime.boxToInteger((int)cr.getFlag()), cr.getBody(), UTF8String.fromString((String)JsonUtils$.MODULE$.messageProperties(cr.getProperties())), UTF8String.fromString((String)brokerName), BoxesRunTime.boxToInteger((int)cr.getQueueId()), BoxesRunTime.boxToLong((long)cr.getQueueOffset()), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(cr.getBornTimestamp()))), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(cr.getStoreTimestamp())))}));
                    }
                }, ClassTag$.MODULE$.apply(InternalRow.class));
                return this.sqlContext().internalCreateDataFrame(rdd, this.schema(), this.sqlContext().internalCreateDataFrame$default$3()).rdd();
            }
            Ordering topicOrdering = package$.MODULE$.Ordering().by((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(MessageQueue t) {
                    return t.getTopic();
                }
            }, (Ordering)Ordering.String$.MODULE$);
            String fromTopics = ((TraversableOnce)var9_8.keySet().toList().sorted(topicOrdering)).mkString(",");
            String untilTopics = ((TraversableOnce)var10_9.keySet().toList().sorted(topicOrdering)).mkString(",");
            throw new IllegalStateException(new StringBuilder().append((Object)"different topic partitions ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for starting offsets topics[", "] and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fromTopics}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ending offsets topics[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{untilTopics}))).toString());
        }
        throw new MatchError((Object)tuple22);
    }

    private scala.collection.immutable.Map<MessageQueue, Object> getPartitionOffsets(RocketMQOffsetReader offsetReader, RocketMQOffsetRangeLimit offsetRangeLimit) {
        RocketMQOffsetRangeLimit rocketMQOffsetRangeLimit;
        block5: {
            scala.collection.immutable.Map map;
            block3: {
                Set<MessageQueue> partitions2;
                block4: {
                    block2: {
                        partitions2 = offsetReader.fetchTopicPartitions();
                        rocketMQOffsetRangeLimit = offsetRangeLimit;
                        if (!EarliestOffsetRangeLimit$.MODULE$.equals(rocketMQOffsetRangeLimit)) break block2;
                        map = ((TraversableOnce)partitions2.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<MessageQueue, Object> apply(MessageQueue x0$1) {
                                MessageQueue messageQueue = x0$1;
                                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)messageQueue), (Object)BoxesRunTime.boxToLong((long)RocketMQOffsetRangeLimit$.MODULE$.EARLIEST()));
                                return tuple2;
                            }
                        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        break block3;
                    }
                    if (!LatestOffsetRangeLimit$.MODULE$.equals(rocketMQOffsetRangeLimit)) break block4;
                    map = ((TraversableOnce)partitions2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<MessageQueue, Object> apply(MessageQueue x0$2) {
                            MessageQueue messageQueue = x0$2;
                            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)messageQueue), (Object)BoxesRunTime.boxToLong((long)RocketMQOffsetRangeLimit$.MODULE$.LATEST()));
                            return tuple2;
                        }
                    }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    break block3;
                }
                if (!(rocketMQOffsetRangeLimit instanceof SpecificOffsetRangeLimit)) break block5;
                SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)rocketMQOffsetRangeLimit;
                scala.collection.immutable.Map<MessageQueue, Object> partitionOffsets2 = specificOffsetRangeLimit.partitionOffsets();
                map = this.validateTopicPartitions$1(partitions2, partitionOffsets2);
            }
            return map;
        }
        throw new MatchError((Object)rocketMQOffsetRangeLimit);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RocketMQRelation(start=", ", end=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.startingOffsets, this.endingOffsets}));
    }

    private final scala.collection.immutable.Map validateTopicPartitions$1(Set partitions2, scala.collection.immutable.Map partitionOffsets2) {
        Set set2 = partitions2;
        Set set3 = partitionOffsets2.keySet();
        Predef$.MODULE$.assert(!(set2 != null ? !set2.equals(set3) : set3 != null), (Function0)new Serializable(this, partitions2, partitionOffsets2){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final scala.collection.immutable.Map partitionOffsets$1;

            public final String apply() {
                return new StringBuilder().append((Object)"If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest, if you don't care.\n").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified: ", " Assigned: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionOffsets$1.keySet(), this.partitions$1}))).toString();
            }
            {
                this.partitions$1 = partitions$1;
                this.partitionOffsets$1 = partitionOffsets$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this, partitions2, partitionOffsets2){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final scala.collection.immutable.Map partitionOffsets$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partitions assigned to consumer: ", ". Seeking to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitions$1, this.partitionOffsets$1}));
            }
            {
                this.partitions$1 = partitions$1;
                this.partitionOffsets$1 = partitionOffsets$1;
            }
        });
        return partitionOffsets2;
    }

    public RocketMQRelation(SQLContext sqlContext, scala.collection.immutable.Map<String, String> sourceOptions, scala.collection.immutable.Map<String, String> optionParams, boolean failOnDataLoss2, RocketMQOffsetRangeLimit startingOffsets, RocketMQOffsetRangeLimit endingOffsets) {
        this.sqlContext = sqlContext;
        this.sourceOptions = sourceOptions;
        this.optionParams = optionParams;
        this.failOnDataLoss = failOnDataLoss2;
        this.startingOffsets = startingOffsets;
        this.endingOffsets = endingOffsets;
        Logging.class.$init$((Logging)this);
        RocketMQOffsetRangeLimit rocketMQOffsetRangeLimit = startingOffsets;
        LatestOffsetRangeLimit$ latestOffsetRangeLimit$ = LatestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(rocketMQOffsetRangeLimit != null ? !rocketMQOffsetRangeLimit.equals(latestOffsetRangeLimit$) : latestOffsetRangeLimit$ != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting offset not allowed to be set to latest offsets.";
            }
        });
        RocketMQOffsetRangeLimit rocketMQOffsetRangeLimit2 = endingOffsets;
        EarliestOffsetRangeLimit$ earliestOffsetRangeLimit$ = EarliestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(rocketMQOffsetRangeLimit2 != null ? !rocketMQOffsetRangeLimit2.equals(earliestOffsetRangeLimit$) : earliestOffsetRangeLimit$ != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Ending offset not allowed to be set to earliest offsets.";
            }
        });
        this.pollTimeoutMs = new StringOps(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)RocketMQConf$.MODULE$.PULL_TIMEOUT_MS(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RocketMQRelation $outer;

            public final String apply() {
                return ((Object)BoxesRunTime.boxToLong((long)this.$outer.sqlContext().sparkContext().conf().getTimeAsMs("spark.network.timeout", "120s"))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }))).toLong();
    }
}

