/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rocketmq;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.rocketmq.CachedRocketMQProducer$;
import org.apache.spark.sql.rocketmq.RocketMQConf$;
import org.apache.spark.sql.rocketmq.RocketMQUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class CachedRocketMQProducer$
implements Logging {
    public static final CachedRocketMQProducer$ MODULE$;
    private long cacheExpireTimeout;
    private final Object removalListener;
    private Cache<String, DefaultMQProducer> guavaCache;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    static {
        new CachedRocketMQProducer$();
    }

    private long cacheExpireTimeout$lzycompute() {
        CachedRocketMQProducer$ cachedRocketMQProducer$ = this;
        synchronized (cachedRocketMQProducer$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.cacheExpireTimeout = SparkEnv$.MODULE$.get().conf().getTimeAsMs(RocketMQConf$.MODULE$.PRODUCER_CACHE_TIMEOUT(), "10m");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.cacheExpireTimeout;
        }
    }

    private Cache guavaCache$lzycompute() {
        CachedRocketMQProducer$ cachedRocketMQProducer$ = this;
        synchronized (cachedRocketMQProducer$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.guavaCache = CacheBuilder.newBuilder().expireAfterAccess(this.cacheExpireTimeout(), TimeUnit.MILLISECONDS).removalListener(this.removalListener()).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.removalListener = null;
            return this.guavaCache;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private long cacheExpireTimeout() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.cacheExpireTimeout$lzycompute() : this.cacheExpireTimeout;
    }

    private Object removalListener() {
        return this.removalListener;
    }

    private Cache<String, DefaultMQProducer> guavaCache() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.guavaCache$lzycompute() : this.guavaCache;
    }

    public DefaultMQProducer getOrCreate(Map<String, String> options) {
        String group = options.get(RocketMQConf$.MODULE$.PRODUCER_GROUP());
        try {
            return (DefaultMQProducer)this.guavaCache().get((Object)group, (Callable)new Callable<DefaultMQProducer>(options, group){
                private final Map options$1;
                public final String group$3;

                /*
                 * WARNING - void declaration
                 */
                public DefaultMQProducer call() {
                    void var1_1;
                    DefaultMQProducer producer = RocketMQUtils$.MODULE$.makeProducer(this.group$3, this.options$1);
                    CachedRocketMQProducer$.MODULE$.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.2 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created a new instance of RocketMQ producer for group ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.group$3}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return var1_1;
                }
                {
                    this.options$1 = options$1;
                    this.group$3 = group$3;
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ExecutionException ? true : (throwable2 instanceof UncheckedExecutionException ? true : throwable2 instanceof ExecutionError);
            if (bl && throwable2.getCause() != null) {
                throw throwable2.getCause();
            }
            throw throwable;
        }
    }

    private void close(Map<String, String> options) {
        String group = options.get(RocketMQConf$.MODULE$.PRODUCER_GROUP());
        this.guavaCache().invalidate((Object)group);
    }

    public void org$apache$spark$sql$rocketmq$CachedRocketMQProducer$$close(String group, DefaultMQProducer producer) {
        try {
            this.logInfo((Function0<String>)new Serializable(group){
                public static final long serialVersionUID = 0L;
                private final String group$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing the RocketMQ producer of group ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group$2}));
                }
                {
                    this.group$2 = group$2;
                }
            });
            producer.shutdown();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while closing RocketMQ producer.";
                }
            }, e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void clear() {
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cleaning up guava cache.";
            }
        });
        this.guavaCache().invalidateAll();
    }

    private ConcurrentMap<String, DefaultMQProducer> getAsMap() {
        return this.guavaCache().asMap();
    }

    private CachedRocketMQProducer$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.removalListener = new RemovalListener<String, DefaultMQProducer>(){

            public void onRemoval(RemovalNotification<String, DefaultMQProducer> notification) {
                String group = (String)notification.getKey();
                DefaultMQProducer producer = (DefaultMQProducer)notification.getValue();
                CachedRocketMQProducer$.MODULE$.logDebug((Function0<String>)new Serializable(this, notification, group, producer){
                    public static final long serialVersionUID = 0L;
                    private final RemovalNotification notification$1;
                    private final String group$1;
                    private final DefaultMQProducer producer$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Evicting RocketMQ producer ", " for group ", ", due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.producer$1, this.group$1, this.notification$1.getCause()}));
                    }
                    {
                        this.notification$1 = notification$1;
                        this.group$1 = group$1;
                        this.producer$1 = producer$1;
                    }
                });
                CachedRocketMQProducer$.MODULE$.org$apache$spark$sql$rocketmq$CachedRocketMQProducer$$close(group, producer);
            }
        };
    }
}

