/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rocketmq;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.MQPullConsumer;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.rocketmq.CachedRocketMQConsumer;
import org.apache.spark.sql.rocketmq.CachedRocketMQConsumer$;
import org.apache.spark.sql.rocketmq.CachedRocketMQConsumer$CacheKey$;
import org.apache.spark.sql.rocketmq.RocketMQConf$;
import org.apache.spark.sql.rocketmq.RocketMQUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CachedRocketMQConsumer$
implements Logging,
Serializable {
    public static final CachedRocketMQConsumer$ MODULE$;
    private final long org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$UNKNOWN_OFFSET;
    private LinkedHashMap<CachedRocketMQConsumer.CacheKey, CachedRocketMQConsumer> cache;
    private final Map<String, MQPullConsumer> org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdToClient;
    private final Map<String, MutableInt> org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdUseCount;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new CachedRocketMQConsumer$();
    }

    private LinkedHashMap cache$lzycompute() {
        CachedRocketMQConsumer$ cachedRocketMQConsumer$ = this;
        synchronized (cachedRocketMQConsumer$) {
            if (!this.bitmap$0) {
                SparkConf conf = SparkEnv$.MODULE$.get().conf();
                int capacity = conf.getInt(RocketMQConf$.MODULE$.PULL_CONSUMER_CACHE_MAX_CAPACITY(), 64);
                this.cache = new LinkedHashMap<CachedRocketMQConsumer.CacheKey, CachedRocketMQConsumer>(capacity){
                    public final int capacity$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean removeEldestEntry(Map.Entry<CachedRocketMQConsumer.CacheKey, CachedRocketMQConsumer> entry) {
                        if (entry.getValue().inUse()) return false;
                        if (this.size() <= this.capacity$1) return false;
                        CachedRocketMQConsumer$.MODULE$.logWarning((Function0<String>)new Serializable(this, entry){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;
                            private final Map.Entry entry$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RocketMQConsumer cache hitting max capacity of ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.capacity$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removing consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.entry$1 = entry$1;
                            }
                        });
                        try {
                            entry.getValue().close();
                            return true;
                        }
                        catch (SparkException sparkException) {
                            CachedRocketMQConsumer$.MODULE$.logError((Function0<String>)new Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final Map.Entry entry$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error closing earliest RocketMQ consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}));
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            }, sparkException);
                        }
                        return true;
                    }
                    {
                        this.capacity$1 = capacity$1;
                        super(capacity$1, 0.75f, true);
                    }
                };
                this.bitmap$0 = true;
            }
            return this.cache;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public long org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$UNKNOWN_OFFSET() {
        return this.org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$UNKNOWN_OFFSET;
    }

    private LinkedHashMap<CachedRocketMQConsumer.CacheKey, CachedRocketMQConsumer> cache() {
        return this.bitmap$0 ? this.cache : this.cache$lzycompute();
    }

    public Map<String, MQPullConsumer> org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdToClient() {
        return this.org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdToClient;
    }

    public Map<String, MutableInt> org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdUseCount() {
        return this.org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdUseCount;
    }

    public void releaseConsumer(MessageQueue queue, java.util.Map<String, String> options) {
        CachedRocketMQConsumer.CacheKey key = CachedRocketMQConsumer$CacheKey$.MODULE$.from(queue, options);
        CachedRocketMQConsumer$ cachedRocketMQConsumer$ = this;
        synchronized (cachedRocketMQConsumer$) {
            BoxedUnit boxedUnit;
            CachedRocketMQConsumer consumer = this.cache().get(key);
            if (consumer == null) {
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to release consumer that does not exist"})).s((Seq)Nil$.MODULE$);
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                consumer.inUse_$eq(false);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void removeConsumer(MessageQueue queue, java.util.Map<String, String> options) {
        CachedRocketMQConsumer.CacheKey key = CachedRocketMQConsumer$CacheKey$.MODULE$.from(queue, options);
        CachedRocketMQConsumer$ cachedRocketMQConsumer$ = this;
        synchronized (cachedRocketMQConsumer$) {
            BoxedUnit boxedUnit;
            CachedRocketMQConsumer removedConsumer = (CachedRocketMQConsumer)this.cache().remove(key);
            if (removedConsumer == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                removedConsumer.close();
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized CachedRocketMQConsumer getOrCreate(MessageQueue queue, java.util.Map<String, String> options) {
        CachedRocketMQConsumer cachedRocketMQConsumer;
        Object object;
        CachedRocketMQConsumer.CacheKey key = CachedRocketMQConsumer$CacheKey$.MODULE$.from(queue, options);
        String groupId = options.get(RocketMQConf$.MODULE$.CONSUMER_GROUP());
        CachedRocketMQConsumer$ cachedRocketMQConsumer$ = this;
        synchronized (cachedRocketMQConsumer$) {
            ((MutableInt)this.org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdUseCount().getOrElseUpdate((Object)groupId, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final MutableInt apply() {
                    return new MutableInt(0);
                }
            })).increment();
            object = this.org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdToClient().getOrElseUpdate((Object)groupId, (Function0)new Serializable(options, groupId){
                public static final long serialVersionUID = 0L;
                private final java.util.Map options$1;
                private final String groupId$1;

                public final DefaultMQPullConsumer apply() {
                    return RocketMQUtils$.MODULE$.makePullConsumer(this.groupId$1, this.options$1);
                }
                {
                    this.options$1 = options$1;
                    this.groupId$1 = groupId$1;
                }
            });
        }
        MQPullConsumer client = (MQPullConsumer)object;
        if (TaskContext$.MODULE$.get() != null && TaskContext$.MODULE$.get().attemptNumber() >= 1) {
            this.removeConsumer(queue, options);
            CachedRocketMQConsumer consumer = new CachedRocketMQConsumer(client, queue, options);
            consumer.inUse_$eq(true);
            this.cache().put(key, consumer);
            cachedRocketMQConsumer = consumer;
            return cachedRocketMQConsumer;
        }
        Object object2 = this.cache().containsKey(key) ? BoxedUnit.UNIT : this.cache().put(key, new CachedRocketMQConsumer(client, queue, options));
        CachedRocketMQConsumer consumer = this.cache().get(key);
        consumer.inUse_$eq(true);
        cachedRocketMQConsumer = consumer;
        return cachedRocketMQConsumer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CachedRocketMQConsumer createUncached(MessageQueue queue, java.util.Map<String, String> options) {
        Object object;
        String groupId = options.get(RocketMQConf$.MODULE$.CONSUMER_GROUP());
        CachedRocketMQConsumer$ cachedRocketMQConsumer$ = this;
        synchronized (cachedRocketMQConsumer$) {
            ((MutableInt)this.org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdUseCount().getOrElseUpdate((Object)groupId, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final MutableInt apply() {
                    return new MutableInt(0);
                }
            })).increment();
            object = this.org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdToClient().getOrElseUpdate((Object)groupId, (Function0)new Serializable(options, groupId){
                public static final long serialVersionUID = 0L;
                private final java.util.Map options$2;
                private final String groupId$2;

                public final DefaultMQPullConsumer apply() {
                    return RocketMQUtils$.MODULE$.makePullConsumer(this.groupId$2, this.options$2);
                }
                {
                    this.options$2 = options$2;
                    this.groupId$2 = groupId$2;
                }
            });
        }
        MQPullConsumer client = (MQPullConsumer)object;
        return new CachedRocketMQConsumer(client, queue, options);
    }

    public void org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$reportDataLoss0(boolean failOnDataLoss2, String finalMessage, Throwable cause) {
        if (failOnDataLoss2) {
            if (cause == null) {
                throw new IllegalStateException(finalMessage);
            }
            throw new IllegalStateException(finalMessage, cause);
        }
        if (cause == null) {
            this.logWarning((Function0<String>)new Serializable(finalMessage){
                public static final long serialVersionUID = 0L;
                private final String finalMessage$1;

                public final String apply() {
                    return this.finalMessage$1;
                }
                {
                    this.finalMessage$1 = finalMessage$1;
                }
            });
        } else {
            this.logWarning((Function0<String>)new Serializable(finalMessage){
                public static final long serialVersionUID = 0L;
                private final String finalMessage$1;

                public final String apply() {
                    return this.finalMessage$1;
                }
                {
                    this.finalMessage$1 = finalMessage$1;
                }
            }, cause);
        }
    }

    private Throwable reportDataLoss0$default$3() {
        return null;
    }

    public CachedRocketMQConsumer apply(MQPullConsumer consumer, MessageQueue queue, java.util.Map<String, String> options) {
        return new CachedRocketMQConsumer(consumer, queue, options);
    }

    public Option<Tuple3<MQPullConsumer, MessageQueue, java.util.Map<String, String>>> unapply(CachedRocketMQConsumer x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.consumer(), (Object)x$0.queue(), x$0.options()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CachedRocketMQConsumer$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$UNKNOWN_OFFSET = -2L;
        this.org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdToClient = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.org$apache$spark$sql$rocketmq$CachedRocketMQConsumer$$groupIdUseCount = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

