/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spark.streaming;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;

public class MessageSet
implements Iterator<Message>,
Serializable {
    private final String id;
    private final List<MessageExt> data;
    private final Iterator<MessageExt> iterator;
    private long timestamp;
    private int retries;

    public MessageSet(String id, List<MessageExt> data) {
        this.id = id;
        this.data = data;
        this.iterator = data.iterator();
    }

    public MessageSet(List<MessageExt> data) {
        this(UUID.randomUUID().toString(), data);
    }

    public String getId() {
        return this.id;
    }

    public List<MessageExt> getData() {
        return this.data;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Message next() {
        return (Message)this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public String toString() {
        return this.data.toString();
    }
}

