/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spark;

import java.io.Serializable;

public final class TopicQueueId
implements Serializable {
    private int hash = 0;
    private final int queueId;
    private final String topic;

    public TopicQueueId(String topic, int queueId) {
        this.queueId = queueId;
        this.topic = topic;
    }

    public int queueId() {
        return this.queueId;
    }

    public String topic() {
        return this.topic;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.queueId;
        this.hash = result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicQueueId other = (TopicQueueId)obj;
        if (this.queueId != other.queueId) {
            return false;
        }
        return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
    }

    protected TopicQueueId clone() throws CloneNotSupportedException {
        return new TopicQueueId(this.topic, this.queueId);
    }

    public String toString() {
        return this.topic + "-" + this.queueId;
    }
}

