/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spark.ConsumerStrategy;
import org.apache.rocketmq.spark.LocationStrategy;
import org.apache.rocketmq.spark.OffsetRange;
import org.apache.rocketmq.spark.PreferConsistent$;
import org.apache.rocketmq.spark.PreferFixed;
import org.apache.rocketmq.spark.RocketMQConfig;
import org.apache.rocketmq.spark.TopicQueueId;
import org.apache.rocketmq.spark.streaming.ReliableRocketMQReceiver;
import org.apache.rocketmq.spark.streaming.RocketMQReceiver;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.MQPullInputDStream;
import org.apache.spark.streaming.RocketMqRDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.receiver.Receiver;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;

public final class RocketMqUtils$ {
    public static final RocketMqUtils$ MODULE$;

    static {
        new RocketMqUtils$();
    }

    public RDD<MessageExt> createRDD(SparkContext sc, String groupId, Map<TopicQueueId, OffsetRange[]> offsetRanges, Map<String, String> optionParams, LocationStrategy locationStrategy) {
        LocationStrategy locationStrategy2;
        block4: {
            Map<TopicQueueId, String> map;
            block3: {
                block2: {
                    locationStrategy2 = locationStrategy;
                    if (!PreferConsistent$.MODULE$.equals(locationStrategy2)) break block2;
                    map = Collections.emptyMap();
                    break block3;
                }
                if (!(locationStrategy2 instanceof PreferFixed)) break block4;
                PreferFixed preferFixed = (PreferFixed)locationStrategy2;
                Map<TopicQueueId, String> hostMap = preferFixed.hostMap();
                map = hostMap;
            }
            Map<TopicQueueId, String> preferredHosts = map;
            return new RocketMqRDD(sc, groupId, optionParams, offsetRanges, preferredHosts, false);
        }
        throw new MatchError((Object)locationStrategy2);
    }

    public Map<String, String> createRDD$default$4() {
        return new HashMap<String, String>();
    }

    public LocationStrategy createRDD$default$5() {
        return PreferConsistent$.MODULE$;
    }

    public JavaRDD<MessageExt> createJavaRDD(JavaSparkContext jsc, String groupId, Map<TopicQueueId, OffsetRange[]> offsetRanges, Map<String, String> optionParams, LocationStrategy locationStrategy) {
        return new JavaRDD(this.createRDD(jsc.sc(), groupId, offsetRanges, optionParams, locationStrategy), ClassTag$.MODULE$.apply(MessageExt.class));
    }

    public Map<String, String> createJavaRDD$default$4() {
        return new HashMap<String, String>();
    }

    public LocationStrategy createJavaRDD$default$5() {
        return PreferConsistent$.MODULE$;
    }

    public InputDStream<MessageExt> createMQPullStream(StreamingContext ssc, String groupId, Collection<String> topics, ConsumerStrategy consumerStrategy, boolean autoCommit, boolean forceSpecial, boolean failOnDataLoss2, LocationStrategy locationStrategy, Map<String, String> optionParams) {
        return new MQPullInputDStream(ssc, groupId, topics, optionParams, locationStrategy, consumerStrategy, autoCommit, forceSpecial, failOnDataLoss2);
    }

    public InputDStream<MessageExt> createMQPullStream(StreamingContext ssc, String groupId, String topic, ConsumerStrategy consumerStrategy, boolean autoCommit, boolean forceSpecial, boolean failOnDataLoss2, Map<String, String> optionParams) {
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topic);
        return new MQPullInputDStream(ssc, groupId, topics, optionParams, PreferConsistent$.MODULE$, consumerStrategy, autoCommit, forceSpecial, failOnDataLoss2);
    }

    public LocationStrategy createMQPullStream$default$8() {
        return PreferConsistent$.MODULE$;
    }

    public Map<String, String> createMQPullStream$default$9() {
        return new HashMap<String, String>();
    }

    public JavaInputDStream<MessageExt> createJavaMQPullStream(JavaStreamingContext ssc, String groupId, Collection<String> topics, ConsumerStrategy consumerStrategy, boolean autoCommit, boolean forceSpecial, boolean failOnDataLoss2, LocationStrategy locationStrategy, Map<String, String> optionParams) {
        InputDStream<MessageExt> inputDStream = this.createMQPullStream(ssc.ssc(), groupId, topics, consumerStrategy, autoCommit, forceSpecial, failOnDataLoss2, locationStrategy, optionParams);
        return new JavaInputDStream(inputDStream, ClassTag$.MODULE$.apply(MessageExt.class));
    }

    public JavaInputDStream<MessageExt> createJavaMQPullStream(JavaStreamingContext ssc, String groupId, Collection<String> topics, ConsumerStrategy consumerStrategy, boolean autoCommit, boolean forceSpecial, boolean failOnDataLoss2) {
        InputDStream<MessageExt> inputDStream = this.createMQPullStream(ssc.ssc(), groupId, topics, consumerStrategy, autoCommit, forceSpecial, failOnDataLoss2, this.createMQPullStream$default$8(), this.createMQPullStream$default$9());
        return new JavaInputDStream(inputDStream, ClassTag$.MODULE$.apply(MessageExt.class));
    }

    public LocationStrategy createJavaMQPullStream$default$8() {
        return PreferConsistent$.MODULE$;
    }

    public Map<String, String> createJavaMQPullStream$default$9() {
        return new HashMap<String, String>();
    }

    public DefaultMQPullConsumer mkPullConsumerInstance(String groupId, Map<String, String> optionParams, String instance) {
        DefaultMQPullConsumer consumer = new DefaultMQPullConsumer(groupId);
        if (optionParams.containsKey(RocketMQConfig.PULL_TIMEOUT_MS)) {
            consumer.setConsumerTimeoutMillisWhenSuspend(new StringOps(Predef$.MODULE$.augmentString(optionParams.get(RocketMQConfig.PULL_TIMEOUT_MS))).toLong());
        }
        if (!StringUtils.isBlank((String)instance)) {
            consumer.setInstanceName(instance);
        }
        if (optionParams.containsKey(RocketMQConfig.NAME_SERVER_ADDR)) {
            consumer.setNamesrvAddr(optionParams.get(RocketMQConfig.NAME_SERVER_ADDR));
        }
        consumer.start();
        consumer.setOffsetStore(consumer.getDefaultMQPullConsumerImpl().getOffsetStore());
        return consumer;
    }

    public JavaInputDStream<Message> createJavaMQPushStream(JavaStreamingContext jssc, Properties properties, StorageLevel level) {
        return this.createJavaMQPushStream(jssc, properties, level, false);
    }

    public JavaInputDStream<Message> createJavaReliableMQPushStream(JavaStreamingContext jssc, Properties properties, StorageLevel level) {
        return this.createJavaMQPushStream(jssc, properties, level, true);
    }

    public JavaInputDStream<Message> createJavaMQPushStream(JavaStreamingContext jssc, Properties properties, StorageLevel level, boolean reliable) {
        if (jssc == null || properties == null || level == null) {
            return null;
        }
        RocketMQReceiver receiver = reliable ? new ReliableRocketMQReceiver(properties, level) : new RocketMQReceiver(properties, level);
        JavaReceiverInputDStream ds = jssc.receiverStream((Receiver)receiver);
        return ds;
    }

    private RocketMqUtils$() {
        MODULE$ = this;
    }
}

