/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spark;

import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.remoting.common.RemotingUtil;

public class RocketMQConfig {
    public static final String NAME_SERVER_ADDR = "nameserver.addr";
    public static final String CLIENT_NAME = "client.name";
    public static final String CLIENT_IP = "client.ip";
    public static final String DEFAULT_CLIENT_IP = RemotingUtil.getLocalAddress();
    public static final String CLIENT_CALLBACK_EXECUTOR_THREADS = "client.callback.executor.threads";
    public static final int DEFAULT_CLIENT_CALLBACK_EXECUTOR_THREADS = Runtime.getRuntime().availableProcessors();
    public static final String NAME_SERVER_POLL_INTERVAL = "nameserver.poll.interval";
    public static final int DEFAULT_NAME_SERVER_POLL_INTERVAL = 30000;
    public static final String BROKER_HEART_BEAT_INTERVAL = "brokerserver.heartbeat.interval";
    public static final int DEFAULT_BROKER_HEART_BEAT_INTERVAL = 30000;
    public static final String CONSUMER_GROUP = "consumer.group";
    public static final String CONSUMER_TOPIC = "consumer.topic";
    public static final String CONSUMER_TAG = "consumer.tag";
    public static final String DEFAULT_TAG = "*";
    public static final String CONSUMER_OFFSET_RESET_TO = "consumer.offset.reset.to";
    public static final String CONSUMER_OFFSET_LATEST = "latest";
    public static final String CONSUMER_OFFSET_EARLIEST = "earliest";
    public static final String CONSUMER_OFFSET_TIMESTAMP = "timestamp";
    public static final String CONSUMER_MESSAGES_ORDERLY = "consumer.messages.orderly";
    public static final String CONSUMER_OFFSET_PERSIST_INTERVAL = "consumer.offset.persist.interval";
    public static final int DEFAULT_CONSUMER_OFFSET_PERSIST_INTERVAL = 5000;
    public static final String CONSUMER_MIN_THREADS = "consumer.min.threads";
    public static final int DEFAULT_CONSUMER_MIN_THREADS = 20;
    public static final String CONSUMER_MAX_THREADS = "consumer.max.threads";
    public static final int DEFAULT_CONSUMER_MAX_THREADS = 64;
    public static final String QUEUE_SIZE = "spout.queue.size";
    public static final int DEFAULT_QUEUE_SIZE = 500;
    public static final String MESSAGES_MAX_RETRY = "spout.messages.max.retry";
    public static final int DEFAULT_MESSAGES_MAX_RETRY = 3;
    public static final String MESSAGES_TTL = "spout.messages.ttl";
    public static final int DEFAULT_MESSAGES_TTL = 300000;
    public static final String MAX_PULL_SPEED_PER_PARTITION = "pull.max.speed.per.partition";
    public static final String PULL_MAX_BATCH_SIZE = "pull.max.batch.size";
    public static final String PULL_TIMEOUT_MS = "pull.timeout.ms";
    public static final String PULL_CONSUMER_CACHE_INIT_CAPACITY = "pull.consumer.cache.initialCapacity";
    public static final String PULL_CONSUMER_CACHE_MAX_CAPACITY = "pull.consumer.cache.maxCapacity";
    public static final String PULL_CONSUMER_CACHE_LOAD_FACTOR = "pull.consumer.cache.loadFactor";

    public static void buildConsumerConfigs(Properties props, DefaultMQPushConsumer consumer) {
        String initOffset;
        RocketMQConfig.buildCommonConfigs(props, (ClientConfig)consumer);
        String group = props.getProperty(CONSUMER_GROUP);
        Validate.notEmpty((String)group);
        consumer.setConsumerGroup(group);
        consumer.setPersistConsumerOffsetInterval(RocketMQConfig.getInteger(props, CONSUMER_OFFSET_PERSIST_INTERVAL, 5000));
        consumer.setConsumeThreadMin(RocketMQConfig.getInteger(props, CONSUMER_MIN_THREADS, 20));
        consumer.setConsumeThreadMax(RocketMQConfig.getInteger(props, CONSUMER_MAX_THREADS, 64));
        switch (initOffset = props.getProperty(CONSUMER_OFFSET_RESET_TO, CONSUMER_OFFSET_LATEST)) {
            case "earliest": {
                consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
                break;
            }
            case "latest": {
                consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET);
                break;
            }
            case "timestamp": {
                consumer.setConsumeTimestamp(initOffset);
                break;
            }
            default: {
                consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET);
            }
        }
        String topic = props.getProperty(CONSUMER_TOPIC);
        Validate.notEmpty((String)topic);
        try {
            consumer.subscribe(topic, props.getProperty(CONSUMER_TAG, DEFAULT_TAG));
        }
        catch (MQClientException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void buildCommonConfigs(Properties props, ClientConfig client) {
        String namesvr = props.getProperty(NAME_SERVER_ADDR);
        Validate.notEmpty((String)namesvr);
        client.setNamesrvAddr(namesvr);
        client.setClientIP(props.getProperty(CLIENT_IP, DEFAULT_CLIENT_IP));
        String defaultClientName = UUID.randomUUID().toString();
        client.setInstanceName(props.getProperty(CLIENT_NAME, defaultClientName));
        client.setClientCallbackExecutorThreads(RocketMQConfig.getInteger(props, CLIENT_CALLBACK_EXECUTOR_THREADS, DEFAULT_CLIENT_CALLBACK_EXECUTOR_THREADS));
        client.setPollNameServerInterval(RocketMQConfig.getInteger(props, NAME_SERVER_POLL_INTERVAL, 30000));
        client.setHeartbeatBrokerInterval(RocketMQConfig.getInteger(props, BROKER_HEART_BEAT_INTERVAL, 30000));
    }

    public static int getInteger(Properties props, String key, int defaultValue) {
        return Integer.parseInt(props.getProperty(key, String.valueOf(defaultValue)));
    }

    public static boolean getBoolean(Properties props, String key, boolean defaultValue) {
        return Boolean.parseBoolean(props.getProperty(key, String.valueOf(defaultValue)));
    }
}

