/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.bucket;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.nifi.registry.authorization.Permissions;
import org.apache.nifi.registry.bucket.BucketItemType;
import org.apache.nifi.registry.link.LinkableEntity;

@ApiModel(value="bucketItem")
public abstract class BucketItem
extends LinkableEntity {
    @NotBlank
    private String identifier;
    @NotBlank
    private String name;
    private String description;
    @NotBlank
    private String bucketIdentifier;
    private String bucketName;
    @Min(value=1L)
    private @Min(value=1L) long createdTimestamp;
    @Min(value=1L)
    private @Min(value=1L) long modifiedTimestamp;
    @NotNull
    private final BucketItemType type;
    private Permissions permissions;

    public BucketItem(BucketItemType type) {
        this.type = type;
    }

    @ApiModelProperty(value="An ID to uniquely identify this object.")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @ApiModelProperty(value="The name of the item.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="A description of the item.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="The identifier of the bucket this items belongs to.")
    public String getBucketIdentifier() {
        return this.bucketIdentifier;
    }

    public void setBucketIdentifier(String bucketIdentifier) {
        this.bucketIdentifier = bucketIdentifier;
    }

    @ApiModelProperty(value="The name of the bucket this items belongs to.", readOnly=true)
    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @ApiModelProperty(value="The timestamp of when the item was created.")
    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    @ApiModelProperty(value="The timestamp of when the item was last modified.")
    public long getModifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public void setModifiedTimestamp(long modifiedTimestamp) {
        this.modifiedTimestamp = modifiedTimestamp;
    }

    @ApiModelProperty(value="The type of item.")
    public BucketItemType getType() {
        return this.type;
    }

    @ApiModelProperty(value="The access that the current user has to the bucket containing this item.", readOnly=true)
    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public int hashCode() {
        return Objects.hashCode(this.getIdentifier());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BucketItem other = (BucketItem)obj;
        return Objects.equals(this.getIdentifier(), other.getIdentifier());
    }
}

