/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.SSLEngine;
import org.apache.hadoop.classification.InterfaceAudience;
import org.mortbay.jetty.security.SslSelectChannelConnector;

@InterfaceAudience.Private
public class SslSelectChannelConnectorSecure
extends SslSelectChannelConnector {
    protected SSLEngine createSSLEngine() throws IOException {
        SSLEngine engine = super.createSSLEngine();
        ArrayList<String> nonSSLProtocols = new ArrayList<String>();
        for (String p : engine.getEnabledProtocols()) {
            if (p.contains("SSLv3")) continue;
            nonSSLProtocols.add(p);
        }
        engine.setEnabledProtocols(nonSSLProtocols.toArray(new String[nonSSLProtocols.size()]));
        return engine;
    }
}

