/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import java.util.concurrent.ExecutorService;
import me.hao0.common.util.Preconditions;
import me.hao0.wechat.core.Wechat;
import me.hao0.wechat.loader.AccessTokenLoader;
import me.hao0.wechat.loader.TicketLoader;

public final class WechatBuilder {
    private Wechat wechat;

    public static WechatBuilder newBuilder(String appId, String appSecret) {
        Preconditions.checkNotNullAndEmpty((String)appId, (String)"appId");
        Preconditions.checkNotNullAndEmpty((String)appSecret, (String)"appSecret");
        WechatBuilder builder = new WechatBuilder();
        builder.wechat = new Wechat(appId, appSecret);
        return builder;
    }

    public WechatBuilder token(String token) {
        Preconditions.checkNotNullAndEmpty((String)token, (String)"token");
        this.wechat.appToken = token;
        return this;
    }

    public WechatBuilder msgKey(String msgKey) {
        Preconditions.checkNotNullAndEmpty((String)msgKey, (String)"msgKey");
        this.wechat.msgKey = msgKey;
        return this;
    }

    public WechatBuilder accessTokenLoader(AccessTokenLoader accessTokenLoader) {
        Preconditions.checkNotNull((Object)accessTokenLoader, (Object)"accessTokenLoader can't be null");
        this.wechat.tokenLoader = accessTokenLoader;
        return this;
    }

    public WechatBuilder ticketLoader(TicketLoader ticketLoader) {
        Preconditions.checkNotNull((Object)ticketLoader, (Object)"ticketLoader can't be null");
        this.wechat.ticketLoader = ticketLoader;
        return this;
    }

    public WechatBuilder executor(ExecutorService executor) {
        Preconditions.checkNotNull((Object)executor, (Object)"executor can't be null");
        this.wechat.executor = executor;
        return this;
    }

    public Wechat build() {
        return this.wechat;
    }
}

