/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import me.hao0.common.http.Http;
import me.hao0.common.json.Jsons;
import me.hao0.common.util.Fields;
import me.hao0.wechat.core.AsyncFunction;
import me.hao0.wechat.core.Bases;
import me.hao0.wechat.core.Component;
import me.hao0.wechat.core.CustomerServices;
import me.hao0.wechat.core.Datas;
import me.hao0.wechat.core.JsSdks;
import me.hao0.wechat.core.Materials;
import me.hao0.wechat.core.Menus;
import me.hao0.wechat.core.Messages;
import me.hao0.wechat.core.QrCodes;
import me.hao0.wechat.core.Users;
import me.hao0.wechat.exception.WechatException;
import me.hao0.wechat.loader.AccessTokenLoader;
import me.hao0.wechat.loader.DefaultAccessTokenLoader;
import me.hao0.wechat.loader.DefaultTicketLoader;
import me.hao0.wechat.loader.TicketLoader;
import me.hao0.wechat.model.base.AccessToken;
import me.hao0.wechat.model.js.Ticket;
import me.hao0.wechat.model.js.TicketType;

public final class Wechat {
    private String appId;
    private String appSecret;
    String appToken;
    String msgKey;
    AccessTokenLoader tokenLoader = DEFAULT_ACCESS_TOKEN_LOADER;
    TicketLoader ticketLoader = DEFAULT_TICKET_LOADER;
    ExecutorService executor = DEFAULT_EXECUTOR;
    private final String ERROR_CODE = "errcode";
    private static final String BASES = "me.hao0.wechat.core.Bases";
    private static final String USERS = "me.hao0.wechat.core.Users";
    private static final String MENUS = "me.hao0.wechat.core.Menus";
    private static final String CUSTOMER_SERVICES = "me.hao0.wechat.core.CustomerServices";
    private static final String MESSAGES = "me.hao0.wechat.core.Messages";
    private static final String QRCODES = "me.hao0.wechat.core.QrCodes";
    private static final String MATERIALS = "me.hao0.wechat.core.Materials";
    private static final String DATAS = "me.hao0.wechat.core.Datas";
    private static final String JSSDKS = "me.hao0.wechat.core.JsSdks";
    private static final AccessTokenLoader DEFAULT_ACCESS_TOKEN_LOADER = new DefaultAccessTokenLoader();
    private static final DefaultTicketLoader DEFAULT_TICKET_LOADER = new DefaultTicketLoader();
    private static final JavaType MAP_STRING_OBJ_TYPE = Jsons.DEFAULT.createCollectionType(Map.class, new Class[]{String.class, Object.class});
    private static final ExecutorService DEFAULT_EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("wechat");
            return t;
        }
    });
    private LoadingCache<String, Component> components = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Component>(){

        public Component load(String classFullName) throws Exception {
            Class<?> clazz = Class.forName(classFullName);
            Object comp = clazz.newInstance();
            Wechat.this.injectWechat(clazz, comp);
            return (Component)comp;
        }
    });

    Wechat(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public String getMsgKey() {
        return this.msgKey;
    }

    public Bases base() {
        return (Bases)this.components.getUnchecked((Object)BASES);
    }

    public CustomerServices cs() {
        return (CustomerServices)this.components.getUnchecked((Object)CUSTOMER_SERVICES);
    }

    public Menus menu() {
        return (Menus)this.components.getUnchecked((Object)MENUS);
    }

    public Users user() {
        return (Users)this.components.getUnchecked((Object)USERS);
    }

    public Messages msg() {
        return (Messages)this.components.getUnchecked((Object)MESSAGES);
    }

    public QrCodes qr() {
        return (QrCodes)this.components.getUnchecked((Object)QRCODES);
    }

    public Materials material() {
        return (Materials)this.components.getUnchecked((Object)MATERIALS);
    }

    public Datas data() {
        return (Datas)this.components.getUnchecked((Object)DATAS);
    }

    public JsSdks js() {
        return (JsSdks)this.components.getUnchecked((Object)JSSDKS);
    }

    private void injectWechat(Class clazz, Object comp) throws NoSuchFieldException {
        Field wechat = clazz.getSuperclass().getDeclaredField("wechat");
        Fields.put((Object)comp, (Field)wechat, (Object)this);
    }

    public <T extends Component> void register(T component) {
        try {
            this.injectWechat(component.getClass(), component);
        }
        catch (NoSuchFieldException e) {
            throw new WechatException(e);
        }
    }

    public void destroy() {
        if (this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }

    String loadAccessToken() {
        String accessToken = this.tokenLoader.get();
        if (Strings.isNullOrEmpty((String)accessToken)) {
            AccessToken token = this.base().accessToken();
            this.tokenLoader.refresh(token);
            accessToken = token.getAccessToken();
        }
        return accessToken;
    }

    String loadTicket(TicketType type) {
        String ticket = this.ticketLoader.get(type);
        if (Strings.isNullOrEmpty((String)ticket)) {
            Ticket t = this.js().getTicket(type);
            this.ticketLoader.refresh(t);
            ticket = t.getTicket();
        }
        return ticket;
    }

    Map<String, Object> doPost(String url, Map<String, Object> params) {
        String body = null;
        if (params != null && !params.isEmpty()) {
            body = Jsons.DEFAULT.toJson(params);
        }
        return this.doPost(url, body);
    }

    Map<String, Object> doPost(String url, String body) {
        Map resp;
        Integer errcode;
        Http http = Http.post((String)url);
        if (!Strings.isNullOrEmpty((String)body)) {
            http.body(body);
        }
        if ((errcode = (Integer)(resp = (Map)http.request(MAP_STRING_OBJ_TYPE)).get("errcode")) != null && errcode != 0) {
            throw new WechatException(resp);
        }
        return resp;
    }

    Map<String, Object> doGet(String url) {
        return this.doGet(url, null);
    }

    Map<String, Object> doGet(String url, Map<String, Object> params) {
        Map resp;
        Integer errcode;
        Http http = Http.get((String)url);
        if (params != null && params.size() > 0) {
            http.body(Jsons.DEFAULT.toJson(params));
        }
        if ((errcode = (Integer)(resp = (Map)http.request(MAP_STRING_OBJ_TYPE)).get("errcode")) != null && errcode != 0) {
            throw new WechatException(resp);
        }
        return resp;
    }

    Map<String, Object> doUpload(String url, String fieldName, String fileName, InputStream input, Map<String, String> params) {
        String json = Http.upload((String)url, (String)fieldName, (String)fileName, (InputStream)input, params);
        Map resp = (Map)Jsons.DEFAULT.fromJson(json, MAP_STRING_OBJ_TYPE);
        Integer errcode = (Integer)resp.get("errcode");
        if (errcode != null && errcode != 0) {
            throw new WechatException(resp);
        }
        return resp;
    }

    <T> void doAsync(final AsyncFunction<T> f) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Object res = f.execute();
                    f.cb.onSuccess(res);
                }
                catch (Exception e) {
                    f.cb.onFailure(e);
                }
            }
        });
    }
}

